/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.rank;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.InsufficientDataException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.OutOfRangeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.rank.PSquarePercentile$1;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.rank.PSquarePercentile$Marker;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.rank.PSquarePercentile$PSquareMarkers;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PSquarePercentile$Markers
implements PSquarePercentile$PSquareMarkers,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int LOW = 2;
    private static final int HIGH = 4;
    private final PSquarePercentile$Marker[] markerArray;
    private transient int k = -1;

    private PSquarePercentile$Markers(PSquarePercentile$Marker[] pSquarePercentile$MarkerArray) {
        MathUtils.checkNotNull(pSquarePercentile$MarkerArray);
        this.markerArray = pSquarePercentile$MarkerArray;
        for (int i2 = 1; i2 < 5; ++i2) {
            PSquarePercentile$Marker.access$200(PSquarePercentile$Marker.access$100(PSquarePercentile$Marker.access$000(this.markerArray[i2], this.markerArray[i2 - 1]), this.markerArray[i2 + 1]), i2);
        }
        PSquarePercentile$Marker.access$200(PSquarePercentile$Marker.access$100(PSquarePercentile$Marker.access$000(this.markerArray[0], this.markerArray[0]), this.markerArray[1]), 0);
        PSquarePercentile$Marker.access$200(PSquarePercentile$Marker.access$100(PSquarePercentile$Marker.access$000(this.markerArray[5], this.markerArray[4]), this.markerArray[5]), 5);
    }

    private PSquarePercentile$Markers(List<Double> list, double d2) {
        this(PSquarePercentile$Markers.createMarkerArray(list, d2));
    }

    private static PSquarePercentile$Marker[] createMarkerArray(List<Double> list, double d2) {
        int n = list == null ? -1 : list.size();
        if (n < 5) {
            throw new InsufficientDataException(LocalizedFormats.INSUFFICIENT_OBSERVED_POINTS_IN_SAMPLE, n, 5);
        }
        Collections.sort(list);
        return new PSquarePercentile$Marker[]{new PSquarePercentile$Marker(null), new PSquarePercentile$Marker(list.get(0), 1.0, 0.0, 1.0, null), new PSquarePercentile$Marker(list.get(1), 1.0 + d2 * 2.0, d2 / 2.0, 2.0, null), new PSquarePercentile$Marker(list.get(2), 1.0 + d2 * 4.0, d2, 3.0, null), new PSquarePercentile$Marker(list.get(3), 3.0 + d2 * 2.0, (d2 + 1.0) / 2.0, 4.0, null), new PSquarePercentile$Marker(list.get(4), 5.0, 1.0, 5.0, null)};
    }

    public int hashCode() {
        return Arrays.deepHashCode(this.markerArray);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && object instanceof PSquarePercentile$Markers) {
            object = (PSquarePercentile$Markers)object;
            bl = Arrays.deepEquals(this.markerArray, ((PSquarePercentile$Markers)object).markerArray);
        }
        return bl;
    }

    @Override
    public double processDataPoint(double d2) {
        int n = this.findCellAndUpdateMinMax(d2);
        this.incrementPositions(1, n + 1, 5);
        this.updateDesiredPositions();
        this.adjustHeightsOfMarkers();
        return this.getPercentileValue();
    }

    @Override
    public double getPercentileValue() {
        return this.height(3);
    }

    private int findCellAndUpdateMinMax(double d2) {
        this.k = -1;
        if (d2 < this.height(1)) {
            PSquarePercentile$Marker.access$502(this.markerArray[1], d2);
            this.k = 1;
        } else if (d2 < this.height(2)) {
            this.k = 1;
        } else if (d2 < this.height(3)) {
            this.k = 2;
        } else if (d2 < this.height(4)) {
            this.k = 3;
        } else if (d2 <= this.height(5)) {
            this.k = 4;
        } else {
            PSquarePercentile$Marker.access$502(this.markerArray[5], d2);
            this.k = 4;
        }
        return this.k;
    }

    private void adjustHeightsOfMarkers() {
        for (int i2 = 2; i2 <= 4; ++i2) {
            this.estimate(i2);
        }
    }

    @Override
    public double estimate(int n) {
        if (n < 2 || n > 4) {
            throw new OutOfRangeException(n, (Number)2, 4);
        }
        return PSquarePercentile$Marker.access$600(this.markerArray[n]);
    }

    private void incrementPositions(int n, int n2, int n3) {
        while (n2 <= n3) {
            PSquarePercentile$Marker.access$700(this.markerArray[n2], n);
            ++n2;
        }
    }

    private void updateDesiredPositions() {
        for (int i2 = 1; i2 < this.markerArray.length; ++i2) {
            PSquarePercentile$Marker.access$800(this.markerArray[i2]);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        for (int i2 = 1; i2 < 5; ++i2) {
            PSquarePercentile$Marker.access$200(PSquarePercentile$Marker.access$100(PSquarePercentile$Marker.access$000(this.markerArray[i2], this.markerArray[i2 - 1]), this.markerArray[i2 + 1]), i2);
        }
        PSquarePercentile$Marker.access$200(PSquarePercentile$Marker.access$100(PSquarePercentile$Marker.access$000(this.markerArray[0], this.markerArray[0]), this.markerArray[1]), 0);
        PSquarePercentile$Marker.access$200(PSquarePercentile$Marker.access$100(PSquarePercentile$Marker.access$000(this.markerArray[5], this.markerArray[4]), this.markerArray[5]), 5);
    }

    @Override
    public double height(int n) {
        if (n >= this.markerArray.length || n <= 0) {
            throw new OutOfRangeException(n, (Number)1, this.markerArray.length);
        }
        return PSquarePercentile$Marker.access$500(this.markerArray[n]);
    }

    @Override
    public Object clone() {
        return new PSquarePercentile$Markers(new PSquarePercentile$Marker[]{new PSquarePercentile$Marker(null), (PSquarePercentile$Marker)this.markerArray[1].clone(), (PSquarePercentile$Marker)this.markerArray[2].clone(), (PSquarePercentile$Marker)this.markerArray[3].clone(), (PSquarePercentile$Marker)this.markerArray[4].clone(), (PSquarePercentile$Marker)this.markerArray[5].clone()});
    }

    public String toString() {
        return String.format("m1=[%s],m2=[%s],m3=[%s],m4=[%s],m5=[%s]", this.markerArray[1].toString(), this.markerArray[2].toString(), this.markerArray[3].toString(), this.markerArray[4].toString(), this.markerArray[5].toString());
    }

    /* synthetic */ PSquarePercentile$Markers(List list, double d2, PSquarePercentile$1 pSquarePercentile$1) {
        this(list, d2);
    }
}

