/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.rank;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.AbstractStorelessUnivariateStatistic;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;
import java.io.Serializable;

public class Min
extends AbstractStorelessUnivariateStatistic
implements Serializable {
    private static final long serialVersionUID = -2941995784909003131L;
    private long n;
    private double value;

    public Min() {
        this.n = 0L;
        this.value = Double.NaN;
    }

    public Min(Min min) {
        Min.copy(min, this);
    }

    public void increment(double d2) {
        if (d2 < this.value || Double.isNaN(this.value)) {
            this.value = d2;
        }
        ++this.n;
    }

    public void clear() {
        this.value = Double.NaN;
        this.n = 0L;
    }

    public double getResult() {
        return this.value;
    }

    public long getN() {
        return this.n;
    }

    public double evaluate(double[] dArray, int n, int n2) {
        double d2 = Double.NaN;
        if (this.test(dArray, n, n2)) {
            d2 = dArray[n];
            for (int i2 = n; i2 < n + n2; ++i2) {
                if (Double.isNaN(dArray[i2])) continue;
                d2 = d2 < dArray[i2] ? d2 : dArray[i2];
            }
        }
        return d2;
    }

    public Min copy() {
        Min min = new Min();
        Min.copy(this, min);
        return min;
    }

    public static void copy(Min min, Min min2) {
        MathUtils.checkNotNull(min);
        MathUtils.checkNotNull(min2);
        min2.setData(min.getDataRef());
        min2.n = min.n;
        min2.value = min.value;
    }
}

