/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.moment;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.AbstractStorelessUnivariateStatistic;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.moment.Mean;
import java.io.Serializable;
import java.util.Arrays;

public class VectorialMean
implements Serializable {
    private static final long serialVersionUID = 8223009086481006892L;
    private final Mean[] means;

    public VectorialMean(int n) {
        this.means = new Mean[n];
        for (int i2 = 0; i2 < n; ++i2) {
            this.means[i2] = new Mean();
        }
    }

    public void increment(double[] dArray) {
        if (dArray.length != this.means.length) {
            throw new DimensionMismatchException(dArray.length, this.means.length);
        }
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            ((AbstractStorelessUnivariateStatistic)this.means[i2]).increment(dArray[i2]);
        }
    }

    public double[] getResult() {
        double[] dArray = new double[this.means.length];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            dArray[i2] = ((AbstractStorelessUnivariateStatistic)this.means[i2]).getResult();
        }
        return dArray;
    }

    public long getN() {
        if (this.means.length == 0) {
            return 0L;
        }
        return this.means[0].getN();
    }

    public int hashCode() {
        int n = 31 + Arrays.hashCode(this.means);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof VectorialMean)) {
            return false;
        }
        object = (VectorialMean)object;
        return Arrays.equals(this.means, ((VectorialMean)object).means);
    }
}

