/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.moment;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.MatrixUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrix;
import java.io.Serializable;
import java.util.Arrays;

public class VectorialCovariance
implements Serializable {
    private static final long serialVersionUID = 4118372414238930270L;
    private final double[] sums;
    private final double[] productsSums;
    private final boolean isBiasCorrected;
    private long n;

    public VectorialCovariance(int n, boolean bl) {
        this.sums = new double[n];
        int n2 = n;
        this.productsSums = new double[n2 * (n2 + 1) / 2];
        this.n = 0L;
        this.isBiasCorrected = bl;
    }

    public void increment(double[] dArray) {
        if (dArray.length != this.sums.length) {
            throw new DimensionMismatchException(dArray.length, this.sums.length);
        }
        int n = 0;
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            int n2 = i2;
            this.sums[n2] = this.sums[n2] + dArray[i2];
            for (int i3 = 0; i3 <= i2; ++i3) {
                int n3 = n++;
                this.productsSums[n3] = this.productsSums[n3] + dArray[i2] * dArray[i3];
            }
        }
        ++this.n;
    }

    public RealMatrix getResult() {
        int n = this.sums.length;
        RealMatrix realMatrix = MatrixUtils.createRealMatrix(n, n);
        if (this.n > 1L) {
            double d2 = 1.0 / (double)(this.n * (this.isBiasCorrected ? this.n - 1L : this.n));
            int n2 = 0;
            for (int i2 = 0; i2 < n; ++i2) {
                for (int i3 = 0; i3 <= i2; ++i3) {
                    double d3 = d2 * ((double)this.n * this.productsSums[n2++] - this.sums[i2] * this.sums[i3]);
                    realMatrix.setEntry(i2, i3, d3);
                    realMatrix.setEntry(i3, i2, d3);
                }
            }
        }
        return realMatrix;
    }

    public long getN() {
        return this.n;
    }

    public void clear() {
        this.n = 0L;
        Arrays.fill(this.sums, 0.0);
        Arrays.fill(this.productsSums, 0.0);
    }

    public int hashCode() {
        int n = 31 + (this.isBiasCorrected ? 1231 : 1237);
        n = n * 31 + (int)(this.n ^ this.n >>> 32);
        n = n * 31 + Arrays.hashCode(this.productsSums);
        n = n * 31 + Arrays.hashCode(this.sums);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof VectorialCovariance)) {
            return false;
        }
        object = (VectorialCovariance)object;
        if (this.isBiasCorrected != ((VectorialCovariance)object).isBiasCorrected) {
            return false;
        }
        if (this.n != ((VectorialCovariance)object).n) {
            return false;
        }
        if (!Arrays.equals(this.productsSums, ((VectorialCovariance)object).productsSums)) {
            return false;
        }
        return Arrays.equals(this.sums, ((VectorialCovariance)object).sums);
    }
}

