/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.moment;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NullArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.AbstractStorelessUnivariateStatistic;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.AbstractUnivariateStatistic;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.WeightedEvaluation;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.moment.Mean;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.moment.SecondMoment;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;
import java.io.Serializable;

public class Variance
extends AbstractStorelessUnivariateStatistic
implements WeightedEvaluation,
Serializable {
    private static final long serialVersionUID = -9111962718267217978L;
    protected SecondMoment moment = null;
    protected boolean incMoment = true;
    private boolean isBiasCorrected = true;

    public Variance() {
        this.moment = new SecondMoment();
    }

    public Variance(SecondMoment secondMoment) {
        this.incMoment = false;
        this.moment = secondMoment;
    }

    public Variance(boolean bl) {
        this.moment = new SecondMoment();
        this.isBiasCorrected = bl;
    }

    public Variance(boolean bl, SecondMoment secondMoment) {
        this.incMoment = false;
        this.moment = secondMoment;
        this.isBiasCorrected = bl;
    }

    public Variance(Variance variance) {
        Variance.copy(variance, this);
    }

    public void increment(double d2) {
        if (this.incMoment) {
            ((AbstractStorelessUnivariateStatistic)this.moment).increment(d2);
        }
    }

    public double getResult() {
        if (this.moment.n == 0L) {
            return Double.NaN;
        }
        if (this.moment.n == 1L) {
            return 0.0;
        }
        if (this.isBiasCorrected) {
            return this.moment.m2 / ((double)this.moment.n - 1.0);
        }
        return this.moment.m2 / (double)this.moment.n;
    }

    public long getN() {
        return this.moment.getN();
    }

    public void clear() {
        if (this.incMoment) {
            ((AbstractStorelessUnivariateStatistic)this.moment).clear();
        }
    }

    public double evaluate(double[] dArray) {
        if (dArray == null) {
            throw new NullArgumentException(LocalizedFormats.INPUT_ARRAY, new Object[0]);
        }
        return ((AbstractUnivariateStatistic)this).evaluate(dArray, 0, dArray.length);
    }

    public double evaluate(double[] dArray, int n, int n2) {
        double d2 = Double.NaN;
        if (this.test(dArray, n, n2)) {
            ((AbstractStorelessUnivariateStatistic)this).clear();
            if (n2 == 1) {
                d2 = 0.0;
            } else if (n2 > 1) {
                Mean mean = new Mean();
                double d3 = ((AbstractUnivariateStatistic)mean).evaluate(dArray, n, n2);
                d2 = this.evaluate(dArray, d3, n, n2);
            }
        }
        return d2;
    }

    public double evaluate(double[] dArray, double[] dArray2, int n, int n2) {
        double d2 = Double.NaN;
        if (this.test(dArray, dArray2, n, n2)) {
            ((AbstractStorelessUnivariateStatistic)this).clear();
            if (n2 == 1) {
                d2 = 0.0;
            } else if (n2 > 1) {
                Mean mean = new Mean();
                double d3 = mean.evaluate(dArray, dArray2, n, n2);
                d2 = this.evaluate(dArray, dArray2, d3, n, n2);
            }
        }
        return d2;
    }

    public double evaluate(double[] dArray, double[] dArray2) {
        return this.evaluate(dArray, dArray2, 0, dArray.length);
    }

    public double evaluate(double[] dArray, double d2, int n, int n2) {
        double d3 = Double.NaN;
        if (this.test(dArray, n, n2)) {
            if (n2 == 1) {
                d3 = 0.0;
            } else if (n2 > 1) {
                double d4 = 0.0;
                double d5 = 0.0;
                for (int i2 = n; i2 < n + n2; ++i2) {
                    double d6;
                    double d7 = d6 = dArray[i2] - d2;
                    d4 += d7 * d7;
                    d5 += d6;
                }
                double d8 = n2;
                if (this.isBiasCorrected) {
                    double d9 = d5;
                    d3 = (d4 - d9 * d9 / d8) / (d8 - 1.0);
                } else {
                    double d10 = d5;
                    d3 = (d4 - d10 * d10 / d8) / d8;
                }
            }
        }
        return d3;
    }

    public double evaluate(double[] dArray, double d2) {
        return this.evaluate(dArray, d2, 0, dArray.length);
    }

    public double evaluate(double[] dArray, double[] dArray2, double d2, int n, int n2) {
        double d3 = Double.NaN;
        if (this.test(dArray, dArray2, n, n2)) {
            if (n2 == 1) {
                d3 = 0.0;
            } else if (n2 > 1) {
                double d4 = 0.0;
                double d5 = 0.0;
                for (int i2 = n; i2 < n + n2; ++i2) {
                    double d6;
                    double d7 = d6 = dArray[i2] - d2;
                    d4 += dArray2[i2] * (d7 * d7);
                    d5 += dArray2[i2] * d6;
                }
                double d8 = 0.0;
                for (int i3 = n; i3 < n + n2; ++i3) {
                    d8 += dArray2[i3];
                }
                if (this.isBiasCorrected) {
                    double d9 = d5;
                    d3 = (d4 - d9 * d9 / d8) / (d8 - 1.0);
                } else {
                    double d10 = d5;
                    d3 = (d4 - d10 * d10 / d8) / d8;
                }
            }
        }
        return d3;
    }

    public double evaluate(double[] dArray, double[] dArray2, double d2) {
        return this.evaluate(dArray, dArray2, d2, 0, dArray.length);
    }

    public boolean isBiasCorrected() {
        return this.isBiasCorrected;
    }

    public void setBiasCorrected(boolean bl) {
        this.isBiasCorrected = bl;
    }

    public Variance copy() {
        Variance variance = new Variance();
        Variance.copy(this, variance);
        return variance;
    }

    public static void copy(Variance variance, Variance variance2) {
        MathUtils.checkNotNull(variance);
        MathUtils.checkNotNull(variance2);
        variance2.setData(variance.getDataRef());
        variance2.moment = variance.moment.copy();
        variance2.isBiasCorrected = variance.isBiasCorrected;
        variance2.incMoment = variance.incMoment;
    }
}

