/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.moment;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.AbstractStorelessUnivariateStatistic;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.AbstractUnivariateStatistic;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.moment.Mean;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.moment.ThirdMoment;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;
import java.io.Serializable;

public class Skewness
extends AbstractStorelessUnivariateStatistic
implements Serializable {
    private static final long serialVersionUID = 7101857578996691352L;
    protected ThirdMoment moment = null;
    protected boolean incMoment;

    public Skewness() {
        this.incMoment = true;
        this.moment = new ThirdMoment();
    }

    public Skewness(ThirdMoment thirdMoment) {
        this.incMoment = false;
        this.moment = thirdMoment;
    }

    public Skewness(Skewness skewness) {
        Skewness.copy(skewness, this);
    }

    public void increment(double d2) {
        if (this.incMoment) {
            ((AbstractStorelessUnivariateStatistic)this.moment).increment(d2);
        }
    }

    public double getResult() {
        double d2;
        if (this.moment.n < 3L) {
            return Double.NaN;
        }
        double d3 = this.moment.m2 / (double)(this.moment.n - 1L);
        if (d2 < 1.0E-19) {
            return 0.0;
        }
        double d4 = this.moment.getN();
        return d4 * this.moment.m3 / ((d4 - 1.0) * (d4 - 2.0) * FastMath.sqrt(d3) * d3);
    }

    public long getN() {
        return this.moment.getN();
    }

    public void clear() {
        if (this.incMoment) {
            ((AbstractStorelessUnivariateStatistic)this.moment).clear();
        }
    }

    public double evaluate(double[] dArray, int n, int n2) {
        double d2 = Double.NaN;
        if (this.test(dArray, n, n2) && n2 > 2) {
            Mean mean = new Mean();
            double d3 = ((AbstractUnivariateStatistic)mean).evaluate(dArray, n, n2);
            double d4 = 0.0;
            double d5 = 0.0;
            for (int i2 = n; i2 < n + n2; ++i2) {
                double d6;
                double d7 = d6 = dArray[i2] - d3;
                d4 += d7 * d7;
                d5 += d6;
            }
            double d8 = d5;
            double d9 = (d4 - d8 * d8 / (double)n2) / (double)(n2 - 1);
            double d10 = 0.0;
            for (int i3 = n; i3 < n + n2; ++i3) {
                double d11;
                double d12 = d11 = dArray[i3] - d3;
                d10 += d12 * d12 * d11;
            }
            double d13 = d9;
            double d14 = n2;
            d2 = d14 / ((d14 - 1.0) * (d14 - 2.0)) * (d10 /= d13 * FastMath.sqrt(d13));
        }
        return d2;
    }

    public Skewness copy() {
        Skewness skewness = new Skewness();
        Skewness.copy(this, skewness);
        return skewness;
    }

    public static void copy(Skewness skewness, Skewness skewness2) {
        MathUtils.checkNotNull(skewness);
        MathUtils.checkNotNull(skewness2);
        skewness2.setData(skewness.getDataRef());
        skewness2.moment = new ThirdMoment(skewness.moment.copy());
        skewness2.incMoment = skewness.incMoment;
    }
}

