/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.moment;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.AbstractUnivariateStatistic;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.moment.Mean;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.moment.SemiVariance$Direction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;
import java.io.Serializable;

public class SemiVariance
extends AbstractUnivariateStatistic
implements Serializable {
    public static final SemiVariance$Direction UPSIDE_VARIANCE = SemiVariance$Direction.UPSIDE;
    public static final SemiVariance$Direction DOWNSIDE_VARIANCE = SemiVariance$Direction.DOWNSIDE;
    private static final long serialVersionUID = -2653430366886024994L;
    private boolean biasCorrected = true;
    private SemiVariance$Direction varianceDirection = SemiVariance$Direction.DOWNSIDE;

    public SemiVariance() {
    }

    public SemiVariance(boolean bl) {
        this.biasCorrected = bl;
    }

    public SemiVariance(SemiVariance$Direction semiVariance$Direction) {
        this.varianceDirection = semiVariance$Direction;
    }

    public SemiVariance(boolean bl, SemiVariance$Direction semiVariance$Direction) {
        this.biasCorrected = bl;
        this.varianceDirection = semiVariance$Direction;
    }

    public SemiVariance(SemiVariance semiVariance) {
        SemiVariance.copy(semiVariance, this);
    }

    public SemiVariance copy() {
        SemiVariance semiVariance = new SemiVariance();
        SemiVariance.copy(this, semiVariance);
        return semiVariance;
    }

    public static void copy(SemiVariance semiVariance, SemiVariance semiVariance2) {
        MathUtils.checkNotNull(semiVariance);
        MathUtils.checkNotNull(semiVariance2);
        semiVariance2.setData(semiVariance.getDataRef());
        semiVariance2.biasCorrected = semiVariance.biasCorrected;
        semiVariance2.varianceDirection = semiVariance.varianceDirection;
    }

    public double evaluate(double[] dArray, int n, int n2) {
        double d2 = ((AbstractUnivariateStatistic)new Mean()).evaluate(dArray, n, n2);
        return this.evaluate(dArray, d2, this.varianceDirection, this.biasCorrected, 0, dArray.length);
    }

    public double evaluate(double[] dArray, SemiVariance$Direction semiVariance$Direction) {
        double d2 = ((AbstractUnivariateStatistic)new Mean()).evaluate(dArray);
        return this.evaluate(dArray, d2, semiVariance$Direction, this.biasCorrected, 0, dArray.length);
    }

    public double evaluate(double[] dArray, double d2) {
        return this.evaluate(dArray, d2, this.varianceDirection, this.biasCorrected, 0, dArray.length);
    }

    public double evaluate(double[] dArray, double d2, SemiVariance$Direction semiVariance$Direction) {
        return this.evaluate(dArray, d2, semiVariance$Direction, this.biasCorrected, 0, dArray.length);
    }

    public double evaluate(double[] dArray, double d2, SemiVariance$Direction semiVariance$Direction, boolean bl, int n, int n2) {
        this.test(dArray, n, n2);
        if (dArray.length == 0) {
            return Double.NaN;
        }
        if (dArray.length == 1) {
            return 0.0;
        }
        boolean bl2 = semiVariance$Direction.getDirection();
        double d3 = 0.0;
        while (n < n2) {
            if (dArray[n] > d2 == bl2) {
                double d4;
                double d5 = d4 = dArray[n] - d2;
                d3 += d5 * d5;
            }
            ++n;
        }
        if (bl) {
            return d3 / ((double)n2 - 1.0);
        }
        return d3 / (double)n2;
    }

    public boolean isBiasCorrected() {
        return this.biasCorrected;
    }

    public void setBiasCorrected(boolean bl) {
        this.biasCorrected = bl;
    }

    public SemiVariance$Direction getVarianceDirection() {
        return this.varianceDirection;
    }

    public void setVarianceDirection(SemiVariance$Direction semiVariance$Direction) {
        this.varianceDirection = semiVariance$Direction;
    }
}

