/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.moment;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.moment.FirstMoment;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;
import java.io.Serializable;

public class SecondMoment
extends FirstMoment
implements Serializable {
    private static final long serialVersionUID = 3942403127395076445L;
    protected double m2;

    public SecondMoment() {
        this.m2 = Double.NaN;
    }

    public SecondMoment(SecondMoment secondMoment) {
        super(secondMoment);
        this.m2 = secondMoment.m2;
    }

    public void increment(double d2) {
        if (this.n < 1L) {
            SecondMoment secondMoment = this;
            secondMoment.m2 = 0.0;
            secondMoment.m1 = 0.0;
        }
        super.increment(d2);
        this.m2 += ((double)this.n - 1.0) * this.dev * this.nDev;
    }

    public void clear() {
        super.clear();
        this.m2 = Double.NaN;
    }

    public double getResult() {
        return this.m2;
    }

    public SecondMoment copy() {
        SecondMoment secondMoment = new SecondMoment();
        SecondMoment.copy(this, secondMoment);
        return secondMoment;
    }

    public static void copy(SecondMoment secondMoment, SecondMoment secondMoment2) {
        MathUtils.checkNotNull(secondMoment);
        MathUtils.checkNotNull(secondMoment2);
        FirstMoment.copy(secondMoment, secondMoment2);
        secondMoment2.m2 = secondMoment.m2;
    }
}

