/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.moment;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.AbstractStorelessUnivariateStatistic;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.AbstractUnivariateStatistic;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.WeightedEvaluation;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.moment.FirstMoment;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.summary.Sum;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;
import java.io.Serializable;

public class Mean
extends AbstractStorelessUnivariateStatistic
implements WeightedEvaluation,
Serializable {
    private static final long serialVersionUID = -1296043746617791564L;
    protected FirstMoment moment;
    protected boolean incMoment;

    public Mean() {
        this.incMoment = true;
        this.moment = new FirstMoment();
    }

    public Mean(FirstMoment firstMoment) {
        this.moment = firstMoment;
        this.incMoment = false;
    }

    public Mean(Mean mean) {
        Mean.copy(mean, this);
    }

    public void increment(double d2) {
        if (this.incMoment) {
            ((AbstractStorelessUnivariateStatistic)this.moment).increment(d2);
        }
    }

    public void clear() {
        if (this.incMoment) {
            ((AbstractStorelessUnivariateStatistic)this.moment).clear();
        }
    }

    public double getResult() {
        return this.moment.m1;
    }

    public long getN() {
        return this.moment.getN();
    }

    public double evaluate(double[] dArray, int n, int n2) {
        if (this.test(dArray, n, n2)) {
            Sum sum = new Sum();
            double d2 = n2;
            double d3 = ((AbstractUnivariateStatistic)sum).evaluate(dArray, n, n2) / d2;
            double d4 = 0.0;
            for (int i2 = n; i2 < n + n2; ++i2) {
                d4 += dArray[i2] - d3;
            }
            return d3 + d4 / d2;
        }
        return Double.NaN;
    }

    public double evaluate(double[] dArray, double[] dArray2, int n, int n2) {
        if (this.test(dArray, dArray2, n, n2)) {
            Sum sum = new Sum();
            double d2 = ((AbstractUnivariateStatistic)sum).evaluate(dArray2, n, n2);
            double d3 = sum.evaluate(dArray, dArray2, n, n2) / d2;
            double d4 = 0.0;
            for (int i2 = n; i2 < n + n2; ++i2) {
                d4 += dArray2[i2] * (dArray[i2] - d3);
            }
            return d3 + d4 / d2;
        }
        return Double.NaN;
    }

    public double evaluate(double[] dArray, double[] dArray2) {
        return this.evaluate(dArray, dArray2, 0, dArray.length);
    }

    public Mean copy() {
        Mean mean = new Mean();
        Mean.copy(this, mean);
        return mean;
    }

    public static void copy(Mean mean, Mean mean2) {
        MathUtils.checkNotNull(mean);
        MathUtils.checkNotNull(mean2);
        mean2.setData(mean.getDataRef());
        mean2.incMoment = mean.incMoment;
        mean2.moment = mean.moment.copy();
    }
}

