/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.moment;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.AbstractStorelessUnivariateStatistic;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.moment.FourthMoment;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.moment.Variance;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;
import java.io.Serializable;

public class Kurtosis
extends AbstractStorelessUnivariateStatistic
implements Serializable {
    private static final long serialVersionUID = 2784465764798260919L;
    protected FourthMoment moment;
    protected boolean incMoment;

    public Kurtosis() {
        this.incMoment = true;
        this.moment = new FourthMoment();
    }

    public Kurtosis(FourthMoment fourthMoment) {
        this.incMoment = false;
        this.moment = fourthMoment;
    }

    public Kurtosis(Kurtosis kurtosis) {
        Kurtosis.copy(kurtosis, this);
    }

    public void increment(double d2) {
        if (this.incMoment) {
            ((AbstractStorelessUnivariateStatistic)this.moment).increment(d2);
        }
    }

    public double getResult() {
        double d2 = Double.NaN;
        if (this.moment.getN() > 3L) {
            double d3 = this.moment.m2 / (double)(this.moment.n - 1L);
            if (this.moment.n <= 3L || d3 < 1.0E-19) {
                d2 = 0.0;
            } else {
                double d4 = this.moment.n;
                d2 = (d4 * (d4 + 1.0) * ((AbstractStorelessUnivariateStatistic)this.moment).getResult() - 3.0 * this.moment.m2 * this.moment.m2 * (d4 - 1.0)) / ((d4 - 1.0) * (d4 - 2.0) * (d4 - 3.0) * d3 * d3);
            }
        }
        return d2;
    }

    public void clear() {
        if (this.incMoment) {
            ((AbstractStorelessUnivariateStatistic)this.moment).clear();
        }
    }

    public long getN() {
        return this.moment.getN();
    }

    public double evaluate(double[] dArray, int n, int n2) {
        double d2 = Double.NaN;
        if (this.test(dArray, n, n2) && n2 > 3) {
            Variance variance = new Variance();
            variance.incrementAll(dArray, n, n2);
            double d3 = variance.moment.m1;
            double d4 = FastMath.sqrt(((AbstractStorelessUnivariateStatistic)variance).getResult());
            double d5 = 0.0;
            for (int i2 = n; i2 < n + n2; ++i2) {
                d5 += FastMath.pow(dArray[i2] - d3, 4.0);
            }
            double d6 = n2;
            double d7 = d6 * (d6 + 1.0) / ((d6 - 1.0) * (d6 - 2.0) * (d6 - 3.0));
            double d8 = 3.0 * FastMath.pow(d6 - 1.0, 2.0) / ((d6 - 2.0) * (d6 - 3.0));
            d2 = d7 * (d5 /= FastMath.pow(d4, 4.0)) - d8;
        }
        return d2;
    }

    public Kurtosis copy() {
        Kurtosis kurtosis = new Kurtosis();
        Kurtosis.copy(this, kurtosis);
        return kurtosis;
    }

    public static void copy(Kurtosis kurtosis, Kurtosis kurtosis2) {
        MathUtils.checkNotNull(kurtosis);
        MathUtils.checkNotNull(kurtosis2);
        kurtosis2.setData(kurtosis.getDataRef());
        kurtosis2.moment = kurtosis.moment.copy();
        kurtosis2.incMoment = kurtosis.incMoment;
    }
}

