/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.StatisticalSummary;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Precision;
import java.io.Serializable;

public class StatisticalSummaryValues
implements StatisticalSummary,
Serializable {
    private static final long serialVersionUID = -5108854841843722536L;
    private final double mean;
    private final double variance;
    private final long n;
    private final double max;
    private final double min;
    private final double sum;

    public StatisticalSummaryValues(double d2, double d3, long l, double d4, double d5, double d6) {
        this.mean = d2;
        this.variance = d3;
        this.n = l;
        this.max = d4;
        this.min = d5;
        this.sum = d6;
    }

    public double getMax() {
        return this.max;
    }

    public double getMean() {
        return this.mean;
    }

    public double getMin() {
        return this.min;
    }

    public long getN() {
        return this.n;
    }

    public double getSum() {
        return this.sum;
    }

    public double getStandardDeviation() {
        return FastMath.sqrt(this.variance);
    }

    public double getVariance() {
        return this.variance;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StatisticalSummaryValues)) {
            return false;
        }
        return Precision.equalsIncludingNaN(((StatisticalSummaryValues)(object = (StatisticalSummaryValues)object)).getMax(), this.getMax()) && Precision.equalsIncludingNaN(((StatisticalSummaryValues)object).getMean(), this.getMean()) && Precision.equalsIncludingNaN(((StatisticalSummaryValues)object).getMin(), this.getMin()) && Precision.equalsIncludingNaN(((StatisticalSummaryValues)object).getN(), this.getN()) && Precision.equalsIncludingNaN(((StatisticalSummaryValues)object).getSum(), this.getSum()) && Precision.equalsIncludingNaN(((StatisticalSummaryValues)object).getVariance(), this.getVariance());
    }

    public int hashCode() {
        int n = 31 + MathUtils.hash(this.getMax());
        n = n * 31 + MathUtils.hash(this.getMean());
        n = n * 31 + MathUtils.hash(this.getMin());
        n = n * 31 + MathUtils.hash(this.getN());
        n = n * 31 + MathUtils.hash(this.getSum());
        n = n * 31 + MathUtils.hash(this.getVariance());
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "\n";
        stringBuffer.append("StatisticalSummaryValues:").append(string);
        stringBuffer.append("n: ").append(this.getN()).append(string);
        stringBuffer.append("min: ").append(this.getMin()).append(string);
        stringBuffer.append("max: ").append(this.getMax()).append(string);
        stringBuffer.append("mean: ").append(this.getMean()).append(string);
        stringBuffer.append("std dev: ").append(this.getStandardDeviation()).append(string);
        stringBuffer.append("variance: ").append(this.getVariance()).append(string);
        stringBuffer.append("sum: ").append(this.getSum()).append(string);
        return stringBuffer.toString();
    }
}

