/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathIllegalStateException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.StatisticalMultivariateSummary;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.StorelessUnivariateStatistic;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.moment.GeometricMean;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.moment.Mean;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.moment.VectorialCovariance;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.rank.Max;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.rank.Min;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.summary.Sum;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.summary.SumOfLogs;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.summary.SumOfSquares;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Precision;
import java.io.Serializable;
import java.util.Arrays;

public class MultivariateSummaryStatistics
implements StatisticalMultivariateSummary,
Serializable {
    private static final long serialVersionUID = 2271900808994826718L;
    private int k;
    private long n = 0L;
    private StorelessUnivariateStatistic[] sumImpl;
    private StorelessUnivariateStatistic[] sumSqImpl;
    private StorelessUnivariateStatistic[] minImpl;
    private StorelessUnivariateStatistic[] maxImpl;
    private StorelessUnivariateStatistic[] sumLogImpl;
    private StorelessUnivariateStatistic[] geoMeanImpl;
    private StorelessUnivariateStatistic[] meanImpl;
    private VectorialCovariance covarianceImpl;

    public MultivariateSummaryStatistics(int n, boolean bl) {
        this.k = n;
        this.sumImpl = new StorelessUnivariateStatistic[n];
        this.sumSqImpl = new StorelessUnivariateStatistic[n];
        this.minImpl = new StorelessUnivariateStatistic[n];
        this.maxImpl = new StorelessUnivariateStatistic[n];
        this.sumLogImpl = new StorelessUnivariateStatistic[n];
        this.geoMeanImpl = new StorelessUnivariateStatistic[n];
        this.meanImpl = new StorelessUnivariateStatistic[n];
        for (int i2 = 0; i2 < n; ++i2) {
            this.sumImpl[i2] = new Sum();
            this.sumSqImpl[i2] = new SumOfSquares();
            this.minImpl[i2] = new Min();
            this.maxImpl[i2] = new Max();
            this.sumLogImpl[i2] = new SumOfLogs();
            this.geoMeanImpl[i2] = new GeometricMean();
            this.meanImpl[i2] = new Mean();
        }
        this.covarianceImpl = new VectorialCovariance(n, bl);
    }

    public void addValue(double[] dArray) {
        this.checkDimension(dArray.length);
        for (int i2 = 0; i2 < this.k; ++i2) {
            double d2 = dArray[i2];
            this.sumImpl[i2].increment(d2);
            this.sumSqImpl[i2].increment(d2);
            this.minImpl[i2].increment(d2);
            this.maxImpl[i2].increment(d2);
            this.sumLogImpl[i2].increment(d2);
            this.geoMeanImpl[i2].increment(d2);
            this.meanImpl[i2].increment(d2);
        }
        this.covarianceImpl.increment(dArray);
        ++this.n;
    }

    public int getDimension() {
        return this.k;
    }

    public long getN() {
        return this.n;
    }

    private double[] getResults(StorelessUnivariateStatistic[] storelessUnivariateStatisticArray) {
        double[] dArray = new double[storelessUnivariateStatisticArray.length];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            dArray[i2] = storelessUnivariateStatisticArray[i2].getResult();
        }
        return dArray;
    }

    public double[] getSum() {
        MultivariateSummaryStatistics multivariateSummaryStatistics = this;
        return multivariateSummaryStatistics.getResults(multivariateSummaryStatistics.sumImpl);
    }

    public double[] getSumSq() {
        MultivariateSummaryStatistics multivariateSummaryStatistics = this;
        return multivariateSummaryStatistics.getResults(multivariateSummaryStatistics.sumSqImpl);
    }

    public double[] getSumLog() {
        MultivariateSummaryStatistics multivariateSummaryStatistics = this;
        return multivariateSummaryStatistics.getResults(multivariateSummaryStatistics.sumLogImpl);
    }

    public double[] getMean() {
        MultivariateSummaryStatistics multivariateSummaryStatistics = this;
        return multivariateSummaryStatistics.getResults(multivariateSummaryStatistics.meanImpl);
    }

    public double[] getStandardDeviation() {
        double[] dArray = new double[this.k];
        if (this.getN() < 1L) {
            Arrays.fill(dArray, Double.NaN);
        } else if (this.getN() < 2L) {
            Arrays.fill(dArray, 0.0);
        } else {
            RealMatrix realMatrix = this.covarianceImpl.getResult();
            for (int i2 = 0; i2 < this.k; ++i2) {
                int n = i2;
                dArray[i2] = FastMath.sqrt(realMatrix.getEntry(n, n));
            }
        }
        return dArray;
    }

    public RealMatrix getCovariance() {
        return this.covarianceImpl.getResult();
    }

    public double[] getMax() {
        MultivariateSummaryStatistics multivariateSummaryStatistics = this;
        return multivariateSummaryStatistics.getResults(multivariateSummaryStatistics.maxImpl);
    }

    public double[] getMin() {
        MultivariateSummaryStatistics multivariateSummaryStatistics = this;
        return multivariateSummaryStatistics.getResults(multivariateSummaryStatistics.minImpl);
    }

    public double[] getGeometricMean() {
        MultivariateSummaryStatistics multivariateSummaryStatistics = this;
        return multivariateSummaryStatistics.getResults(multivariateSummaryStatistics.geoMeanImpl);
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("MultivariateSummaryStatistics:" + string);
        stringBuilder.append("n: " + this.getN() + string);
        this.append(stringBuilder, this.getMin(), "min: ", ", ", string);
        this.append(stringBuilder, this.getMax(), "max: ", ", ", string);
        this.append(stringBuilder, this.getMean(), "mean: ", ", ", string);
        this.append(stringBuilder, this.getGeometricMean(), "geometric mean: ", ", ", string);
        this.append(stringBuilder, this.getSumSq(), "sum of squares: ", ", ", string);
        this.append(stringBuilder, this.getSumLog(), "sum of logarithms: ", ", ", string);
        this.append(stringBuilder, this.getStandardDeviation(), "standard deviation: ", ", ", string);
        stringBuilder.append("covariance: " + this.getCovariance().toString() + string);
        return stringBuilder.toString();
    }

    private void append(StringBuilder stringBuilder, double[] dArray, String string, String string2, String string3) {
        stringBuilder.append(string);
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(string2);
            }
            stringBuilder.append(dArray[i2]);
        }
        stringBuilder.append(string3);
    }

    public void clear() {
        this.n = 0L;
        for (int i2 = 0; i2 < this.k; ++i2) {
            this.minImpl[i2].clear();
            this.maxImpl[i2].clear();
            this.sumImpl[i2].clear();
            this.sumLogImpl[i2].clear();
            this.sumSqImpl[i2].clear();
            this.geoMeanImpl[i2].clear();
            this.meanImpl[i2].clear();
        }
        this.covarianceImpl.clear();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MultivariateSummaryStatistics)) {
            return false;
        }
        return MathArrays.equalsIncludingNaN(((MultivariateSummaryStatistics)(object = (MultivariateSummaryStatistics)object)).getGeometricMean(), this.getGeometricMean()) && MathArrays.equalsIncludingNaN(((MultivariateSummaryStatistics)object).getMax(), this.getMax()) && MathArrays.equalsIncludingNaN(((MultivariateSummaryStatistics)object).getMean(), this.getMean()) && MathArrays.equalsIncludingNaN(((MultivariateSummaryStatistics)object).getMin(), this.getMin()) && Precision.equalsIncludingNaN(((MultivariateSummaryStatistics)object).getN(), this.getN()) && MathArrays.equalsIncludingNaN(((MultivariateSummaryStatistics)object).getSum(), this.getSum()) && MathArrays.equalsIncludingNaN(((MultivariateSummaryStatistics)object).getSumSq(), this.getSumSq()) && MathArrays.equalsIncludingNaN(((MultivariateSummaryStatistics)object).getSumLog(), this.getSumLog()) && ((MultivariateSummaryStatistics)object).getCovariance().equals(this.getCovariance());
    }

    public int hashCode() {
        int n = 31 + MathUtils.hash(this.getGeometricMean());
        n = n * 31 + MathUtils.hash(this.getGeometricMean());
        n = n * 31 + MathUtils.hash(this.getMax());
        n = n * 31 + MathUtils.hash(this.getMean());
        n = n * 31 + MathUtils.hash(this.getMin());
        n = n * 31 + MathUtils.hash(this.getN());
        n = n * 31 + MathUtils.hash(this.getSum());
        n = n * 31 + MathUtils.hash(this.getSumSq());
        n = n * 31 + MathUtils.hash(this.getSumLog());
        n = n * 31 + this.getCovariance().hashCode();
        return n;
    }

    private void setImpl(StorelessUnivariateStatistic[] storelessUnivariateStatisticArray, StorelessUnivariateStatistic[] storelessUnivariateStatisticArray2) {
        this.checkEmpty();
        this.checkDimension(storelessUnivariateStatisticArray.length);
        System.arraycopy(storelessUnivariateStatisticArray, 0, storelessUnivariateStatisticArray2, 0, storelessUnivariateStatisticArray.length);
    }

    public StorelessUnivariateStatistic[] getSumImpl() {
        return (StorelessUnivariateStatistic[])this.sumImpl.clone();
    }

    public void setSumImpl(StorelessUnivariateStatistic[] storelessUnivariateStatisticArray) {
        this.setImpl(storelessUnivariateStatisticArray, this.sumImpl);
    }

    public StorelessUnivariateStatistic[] getSumsqImpl() {
        return (StorelessUnivariateStatistic[])this.sumSqImpl.clone();
    }

    public void setSumsqImpl(StorelessUnivariateStatistic[] storelessUnivariateStatisticArray) {
        this.setImpl(storelessUnivariateStatisticArray, this.sumSqImpl);
    }

    public StorelessUnivariateStatistic[] getMinImpl() {
        return (StorelessUnivariateStatistic[])this.minImpl.clone();
    }

    public void setMinImpl(StorelessUnivariateStatistic[] storelessUnivariateStatisticArray) {
        this.setImpl(storelessUnivariateStatisticArray, this.minImpl);
    }

    public StorelessUnivariateStatistic[] getMaxImpl() {
        return (StorelessUnivariateStatistic[])this.maxImpl.clone();
    }

    public void setMaxImpl(StorelessUnivariateStatistic[] storelessUnivariateStatisticArray) {
        this.setImpl(storelessUnivariateStatisticArray, this.maxImpl);
    }

    public StorelessUnivariateStatistic[] getSumLogImpl() {
        return (StorelessUnivariateStatistic[])this.sumLogImpl.clone();
    }

    public void setSumLogImpl(StorelessUnivariateStatistic[] storelessUnivariateStatisticArray) {
        this.setImpl(storelessUnivariateStatisticArray, this.sumLogImpl);
    }

    public StorelessUnivariateStatistic[] getGeoMeanImpl() {
        return (StorelessUnivariateStatistic[])this.geoMeanImpl.clone();
    }

    public void setGeoMeanImpl(StorelessUnivariateStatistic[] storelessUnivariateStatisticArray) {
        this.setImpl(storelessUnivariateStatisticArray, this.geoMeanImpl);
    }

    public StorelessUnivariateStatistic[] getMeanImpl() {
        return (StorelessUnivariateStatistic[])this.meanImpl.clone();
    }

    public void setMeanImpl(StorelessUnivariateStatistic[] storelessUnivariateStatisticArray) {
        this.setImpl(storelessUnivariateStatisticArray, this.meanImpl);
    }

    private void checkEmpty() {
        if (this.n > 0L) {
            throw new MathIllegalStateException(LocalizedFormats.VALUES_ADDED_BEFORE_CONFIGURING_STATISTIC, this.n);
        }
    }

    private void checkDimension(int n) {
        if (n != this.k) {
            throw new DimensionMismatchException(n, this.k);
        }
    }
}

