/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathIllegalArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathIllegalStateException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.StatisticalSummary;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.UnivariateStatistic;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.moment.GeometricMean;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.moment.Kurtosis;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.moment.Mean;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.moment.Skewness;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.moment.Variance;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.rank.Max;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.rank.Min;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.rank.Percentile;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.summary.Sum;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.summary.SumOfSquares;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.ResizableDoubleArray;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;

public class DescriptiveStatistics
implements StatisticalSummary,
Serializable {
    public static final int INFINITE_WINDOW = -1;
    private static final long serialVersionUID = 4133067267405273064L;
    private static final String SET_QUANTILE_METHOD_NAME = "setQuantile";
    protected int windowSize = -1;
    private ResizableDoubleArray eDA = new ResizableDoubleArray();
    private UnivariateStatistic meanImpl = new Mean();
    private UnivariateStatistic geometricMeanImpl = new GeometricMean();
    private UnivariateStatistic kurtosisImpl = new Kurtosis();
    private UnivariateStatistic maxImpl = new Max();
    private UnivariateStatistic minImpl = new Min();
    private UnivariateStatistic percentileImpl = new Percentile();
    private UnivariateStatistic skewnessImpl = new Skewness();
    private UnivariateStatistic varianceImpl = new Variance();
    private UnivariateStatistic sumsqImpl = new SumOfSquares();
    private UnivariateStatistic sumImpl = new Sum();

    public DescriptiveStatistics() {
    }

    public DescriptiveStatistics(int n) {
        this.setWindowSize(n);
    }

    public DescriptiveStatistics(double[] dArray) {
        if (dArray != null) {
            this.eDA = new ResizableDoubleArray(dArray);
        }
    }

    public DescriptiveStatistics(DescriptiveStatistics descriptiveStatistics) {
        DescriptiveStatistics.copy(descriptiveStatistics, this);
    }

    public void addValue(double d2) {
        block5: {
            block4: {
                if (this.windowSize == -1) break block4;
                if (this.getN() == (long)this.windowSize) {
                    this.eDA.addElementRolling(d2);
                    return;
                }
                if (this.getN() >= (long)this.windowSize) break block5;
            }
            this.eDA.addElement(d2);
        }
    }

    public void removeMostRecentValue() {
        try {
            this.eDA.discardMostRecentElements(1);
            return;
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            throw new MathIllegalStateException(LocalizedFormats.NO_DATA, new Object[0]);
        }
    }

    public double replaceMostRecentValue(double d2) {
        return this.eDA.substituteMostRecentElement(d2);
    }

    public double getMean() {
        DescriptiveStatistics descriptiveStatistics = this;
        return descriptiveStatistics.apply(descriptiveStatistics.meanImpl);
    }

    public double getGeometricMean() {
        DescriptiveStatistics descriptiveStatistics = this;
        return descriptiveStatistics.apply(descriptiveStatistics.geometricMeanImpl);
    }

    public double getVariance() {
        DescriptiveStatistics descriptiveStatistics = this;
        return descriptiveStatistics.apply(descriptiveStatistics.varianceImpl);
    }

    public double getPopulationVariance() {
        return this.apply(new Variance(false));
    }

    public double getStandardDeviation() {
        double d2 = Double.NaN;
        if (this.getN() > 0L) {
            d2 = this.getN() > 1L ? FastMath.sqrt(this.getVariance()) : 0.0;
        }
        return d2;
    }

    public double getQuadraticMean() {
        long l = this.getN();
        if (l > 0L) {
            return FastMath.sqrt(this.getSumsq() / (double)l);
        }
        return Double.NaN;
    }

    public double getSkewness() {
        DescriptiveStatistics descriptiveStatistics = this;
        return descriptiveStatistics.apply(descriptiveStatistics.skewnessImpl);
    }

    public double getKurtosis() {
        DescriptiveStatistics descriptiveStatistics = this;
        return descriptiveStatistics.apply(descriptiveStatistics.kurtosisImpl);
    }

    public double getMax() {
        DescriptiveStatistics descriptiveStatistics = this;
        return descriptiveStatistics.apply(descriptiveStatistics.maxImpl);
    }

    public double getMin() {
        DescriptiveStatistics descriptiveStatistics = this;
        return descriptiveStatistics.apply(descriptiveStatistics.minImpl);
    }

    public long getN() {
        return this.eDA.getNumElements();
    }

    public double getSum() {
        DescriptiveStatistics descriptiveStatistics = this;
        return descriptiveStatistics.apply(descriptiveStatistics.sumImpl);
    }

    public double getSumsq() {
        DescriptiveStatistics descriptiveStatistics = this;
        return descriptiveStatistics.apply(descriptiveStatistics.sumsqImpl);
    }

    public void clear() {
        this.eDA.clear();
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public void setWindowSize(int n) {
        if (n <= 0 && n != -1) {
            throw new MathIllegalArgumentException(LocalizedFormats.NOT_POSITIVE_WINDOW_SIZE, n);
        }
        this.windowSize = n;
        if (n != -1 && n < this.eDA.getNumElements()) {
            this.eDA.discardFrontElements(this.eDA.getNumElements() - n);
        }
    }

    public double[] getValues() {
        return this.eDA.getElements();
    }

    public double[] getSortedValues() {
        double[] dArray = this.getValues();
        Arrays.sort(dArray);
        return dArray;
    }

    public double getElement(int n) {
        return this.eDA.getElement(n);
    }

    public double getPercentile(double d2) {
        if (this.percentileImpl instanceof Percentile) {
            ((Percentile)this.percentileImpl).setQuantile(d2);
        } else {
            try {
                this.percentileImpl.getClass().getMethod(SET_QUANTILE_METHOD_NAME, Double.TYPE).invoke((Object)this.percentileImpl, d2);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new MathIllegalStateException(LocalizedFormats.PERCENTILE_IMPLEMENTATION_UNSUPPORTED_METHOD, this.percentileImpl.getClass().getName(), SET_QUANTILE_METHOD_NAME);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new MathIllegalStateException(LocalizedFormats.PERCENTILE_IMPLEMENTATION_CANNOT_ACCESS_METHOD, SET_QUANTILE_METHOD_NAME, this.percentileImpl.getClass().getName());
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new IllegalStateException(invocationTargetException.getCause());
            }
        }
        DescriptiveStatistics descriptiveStatistics = this;
        return descriptiveStatistics.apply(descriptiveStatistics.percentileImpl);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "\n";
        stringBuilder.append("DescriptiveStatistics:").append(string);
        stringBuilder.append("n: ").append(this.getN()).append(string);
        stringBuilder.append("min: ").append(this.getMin()).append(string);
        stringBuilder.append("max: ").append(this.getMax()).append(string);
        stringBuilder.append("mean: ").append(this.getMean()).append(string);
        stringBuilder.append("std dev: ").append(this.getStandardDeviation()).append(string);
        try {
            stringBuilder.append("median: ").append(this.getPercentile(50.0)).append(string);
        }
        catch (MathIllegalStateException mathIllegalStateException) {
            stringBuilder.append("median: unavailable").append(string);
        }
        stringBuilder.append("skewness: ").append(this.getSkewness()).append(string);
        stringBuilder.append("kurtosis: ").append(this.getKurtosis()).append(string);
        return stringBuilder.toString();
    }

    public double apply(UnivariateStatistic univariateStatistic) {
        return this.eDA.compute(univariateStatistic);
    }

    public synchronized UnivariateStatistic getMeanImpl() {
        return this.meanImpl;
    }

    public synchronized void setMeanImpl(UnivariateStatistic univariateStatistic) {
        this.meanImpl = univariateStatistic;
    }

    public synchronized UnivariateStatistic getGeometricMeanImpl() {
        return this.geometricMeanImpl;
    }

    public synchronized void setGeometricMeanImpl(UnivariateStatistic univariateStatistic) {
        this.geometricMeanImpl = univariateStatistic;
    }

    public synchronized UnivariateStatistic getKurtosisImpl() {
        return this.kurtosisImpl;
    }

    public synchronized void setKurtosisImpl(UnivariateStatistic univariateStatistic) {
        this.kurtosisImpl = univariateStatistic;
    }

    public synchronized UnivariateStatistic getMaxImpl() {
        return this.maxImpl;
    }

    public synchronized void setMaxImpl(UnivariateStatistic univariateStatistic) {
        this.maxImpl = univariateStatistic;
    }

    public synchronized UnivariateStatistic getMinImpl() {
        return this.minImpl;
    }

    public synchronized void setMinImpl(UnivariateStatistic univariateStatistic) {
        this.minImpl = univariateStatistic;
    }

    public synchronized UnivariateStatistic getPercentileImpl() {
        return this.percentileImpl;
    }

    public synchronized void setPercentileImpl(UnivariateStatistic univariateStatistic) {
        try {
            univariateStatistic.getClass().getMethod(SET_QUANTILE_METHOD_NAME, Double.TYPE).invoke((Object)univariateStatistic, 50.0);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new MathIllegalArgumentException(LocalizedFormats.PERCENTILE_IMPLEMENTATION_UNSUPPORTED_METHOD, univariateStatistic.getClass().getName(), SET_QUANTILE_METHOD_NAME);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new MathIllegalArgumentException(LocalizedFormats.PERCENTILE_IMPLEMENTATION_CANNOT_ACCESS_METHOD, SET_QUANTILE_METHOD_NAME, univariateStatistic.getClass().getName());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IllegalArgumentException(invocationTargetException.getCause());
        }
        this.percentileImpl = univariateStatistic;
    }

    public synchronized UnivariateStatistic getSkewnessImpl() {
        return this.skewnessImpl;
    }

    public synchronized void setSkewnessImpl(UnivariateStatistic univariateStatistic) {
        this.skewnessImpl = univariateStatistic;
    }

    public synchronized UnivariateStatistic getVarianceImpl() {
        return this.varianceImpl;
    }

    public synchronized void setVarianceImpl(UnivariateStatistic univariateStatistic) {
        this.varianceImpl = univariateStatistic;
    }

    public synchronized UnivariateStatistic getSumsqImpl() {
        return this.sumsqImpl;
    }

    public synchronized void setSumsqImpl(UnivariateStatistic univariateStatistic) {
        this.sumsqImpl = univariateStatistic;
    }

    public synchronized UnivariateStatistic getSumImpl() {
        return this.sumImpl;
    }

    public synchronized void setSumImpl(UnivariateStatistic univariateStatistic) {
        this.sumImpl = univariateStatistic;
    }

    public DescriptiveStatistics copy() {
        DescriptiveStatistics descriptiveStatistics = new DescriptiveStatistics();
        DescriptiveStatistics.copy(this, descriptiveStatistics);
        return descriptiveStatistics;
    }

    public static void copy(DescriptiveStatistics descriptiveStatistics, DescriptiveStatistics descriptiveStatistics2) {
        MathUtils.checkNotNull(descriptiveStatistics);
        MathUtils.checkNotNull(descriptiveStatistics2);
        descriptiveStatistics2.eDA = descriptiveStatistics.eDA.copy();
        descriptiveStatistics2.windowSize = descriptiveStatistics.windowSize;
        descriptiveStatistics2.maxImpl = descriptiveStatistics.maxImpl.copy();
        descriptiveStatistics2.meanImpl = descriptiveStatistics.meanImpl.copy();
        descriptiveStatistics2.minImpl = descriptiveStatistics.minImpl.copy();
        descriptiveStatistics2.sumImpl = descriptiveStatistics.sumImpl.copy();
        descriptiveStatistics2.varianceImpl = descriptiveStatistics.varianceImpl.copy();
        descriptiveStatistics2.sumsqImpl = descriptiveStatistics.sumsqImpl.copy();
        descriptiveStatistics2.geometricMeanImpl = descriptiveStatistics.geometricMeanImpl.copy();
        descriptiveStatistics2.kurtosisImpl = descriptiveStatistics.kurtosisImpl;
        descriptiveStatistics2.skewnessImpl = descriptiveStatistics.skewnessImpl;
        descriptiveStatistics2.percentileImpl = descriptiveStatistics.percentileImpl;
    }
}

