/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.correlation;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathUnsupportedOperationException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.MatrixUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.correlation.Covariance;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.correlation.StorelessBivariateCovariance;

public class StorelessCovariance
extends Covariance {
    private StorelessBivariateCovariance[] covMatrix;
    private int dimension;

    public StorelessCovariance(int n) {
        this(n, true);
    }

    public StorelessCovariance(int n, boolean bl) {
        this.dimension = n;
        this.covMatrix = new StorelessBivariateCovariance[this.dimension * (this.dimension + 1) / 2];
        this.initializeMatrix(bl);
    }

    private void initializeMatrix(boolean bl) {
        for (int i2 = 0; i2 < this.dimension; ++i2) {
            for (int i3 = 0; i3 < this.dimension; ++i3) {
                this.setElement(i2, i3, new StorelessBivariateCovariance(bl));
            }
        }
    }

    private int indexOf(int n, int n2) {
        if (n2 < n) {
            int n3 = n;
            return n3 * (n3 + 1) / 2 + n2;
        }
        int n4 = n2;
        return n4 * (n4 + 1) / 2 + n;
    }

    private StorelessBivariateCovariance getElement(int n, int n2) {
        return this.covMatrix[this.indexOf(n, n2)];
    }

    private void setElement(int n, int n2, StorelessBivariateCovariance storelessBivariateCovariance) {
        this.covMatrix[this.indexOf((int)n, (int)n2)] = storelessBivariateCovariance;
    }

    public double getCovariance(int n, int n2) {
        return this.getElement(n, n2).getResult();
    }

    public void increment(double[] dArray) {
        int n = dArray.length;
        if (n != this.dimension) {
            throw new DimensionMismatchException(n, this.dimension);
        }
        for (int i2 = 0; i2 < n; ++i2) {
            for (int i3 = i2; i3 < n; ++i3) {
                this.getElement(i2, i3).increment(dArray[i2], dArray[i3]);
            }
        }
    }

    public void append(StorelessCovariance storelessCovariance) {
        if (storelessCovariance.dimension != this.dimension) {
            throw new DimensionMismatchException(storelessCovariance.dimension, this.dimension);
        }
        for (int i2 = 0; i2 < this.dimension; ++i2) {
            for (int i3 = i2; i3 < this.dimension; ++i3) {
                this.getElement(i2, i3).append(storelessCovariance.getElement(i2, i3));
            }
        }
    }

    public RealMatrix getCovarianceMatrix() {
        return MatrixUtils.createRealMatrix(this.getData());
    }

    public double[][] getData() {
        double[][] dArray = new double[this.dimension][this.dimension];
        for (int i2 = 0; i2 < this.dimension; ++i2) {
            for (int i3 = 0; i3 < this.dimension; ++i3) {
                dArray[i2][i3] = this.getElement(i2, i3).getResult();
            }
        }
        return dArray;
    }

    public int getN() {
        throw new MathUnsupportedOperationException();
    }
}

