/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.correlation;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooSmallException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;

class StorelessBivariateCovariance {
    private double meanX;
    private double meanY;
    private double n;
    private double covarianceNumerator;
    private boolean biasCorrected;

    StorelessBivariateCovariance() {
        this(true);
    }

    StorelessBivariateCovariance(boolean bl) {
        StorelessBivariateCovariance storelessBivariateCovariance = this;
        storelessBivariateCovariance.meanY = 0.0;
        storelessBivariateCovariance.meanX = 0.0;
        this.n = 0.0;
        this.covarianceNumerator = 0.0;
        this.biasCorrected = bl;
    }

    public void increment(double d2, double d3) {
        this.n += 1.0;
        double d4 = d2 - this.meanX;
        double d5 = d3 - this.meanY;
        this.meanX += d4 / this.n;
        this.meanY += d5 / this.n;
        this.covarianceNumerator += (this.n - 1.0) / this.n * d4 * d5;
    }

    public void append(StorelessBivariateCovariance storelessBivariateCovariance) {
        double d2 = this.n;
        this.n += storelessBivariateCovariance.n;
        double d3 = storelessBivariateCovariance.meanX - this.meanX;
        double d4 = storelessBivariateCovariance.meanY - this.meanY;
        this.meanX += d3 * storelessBivariateCovariance.n / this.n;
        this.meanY += d4 * storelessBivariateCovariance.n / this.n;
        this.covarianceNumerator += storelessBivariateCovariance.covarianceNumerator + d2 * storelessBivariateCovariance.n / this.n * d3 * d4;
    }

    public double getN() {
        return this.n;
    }

    public double getResult() {
        if (this.n < 2.0) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.INSUFFICIENT_DIMENSION, (Number)this.n, 2, true);
        }
        if (this.biasCorrected) {
            return this.covarianceNumerator / (this.n - 1.0);
        }
        return this.covarianceNumerator / this.n;
    }
}

