/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.correlation;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.TDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathIllegalArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NullArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.BlockRealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.correlation.Covariance;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.regression.SimpleRegression;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

public class PearsonsCorrelation {
    private final RealMatrix correlationMatrix;
    private final int nObs;

    public PearsonsCorrelation() {
        this.correlationMatrix = null;
        this.nObs = 0;
    }

    public PearsonsCorrelation(double[][] dArray) {
        this(new BlockRealMatrix(dArray));
    }

    public PearsonsCorrelation(RealMatrix realMatrix) {
        this.nObs = realMatrix.getRowDimension();
        this.correlationMatrix = this.computeCorrelationMatrix(realMatrix);
    }

    public PearsonsCorrelation(Covariance covariance) {
        RealMatrix realMatrix = covariance.getCovarianceMatrix();
        if (realMatrix == null) {
            throw new NullArgumentException(LocalizedFormats.COVARIANCE_MATRIX, new Object[0]);
        }
        this.nObs = covariance.getN();
        this.correlationMatrix = this.covarianceToCorrelation(realMatrix);
    }

    public PearsonsCorrelation(RealMatrix realMatrix, int n) {
        this.nObs = n;
        this.correlationMatrix = this.covarianceToCorrelation(realMatrix);
    }

    public RealMatrix getCorrelationMatrix() {
        return this.correlationMatrix;
    }

    public RealMatrix getCorrelationStandardErrors() {
        int n = this.correlationMatrix.getColumnDimension();
        double[][] dArray = new double[n][n];
        for (int i2 = 0; i2 < n; ++i2) {
            for (int i3 = 0; i3 < n; ++i3) {
                double d2;
                double d3 = d2 = this.correlationMatrix.getEntry(i2, i3);
                dArray[i2][i3] = FastMath.sqrt((1.0 - d3 * d3) / (double)(this.nObs - 2));
            }
        }
        return new BlockRealMatrix(dArray);
    }

    public RealMatrix getCorrelationPValues() {
        TDistribution tDistribution = new TDistribution(this.nObs - 2);
        int n = this.correlationMatrix.getColumnDimension();
        double[][] dArray = new double[n][n];
        for (int i2 = 0; i2 < n; ++i2) {
            for (int i3 = 0; i3 < n; ++i3) {
                double d2;
                if (i2 == i3) {
                    dArray[i2][i3] = 0.0;
                    continue;
                }
                double d3 = d2 = this.correlationMatrix.getEntry(i2, i3);
                double d4 = FastMath.abs(d2 * FastMath.sqrt((double)(this.nObs - 2) / (1.0 - d3 * d3)));
                dArray[i2][i3] = 2.0 * tDistribution.cumulativeProbability(-d4);
            }
        }
        return new BlockRealMatrix(dArray);
    }

    public RealMatrix computeCorrelationMatrix(RealMatrix realMatrix) {
        int n;
        this.checkSufficientData(realMatrix);
        int n2 = n = realMatrix.getColumnDimension();
        BlockRealMatrix blockRealMatrix = new BlockRealMatrix(n2, n2);
        int n3 = 0;
        while (n3 < n) {
            for (int i2 = 0; i2 < n3; ++i2) {
                double d2 = this.correlation(realMatrix.getColumn(n3), realMatrix.getColumn(i2));
                blockRealMatrix.setEntry(n3, i2, d2);
                blockRealMatrix.setEntry(i2, n3, d2);
            }
            int n4 = n3++;
            blockRealMatrix.setEntry(n4, n4, 1.0);
        }
        return blockRealMatrix;
    }

    public RealMatrix computeCorrelationMatrix(double[][] dArray) {
        return this.computeCorrelationMatrix(new BlockRealMatrix(dArray));
    }

    public double correlation(double[] dArray, double[] dArray2) {
        SimpleRegression simpleRegression = new SimpleRegression();
        if (dArray.length != dArray2.length) {
            throw new DimensionMismatchException(dArray.length, dArray2.length);
        }
        if (dArray.length < 2) {
            throw new MathIllegalArgumentException(LocalizedFormats.INSUFFICIENT_DIMENSION, dArray.length, 2);
        }
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            simpleRegression.addData(dArray[i2], dArray2[i2]);
        }
        return simpleRegression.getR();
    }

    public RealMatrix covarianceToCorrelation(RealMatrix realMatrix) {
        int n;
        int n2 = n = realMatrix.getColumnDimension();
        BlockRealMatrix blockRealMatrix = new BlockRealMatrix(n2, n2);
        for (int i2 = 0; i2 < n; ++i2) {
            int n3 = i2;
            double d2 = FastMath.sqrt(realMatrix.getEntry(n3, n3));
            int n4 = i2;
            blockRealMatrix.setEntry(n4, n4, 1.0);
            for (int i3 = 0; i3 < i2; ++i3) {
                int n5 = i3;
                double d3 = realMatrix.getEntry(i2, i3) / (d2 * FastMath.sqrt(realMatrix.getEntry(n5, n5)));
                blockRealMatrix.setEntry(i2, i3, d3);
                blockRealMatrix.setEntry(i3, i2, d3);
            }
        }
        return blockRealMatrix;
    }

    private void checkSufficientData(RealMatrix realMatrix) {
        int n = realMatrix.getRowDimension();
        int n2 = realMatrix.getColumnDimension();
        if (n < 2 || n2 < 2) {
            throw new MathIllegalArgumentException(LocalizedFormats.INSUFFICIENT_ROWS_AND_COLUMNS, n, n2);
        }
    }
}

