/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.correlation;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.BlockRealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.MatrixUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.correlation.KendallsCorrelation$1;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Pair;
import java.util.Arrays;

public class KendallsCorrelation {
    private final RealMatrix correlationMatrix;

    public KendallsCorrelation() {
        this.correlationMatrix = null;
    }

    public KendallsCorrelation(double[][] dArray) {
        this(MatrixUtils.createRealMatrix(dArray));
    }

    public KendallsCorrelation(RealMatrix realMatrix) {
        this.correlationMatrix = this.computeCorrelationMatrix(realMatrix);
    }

    public RealMatrix getCorrelationMatrix() {
        return this.correlationMatrix;
    }

    public RealMatrix computeCorrelationMatrix(RealMatrix realMatrix) {
        int n;
        int n2 = n = realMatrix.getColumnDimension();
        BlockRealMatrix blockRealMatrix = new BlockRealMatrix(n2, n2);
        int n3 = 0;
        while (n3 < n) {
            for (int i2 = 0; i2 < n3; ++i2) {
                double d2 = this.correlation(realMatrix.getColumn(n3), realMatrix.getColumn(i2));
                blockRealMatrix.setEntry(n3, i2, d2);
                blockRealMatrix.setEntry(i2, n3, d2);
            }
            int n4 = n3++;
            blockRealMatrix.setEntry(n4, n4, 1.0);
        }
        return blockRealMatrix;
    }

    public RealMatrix computeCorrelationMatrix(double[][] dArray) {
        return this.computeCorrelationMatrix(new BlockRealMatrix(dArray));
    }

    public double correlation(double[] object, double[] dArray) {
        int n;
        if (((double[])object).length != dArray.length) {
            throw new DimensionMismatchException(((double[])object).length, dArray.length);
        }
        int n2 = ((double[])object).length;
        long l = KendallsCorrelation.sum(n2 - 1);
        Object object2 = new Pair[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            object2[i2] = new Pair<Double, Double>(object[i2], dArray[i2]);
        }
        Arrays.sort(object2, new KendallsCorrelation$1(this));
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 1L;
        long l5 = 1L;
        object = object2[0];
        for (int i3 = 1; i3 < n2; ++i3) {
            Pair pair = object2[i3];
            if (((Double)pair.getFirst()).equals(((Pair)object).getFirst())) {
                ++l4;
                if (((Double)pair.getSecond()).equals(((Pair)object).getSecond())) {
                    ++l5;
                } else {
                    l3 += KendallsCorrelation.sum(l5 - 1L);
                    l5 = 1L;
                }
            } else {
                l2 += KendallsCorrelation.sum(l4 - 1L);
                l4 = 1L;
                l3 += KendallsCorrelation.sum(l5 - 1L);
                l5 = 1L;
            }
            object = pair;
        }
        l2 += KendallsCorrelation.sum(l4 - 1L);
        l3 += KendallsCorrelation.sum(l5 - 1L);
        long l6 = 0L;
        object = new Pair[n2];
        for (int i4 = 1; i4 < n2; i4 <<= 1) {
            for (int i5 = 0; i5 < n2; i5 += 2 * i4) {
                int n3;
                int n4 = i5;
                n = n3 = FastMath.min(n4 + i4, n2);
                int n5 = FastMath.min(n3 + i4, n2);
                int n6 = i5;
                while (n4 < n3 || n < n5) {
                    if (n4 < n3) {
                        if (n < n5) {
                            if (((Double)object2[n4].getSecond()).compareTo((Double)object2[n].getSecond()) <= 0) {
                                object[n6] = object2[n4];
                                ++n4;
                            } else {
                                object[n6] = object2[n];
                                ++n;
                                l6 += (long)(n3 - n4);
                            }
                        } else {
                            object[n6] = object2[n4];
                            ++n4;
                        }
                    } else {
                        object[n6] = object2[n];
                        ++n;
                    }
                    ++n6;
                }
            }
            Pair[] pairArray = object2;
            object2 = object;
            object = pairArray;
        }
        long l7 = 0L;
        long l8 = 1L;
        object = object2[0];
        for (n = 1; n < n2; ++n) {
            Pair pair = object2[n];
            if (((Double)pair.getSecond()).equals(((Pair)object).getSecond())) {
                ++l8;
            } else {
                l7 += KendallsCorrelation.sum(l8 - 1L);
                l8 = 1L;
            }
            object = pair;
        }
        long l9 = l - l2 - (l7 += KendallsCorrelation.sum(l8 - 1L)) + l3 - 2L * l6;
        double d2 = (double)(l - l2) * (double)(l - l7);
        return (double)l9 / FastMath.sqrt(d2);
    }

    private static long sum(long l) {
        long l2 = l;
        return l2 * (l2 + 1L) / 2L;
    }
}

