/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.correlation;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathIllegalArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.BlockRealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.AbstractUnivariateStatistic;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.moment.Mean;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.moment.Variance;

public class Covariance {
    private final RealMatrix covarianceMatrix;
    private final int n;

    public Covariance() {
        this.covarianceMatrix = null;
        this.n = 0;
    }

    public Covariance(double[][] dArray, boolean bl) {
        this(new BlockRealMatrix(dArray), bl);
    }

    public Covariance(double[][] dArray) {
        this(dArray, true);
    }

    public Covariance(RealMatrix realMatrix, boolean bl) {
        this.checkSufficientData(realMatrix);
        this.n = realMatrix.getRowDimension();
        this.covarianceMatrix = this.computeCovarianceMatrix(realMatrix, bl);
    }

    public Covariance(RealMatrix realMatrix) {
        this(realMatrix, true);
    }

    public RealMatrix getCovarianceMatrix() {
        return this.covarianceMatrix;
    }

    public int getN() {
        return this.n;
    }

    protected RealMatrix computeCovarianceMatrix(RealMatrix realMatrix, boolean bl) {
        int n = realMatrix.getColumnDimension();
        Variance variance = new Variance(bl);
        int n2 = n;
        BlockRealMatrix blockRealMatrix = new BlockRealMatrix(n2, n2);
        for (int i2 = 0; i2 < n; ++i2) {
            for (int i3 = 0; i3 < i2; ++i3) {
                double d2 = this.covariance(realMatrix.getColumn(i2), realMatrix.getColumn(i3), bl);
                blockRealMatrix.setEntry(i2, i3, d2);
                blockRealMatrix.setEntry(i3, i2, d2);
            }
            int n3 = i2;
            blockRealMatrix.setEntry(n3, n3, ((AbstractUnivariateStatistic)variance).evaluate(realMatrix.getColumn(i2)));
        }
        return blockRealMatrix;
    }

    protected RealMatrix computeCovarianceMatrix(RealMatrix realMatrix) {
        return this.computeCovarianceMatrix(realMatrix, true);
    }

    protected RealMatrix computeCovarianceMatrix(double[][] dArray, boolean bl) {
        return this.computeCovarianceMatrix(new BlockRealMatrix(dArray), bl);
    }

    protected RealMatrix computeCovarianceMatrix(double[][] dArray) {
        return this.computeCovarianceMatrix(dArray, true);
    }

    public double covariance(double[] dArray, double[] dArray2, boolean bl) {
        Mean mean = new Mean();
        double d2 = 0.0;
        int n = dArray.length;
        if (n != dArray2.length) {
            throw new MathIllegalArgumentException(LocalizedFormats.DIMENSIONS_MISMATCH_SIMPLE, n, dArray2.length);
        }
        if (n < 2) {
            throw new MathIllegalArgumentException(LocalizedFormats.INSUFFICIENT_OBSERVED_POINTS_IN_SAMPLE, n, 2);
        }
        double d3 = ((AbstractUnivariateStatistic)mean).evaluate(dArray);
        double d4 = ((AbstractUnivariateStatistic)mean).evaluate(dArray2);
        for (int i2 = 0; i2 < n; ++i2) {
            double d5 = dArray[i2] - d3;
            double d6 = dArray2[i2] - d4;
            d2 += (d5 * d6 - d2) / (double)(i2 + 1);
        }
        if (bl) {
            return d2 * ((double)n / (double)(n - 1));
        }
        return d2;
    }

    public double covariance(double[] dArray, double[] dArray2) {
        return this.covariance(dArray, dArray2, true);
    }

    private void checkSufficientData(RealMatrix realMatrix) {
        int n = realMatrix.getRowDimension();
        int n2 = realMatrix.getColumnDimension();
        if (n < 2 || n2 <= 0) {
            throw new MathIllegalArgumentException(LocalizedFormats.INSUFFICIENT_ROWS_AND_COLUMNS, n, n2);
        }
    }
}

