/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.clustering;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.ConvergenceException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooSmallException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.clustering.Cluster;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.clustering.Clusterable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.clustering.KMeansPlusPlusClusterer$EmptyClusterStrategy;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.AbstractStorelessUnivariateStatistic;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.moment.Variance;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class KMeansPlusPlusClusterer<T extends Clusterable<T>> {
    private final Random random;
    private final KMeansPlusPlusClusterer$EmptyClusterStrategy emptyStrategy;

    public KMeansPlusPlusClusterer(Random random) {
        this(random, KMeansPlusPlusClusterer$EmptyClusterStrategy.LARGEST_VARIANCE);
    }

    public KMeansPlusPlusClusterer(Random random, KMeansPlusPlusClusterer$EmptyClusterStrategy kMeansPlusPlusClusterer$EmptyClusterStrategy) {
        this.random = random;
        this.emptyStrategy = kMeansPlusPlusClusterer$EmptyClusterStrategy;
    }

    public List<Cluster<T>> cluster(Collection<T> collection, int n, int n2, int n3) {
        List<Cluster<T>> list = null;
        double d2 = Double.POSITIVE_INFINITY;
        for (int i2 = 0; i2 < n2; ++i2) {
            List<Cluster<T>> list2 = this.cluster(collection, n, n3);
            double d3 = 0.0;
            for (Cluster<T> cluster : list2) {
                if (cluster.getPoints().isEmpty()) continue;
                T t = cluster.getCenter();
                Variance variance = new Variance();
                cluster = cluster.getPoints().iterator();
                while (cluster.hasNext()) {
                    Clusterable clusterable = (Clusterable)cluster.next();
                    ((AbstractStorelessUnivariateStatistic)variance).increment(clusterable.distanceFrom(t));
                }
                d3 += ((AbstractStorelessUnivariateStatistic)variance).getResult();
            }
            if (!(d3 <= d2)) continue;
            list = list2;
            d2 = d3;
        }
        return list;
    }

    public List<Cluster<T>> cluster(Collection<T> collection, int n, int n2) {
        MathUtils.checkNotNull(collection);
        if (collection.size() < n) {
            throw new NumberIsTooSmallException(collection.size(), (Number)n, false);
        }
        List<Cluster<T>> list = KMeansPlusPlusClusterer.chooseInitialCenters(collection, n, this.random);
        int[] nArray = new int[collection.size()];
        KMeansPlusPlusClusterer.assignPointsToClusters(list, collection, nArray);
        n2 = n2 < 0 ? Integer.MAX_VALUE : n2;
        for (int i2 = 0; i2 < n2; ++i2) {
            boolean bl = false;
            ArrayList<Cluster<T>> arrayList = new ArrayList<Cluster<T>>();
            for (Cluster<T> cluster : list) {
                if (cluster.getPoints().isEmpty()) {
                    switch (this.emptyStrategy) {
                        case LARGEST_VARIANCE: {
                            cluster = this.getPointFromLargestVarianceCluster(list);
                            break;
                        }
                        case LARGEST_POINTS_NUMBER: {
                            cluster = this.getPointFromLargestNumberCluster(list);
                            break;
                        }
                        case FARTHEST_POINT: {
                            cluster = this.getFarthestPoint(list);
                            break;
                        }
                        default: {
                            throw new ConvergenceException(LocalizedFormats.EMPTY_CLUSTER_IN_K_MEANS, new Object[0]);
                        }
                    }
                    bl = true;
                } else {
                    cluster = (Clusterable)cluster.getCenter().centroidOf(cluster.getPoints());
                }
                arrayList.add(new Cluster<Object>(cluster));
            }
            int n3 = KMeansPlusPlusClusterer.assignPointsToClusters(arrayList, collection, nArray);
            list = arrayList;
            if (n3 != 0 || bl) continue;
            return list;
        }
        return list;
    }

    private static <T extends Clusterable<T>> int assignPointsToClusters(List<Cluster<T>> list, Collection<T> object, int[] nArray) {
        int n = 0;
        int n2 = 0;
        object = object.iterator();
        while (object.hasNext()) {
            Clusterable clusterable = (Clusterable)object.next();
            int n3 = KMeansPlusPlusClusterer.getNearestCluster(list, clusterable);
            if (n3 != nArray[n2]) {
                ++n;
            }
            Cluster<Clusterable> cluster = list.get(n3);
            cluster.addPoint(clusterable);
            nArray[n2++] = n3;
        }
        return n;
    }

    private static <T extends Clusterable<T>> List<Cluster<T>> chooseInitialCenters(Collection<T> collection, int n, Random random) {
        collection = Collections.unmodifiableList(new ArrayList<T>(collection));
        int n2 = collection.size();
        boolean[] blArray = new boolean[n2];
        ArrayList<Cluster<T>> arrayList = new ArrayList<Cluster<T>>();
        int n3 = random.nextInt(n2);
        Clusterable clusterable = (Clusterable)collection.get(n3);
        arrayList.add(new Cluster<Clusterable>(clusterable));
        blArray[n3] = true;
        double[] dArray = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            double d2;
            if (i2 == n3) continue;
            double d3 = d2 = clusterable.distanceFrom(collection.get(i2));
            dArray[i2] = d3 * d3;
        }
        while (arrayList.size() < n) {
            int n4;
            double d4 = 0.0;
            for (int i3 = 0; i3 < n2; ++i3) {
                if (blArray[i3]) continue;
                d4 += dArray[i3];
            }
            double d5 = random.nextDouble() * d4;
            n3 = -1;
            double d6 = 0.0;
            for (n4 = 0; n4 < n2; ++n4) {
                double d7;
                if (blArray[n4]) continue;
                d6 += dArray[n4];
                if (!(d7 >= d5)) continue;
                n3 = n4;
                break;
            }
            if (n3 == -1) {
                for (n4 = n2 - 1; n4 >= 0; --n4) {
                    if (blArray[n4]) continue;
                    n3 = n4;
                    break;
                }
            }
            if (n3 < 0) break;
            clusterable = (Clusterable)collection.get(n3);
            arrayList.add(new Cluster<Clusterable>(clusterable));
            blArray[n3] = true;
            if (arrayList.size() >= n) continue;
            for (n3 = 0; n3 < n2; ++n3) {
                double d8;
                if (blArray[n3]) continue;
                double d9 = clusterable.distanceFrom(collection.get(n3));
                double d10 = d9 * d9;
                if (!(d8 < dArray[n3])) continue;
                dArray[n3] = d10;
            }
        }
        return arrayList;
    }

    private T getPointFromLargestVarianceCluster(Collection<Cluster<T>> list) {
        double d2 = Double.NEGATIVE_INFINITY;
        Cluster cluster = null;
        for (Cluster cluster2 : list) {
            double d3;
            if (cluster2.getPoints().isEmpty()) continue;
            Object t = cluster2.getCenter();
            Variance variance = new Variance();
            for (Clusterable clusterable : cluster2.getPoints()) {
                ((AbstractStorelessUnivariateStatistic)variance).increment(clusterable.distanceFrom(t));
            }
            double d4 = ((AbstractStorelessUnivariateStatistic)variance).getResult();
            if (!(d3 > d2)) continue;
            d2 = d4;
            cluster = cluster2;
        }
        if (cluster == null) {
            throw new ConvergenceException(LocalizedFormats.EMPTY_CLUSTER_IN_K_MEANS, new Object[0]);
        }
        list = cluster.getPoints();
        return (T)((Clusterable)list.remove(this.random.nextInt(list.size())));
    }

    private T getPointFromLargestNumberCluster(Collection<Cluster<T>> list) {
        int n = 0;
        Cluster cluster = null;
        for (Cluster cluster2 : list) {
            int n2 = cluster2.getPoints().size();
            if (n2 <= n) continue;
            n = n2;
            cluster = cluster2;
        }
        if (cluster == null) {
            throw new ConvergenceException(LocalizedFormats.EMPTY_CLUSTER_IN_K_MEANS, new Object[0]);
        }
        list = cluster.getPoints();
        return (T)((Clusterable)list.remove(this.random.nextInt(list.size())));
    }

    private T getFarthestPoint(Collection<Cluster<T>> object) {
        double d2 = Double.NEGATIVE_INFINITY;
        Cluster cluster = null;
        int n = -1;
        object = object.iterator();
        while (object.hasNext()) {
            Cluster cluster2 = (Cluster)object.next();
            Object t = cluster2.getCenter();
            List list = cluster2.getPoints();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                double d3;
                double d4 = ((Clusterable)list.get(i2)).distanceFrom(t);
                if (!(d3 > d2)) continue;
                d2 = d4;
                cluster = cluster2;
                n = i2;
            }
        }
        if (cluster == null) {
            throw new ConvergenceException(LocalizedFormats.EMPTY_CLUSTER_IN_K_MEANS, new Object[0]);
        }
        return (T)((Clusterable)cluster.getPoints().remove(n));
    }

    private static <T extends Clusterable<T>> int getNearestCluster(Collection<Cluster<T>> object, T object2) {
        double d2 = Double.MAX_VALUE;
        int n = 0;
        int n2 = 0;
        object = object.iterator();
        while (object.hasNext()) {
            double d3;
            Cluster cluster = (Cluster)object.next();
            double d4 = object2.distanceFrom(cluster.getCenter());
            if (d3 < d2) {
                d2 = d4;
                n2 = n;
            }
            ++n;
        }
        return n2;
    }
}

