/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.stat;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NoDataException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NullArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooSmallException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.Frequency;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.AbstractUnivariateStatistic;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.UnivariateStatistic;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.moment.GeometricMean;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.moment.Mean;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.moment.Variance;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.rank.Max;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.rank.Min;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.rank.Percentile;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.summary.Product;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.summary.Sum;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.summary.SumOfLogs;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.summary.SumOfSquares;
import java.util.List;

public final class StatUtils {
    private static final UnivariateStatistic SUM = new Sum();
    private static final UnivariateStatistic SUM_OF_SQUARES = new SumOfSquares();
    private static final UnivariateStatistic PRODUCT = new Product();
    private static final UnivariateStatistic SUM_OF_LOGS = new SumOfLogs();
    private static final UnivariateStatistic MIN = new Min();
    private static final UnivariateStatistic MAX = new Max();
    private static final UnivariateStatistic MEAN = new Mean();
    private static final Variance VARIANCE = new Variance();
    private static final Percentile PERCENTILE = new Percentile();
    private static final GeometricMean GEOMETRIC_MEAN = new GeometricMean();

    private StatUtils() {
    }

    public static double sum(double[] dArray) {
        return SUM.evaluate(dArray);
    }

    public static double sum(double[] dArray, int n, int n2) {
        return SUM.evaluate(dArray, n, n2);
    }

    public static double sumSq(double[] dArray) {
        return SUM_OF_SQUARES.evaluate(dArray);
    }

    public static double sumSq(double[] dArray, int n, int n2) {
        return SUM_OF_SQUARES.evaluate(dArray, n, n2);
    }

    public static double product(double[] dArray) {
        return PRODUCT.evaluate(dArray);
    }

    public static double product(double[] dArray, int n, int n2) {
        return PRODUCT.evaluate(dArray, n, n2);
    }

    public static double sumLog(double[] dArray) {
        return SUM_OF_LOGS.evaluate(dArray);
    }

    public static double sumLog(double[] dArray, int n, int n2) {
        return SUM_OF_LOGS.evaluate(dArray, n, n2);
    }

    public static double mean(double[] dArray) {
        return MEAN.evaluate(dArray);
    }

    public static double mean(double[] dArray, int n, int n2) {
        return MEAN.evaluate(dArray, n, n2);
    }

    public static double geometricMean(double[] dArray) {
        return ((AbstractUnivariateStatistic)GEOMETRIC_MEAN).evaluate(dArray);
    }

    public static double geometricMean(double[] dArray, int n, int n2) {
        return ((AbstractUnivariateStatistic)GEOMETRIC_MEAN).evaluate(dArray, n, n2);
    }

    public static double variance(double[] dArray) {
        return ((AbstractUnivariateStatistic)VARIANCE).evaluate(dArray);
    }

    public static double variance(double[] dArray, int n, int n2) {
        return ((AbstractUnivariateStatistic)VARIANCE).evaluate(dArray, n, n2);
    }

    public static double variance(double[] dArray, double d2, int n, int n2) {
        return VARIANCE.evaluate(dArray, d2, n, n2);
    }

    public static double variance(double[] dArray, double d2) {
        return VARIANCE.evaluate(dArray, d2);
    }

    public static double populationVariance(double[] dArray) {
        return ((AbstractUnivariateStatistic)new Variance(false)).evaluate(dArray);
    }

    public static double populationVariance(double[] dArray, int n, int n2) {
        return ((AbstractUnivariateStatistic)new Variance(false)).evaluate(dArray, n, n2);
    }

    public static double populationVariance(double[] dArray, double d2, int n, int n2) {
        return new Variance(false).evaluate(dArray, d2, n, n2);
    }

    public static double populationVariance(double[] dArray, double d2) {
        return new Variance(false).evaluate(dArray, d2);
    }

    public static double max(double[] dArray) {
        return MAX.evaluate(dArray);
    }

    public static double max(double[] dArray, int n, int n2) {
        return MAX.evaluate(dArray, n, n2);
    }

    public static double min(double[] dArray) {
        return MIN.evaluate(dArray);
    }

    public static double min(double[] dArray, int n, int n2) {
        return MIN.evaluate(dArray, n, n2);
    }

    public static double percentile(double[] dArray, double d2) {
        return PERCENTILE.evaluate(dArray, d2);
    }

    public static double percentile(double[] dArray, int n, int n2, double d2) {
        return PERCENTILE.evaluate(dArray, n, n2, d2);
    }

    public static double sumDifference(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        if (n != dArray2.length) {
            throw new DimensionMismatchException(n, dArray2.length);
        }
        if (n <= 0) {
            throw new NoDataException(LocalizedFormats.INSUFFICIENT_DIMENSION);
        }
        double d2 = 0.0;
        for (int i2 = 0; i2 < n; ++i2) {
            d2 += dArray[i2] - dArray2[i2];
        }
        return d2;
    }

    public static double meanDifference(double[] dArray, double[] dArray2) {
        return StatUtils.sumDifference(dArray, dArray2) / (double)dArray.length;
    }

    public static double varianceDifference(double[] dArray, double[] dArray2, double d2) {
        double d3 = 0.0;
        double d4 = 0.0;
        int n = dArray.length;
        if (n != dArray2.length) {
            throw new DimensionMismatchException(n, dArray2.length);
        }
        if (n < 2) {
            throw new NumberIsTooSmallException(n, (Number)2, true);
        }
        for (int i2 = 0; i2 < n; ++i2) {
            double d5 = dArray[i2] - dArray2[i2];
            d3 += (d5 - d2) * (d5 - d2);
            d4 += d5 - d2;
        }
        double d6 = d4;
        return (d3 - d6 * d6 / (double)n) / (double)(n - 1);
    }

    public static double[] normalize(double[] dArray) {
        Object object = new DescriptiveStatistics();
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            ((DescriptiveStatistics)object).addValue(dArray[i2]);
        }
        double d2 = ((DescriptiveStatistics)object).getMean();
        double d3 = ((DescriptiveStatistics)object).getStandardDeviation();
        object = new double[dArray.length];
        for (int i3 = 0; i3 < dArray.length; ++i3) {
            object[i3] = (dArray[i3] - d2) / d3;
        }
        return object;
    }

    public static double[] mode(double[] dArray) {
        if (dArray == null) {
            throw new NullArgumentException(LocalizedFormats.INPUT_ARRAY, new Object[0]);
        }
        return StatUtils.getMode(dArray, 0, dArray.length);
    }

    public static double[] mode(double[] dArray, int n, int n2) {
        if (dArray == null) {
            throw new NullArgumentException(LocalizedFormats.INPUT_ARRAY, new Object[0]);
        }
        if (n < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.START_POSITION, n);
        }
        if (n2 < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.LENGTH, n2);
        }
        return StatUtils.getMode(dArray, n, n2);
    }

    private static double[] getMode(double[] object, int n, int n2) {
        Frequency frequency = new Frequency();
        for (int i2 = n; i2 < n + n2; ++i2) {
            double d2 = object[i2];
            if (Double.isNaN(d2)) continue;
            frequency.addValue(Double.valueOf(d2));
        }
        List<Comparable<?>> list = frequency.getMode();
        double[] dArray = new double[list.size()];
        int n3 = 0;
        object = list.iterator();
        while (object.hasNext()) {
            Comparable comparable = (Comparable)object.next();
            dArray[n3++] = (Double)comparable;
        }
        return dArray;
    }
}

