/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.special;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooSmallException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.OutOfRangeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.special.Beta$1;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.special.Gamma;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

public class Beta {
    private static final double DEFAULT_EPSILON = 1.0E-14;
    private static final double HALF_LOG_TWO_PI = 0.9189385332046727;
    private static final double[] DELTA = new double[]{0.08333333333333333, -2.777777777777778E-5, 7.936507936507937E-8, -5.952380952380953E-10, 8.417508417508329E-12, -1.917526917518546E-13, 6.410256405103255E-15, -2.955065141253382E-16, 1.7964371635940225E-17, -1.3922896466162779E-18, 1.338028550140209E-19, -1.542460098679661E-20, 1.9770199298095743E-21, -2.3406566479399704E-22, 1.713480149663986E-23};

    private Beta() {
    }

    public static double regularizedBeta(double d2, double d3, double d4) {
        return Beta.regularizedBeta(d2, d3, d4, 1.0E-14, Integer.MAX_VALUE);
    }

    public static double regularizedBeta(double d2, double d3, double d4, double d5) {
        return Beta.regularizedBeta(d2, d3, d4, d5, Integer.MAX_VALUE);
    }

    public static double regularizedBeta(double d2, double d3, double d4, int n) {
        return Beta.regularizedBeta(d2, d3, d4, 1.0E-14, n);
    }

    public static double regularizedBeta(double d2, double d3, double d4, double d5, int n) {
        double d6;
        if (Double.isNaN(d2) || Double.isNaN(d3) || Double.isNaN(d4) || d2 < 0.0 || d2 > 1.0 || d3 <= 0.0 || d4 <= 0.0) {
            d6 = Double.NaN;
        } else if (d2 > (d3 + 1.0) / (d4 + 2.0 + d3) && 1.0 - d2 <= (d4 + 1.0) / (d4 + 2.0 + d3)) {
            d6 = 1.0 - Beta.regularizedBeta(1.0 - d2, d4, d3, d5, n);
        } else {
            Beta$1 beta$1 = new Beta$1(d4, d3);
            d6 = FastMath.exp(d3 * FastMath.log(d2) + d4 * FastMath.log1p(-d2) - FastMath.log(d3) - Beta.logBeta(d3, d4)) / beta$1.evaluate(d2, d5, n);
        }
        return d6;
    }

    @Deprecated
    public static double logBeta(double d2, double d3, double d4, int n) {
        return Beta.logBeta(d2, d3);
    }

    private static double logGammaSum(double d2, double d3) {
        double d4;
        if (d2 < 1.0 || d2 > 2.0) {
            throw new OutOfRangeException(d2, (Number)1.0, 2.0);
        }
        if (d3 < 1.0 || d3 > 2.0) {
            throw new OutOfRangeException(d3, (Number)1.0, 2.0);
        }
        double d5 = d2 - 1.0 + (d3 - 1.0);
        if (d4 <= 0.5) {
            return Gamma.logGamma1p(d5 + 1.0);
        }
        if (d5 <= 1.5) {
            return Gamma.logGamma1p(d5) + FastMath.log1p(d5);
        }
        return Gamma.logGamma1p(d5 - 1.0) + FastMath.log(d5 * (d5 + 1.0));
    }

    private static double logGammaMinusLogGammaSum(double d2, double d3) {
        double d4;
        double d5;
        if (d2 < 0.0) {
            throw new NumberIsTooSmallException(d2, (Number)0.0, true);
        }
        if (d3 < 10.0) {
            throw new NumberIsTooSmallException(d3, (Number)10.0, true);
        }
        if (d2 <= d3) {
            d5 = d3 + (d2 - 0.5);
            d4 = Beta.deltaMinusDeltaSum(d2, d3);
        } else {
            d5 = d2 + (d3 - 0.5);
            d4 = Beta.deltaMinusDeltaSum(d3, d2);
        }
        double d6 = d5 * FastMath.log1p(d2 / d3);
        double d7 = d2 * (FastMath.log(d3) - 1.0);
        if (d6 <= d7) {
            return d4 - d6 - d7;
        }
        return d4 - d7 - d6;
    }

    private static double deltaMinusDeltaSum(double d2, double d3) {
        if (d2 < 0.0 || d2 > d3) {
            throw new OutOfRangeException(d2, (Number)0, d3);
        }
        if (d3 < 10.0) {
            throw new NumberIsTooSmallException(d3, (Number)10, true);
        }
        double d4 = d2 / d3;
        double d5 = d4 / (d4 + 1.0);
        double d6 = 1.0 / (d4 + 1.0);
        double d7 = d6 * d6;
        double[] dArray = new double[DELTA.length];
        double[] dArray2 = dArray;
        dArray[0] = 1.0;
        for (int i2 = 1; i2 < dArray2.length; ++i2) {
            dArray2[i2] = 1.0 + (d6 + d7 * dArray2[i2 - 1]);
        }
        double d8 = 10.0 / d3;
        double d9 = d8 * d8;
        double d10 = DELTA[DELTA.length - 1] * dArray2[dArray2.length - 1];
        for (int i3 = DELTA.length - 2; i3 >= 0; --i3) {
            d10 = d9 * d10 + DELTA[i3] * dArray2[i3];
        }
        return d10 * d5 / d3;
    }

    private static double sumDeltaMinusDeltaSum(double d2, double d3) {
        if (d2 < 10.0) {
            throw new NumberIsTooSmallException(d2, (Number)10.0, true);
        }
        if (d3 < 10.0) {
            throw new NumberIsTooSmallException(d3, (Number)10.0, true);
        }
        double d4 = FastMath.min(d2, d3);
        double d5 = FastMath.max(d2, d3);
        double d6 = 10.0 / d4;
        double d7 = d6 * d6;
        double d8 = DELTA[DELTA.length - 1];
        for (int i2 = DELTA.length - 2; i2 >= 0; --i2) {
            d8 = d7 * d8 + DELTA[i2];
        }
        return d8 / d4 + Beta.deltaMinusDeltaSum(d4, d5);
    }

    public static double logBeta(double d2, double d3) {
        if (Double.isNaN(d2) || Double.isNaN(d3) || d2 <= 0.0 || d3 <= 0.0) {
            return Double.NaN;
        }
        double d4 = FastMath.min(d2, d3);
        double d5 = FastMath.max(d2, d3);
        if (d4 >= 10.0) {
            double d6;
            double d7 = Beta.sumDeltaMinusDeltaSum(d4, d5);
            double d8 = d4 / d5;
            double d9 = d8 / (d8 + 1.0);
            double d10 = -(d4 - 0.5) * FastMath.log(d9);
            if (d10 <= (d6 = d5 * FastMath.log1p(d8))) {
                return -0.5 * FastMath.log(d5) + 0.9189385332046727 + d7 - d10 - d6;
            }
            return -0.5 * FastMath.log(d5) + 0.9189385332046727 + d7 - d6 - d10;
        }
        if (d4 > 2.0) {
            double d11;
            if (d5 > 1000.0) {
                int n = (int)FastMath.floor(d4 - 1.0);
                double d12 = 1.0;
                double d13 = d4;
                for (int i2 = 0; i2 < n; ++i2) {
                    d12 *= (d13 -= 1.0) / (1.0 + d13 / d5);
                }
                return FastMath.log(d12) - (double)n * FastMath.log(d5) + (Gamma.logGamma(d13) + Beta.logGammaMinusLogGammaSum(d13, d5));
            }
            double d14 = 1.0;
            double d15 = d4;
            while (d15 > 2.0) {
                d11 = (d15 -= 1.0) / d5;
                d14 *= d11 / (d11 + 1.0);
            }
            if (d5 < 10.0) {
                d11 = 1.0;
                double d16 = d5;
                while (d16 > 2.0) {
                    d11 *= (d16 -= 1.0) / (d15 + d16);
                }
                return FastMath.log(d14) + FastMath.log(d11) + (Gamma.logGamma(d15) + (Gamma.logGamma(d16) - Beta.logGammaSum(d15, d16)));
            }
            return FastMath.log(d14) + Gamma.logGamma(d15) + Beta.logGammaMinusLogGammaSum(d15, d5);
        }
        if (d4 >= 1.0) {
            if (d5 > 2.0) {
                if (d5 < 10.0) {
                    double d17 = 1.0;
                    double d18 = d5;
                    while (d18 > 2.0) {
                        d17 *= (d18 -= 1.0) / (d4 + d18);
                    }
                    return FastMath.log(d17) + (Gamma.logGamma(d4) + (Gamma.logGamma(d18) - Beta.logGammaSum(d4, d18)));
                }
                return Gamma.logGamma(d4) + Beta.logGammaMinusLogGammaSum(d4, d5);
            }
            return Gamma.logGamma(d4) + Gamma.logGamma(d5) - Beta.logGammaSum(d4, d5);
        }
        if (d5 >= 10.0) {
            return Gamma.logGamma(d4) + Beta.logGammaMinusLogGammaSum(d4, d5);
        }
        return FastMath.log(Gamma.gamma(d4) * Gamma.gamma(d5) / Gamma.gamma(d4 + d5));
    }
}

