/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.special;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.UnivariateFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.ConvergenceException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathIllegalArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.special.BesselJ$BesselJResult;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.special.Gamma;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;

public class BesselJ
implements UnivariateFunction {
    private static final double PI2 = 0.6366197723675814;
    private static final double TOWPI1 = 6.28125;
    private static final double TWOPI2 = 0.001935307179586477;
    private static final double TWOPI = Math.PI * 2;
    private static final double ENTEN = 1.0E308;
    private static final double ENSIG = 1.0E16;
    private static final double RTNSIG = 1.0E-4;
    private static final double ENMTEN = 8.9E-308;
    private static final double X_MIN = 0.0;
    private static final double X_MAX = 10000.0;
    private static final double[] FACT = new double[]{1.0, 1.0, 2.0, 6.0, 24.0, 120.0, 720.0, 5040.0, 40320.0, 362880.0, 3628800.0, 3.99168E7, 4.790016E8, 6.2270208E9, 8.71782912E10, 1.307674368E12, 2.0922789888E13, 3.55687428096E14, 6.402373705728E15, 1.21645100408832E17, 2.43290200817664E18, 5.109094217170944E19, 1.1240007277776077E21, 2.585201673888498E22, 6.204484017332394E23};
    private final double order;

    public BesselJ(double d2) {
        this.order = d2;
    }

    public double value(double d2) {
        return BesselJ.value(this.order, d2);
    }

    public static double value(double d2, double d3) {
        int n = (int)d2;
        double d4 = d2 - (double)n;
        int n2 = n + 1;
        BesselJ$BesselJResult besselJ$BesselJResult = BesselJ.rjBesl(d3, d4, n2);
        if (BesselJ$BesselJResult.access$000(besselJ$BesselJResult) >= n2) {
            return BesselJ$BesselJResult.access$100(besselJ$BesselJResult)[n];
        }
        if (BesselJ$BesselJResult.access$000(besselJ$BesselJResult) < 0) {
            throw new MathIllegalArgumentException(LocalizedFormats.BESSEL_FUNCTION_BAD_ARGUMENT, d2, d3);
        }
        if (FastMath.abs(BesselJ$BesselJResult.access$100(besselJ$BesselJResult)[BesselJ$BesselJResult.access$000(besselJ$BesselJResult) - 1]) < 1.0E-100) {
            return BesselJ$BesselJResult.access$100(besselJ$BesselJResult)[n];
        }
        throw new ConvergenceException(LocalizedFormats.BESSEL_FUNCTION_FAILED_CONVERGENCE, d2, d3);
    }

    public static BesselJ$BesselJResult rjBesl(double d2, double d3, int n) {
        int n2;
        double[] dArray = new double[n];
        int n3 = (int)d2;
        if (n > 0 && d2 >= 0.0 && d2 <= 10000.0 && d3 >= 0.0 && d3 < 1.0) {
            n2 = n;
            for (int i2 = 0; i2 < n; ++i2) {
                dArray[i2] = 0.0;
            }
            if (d2 < 1.0E-4) {
                double d4 = 1.0;
                double d5 = d3 + 1.0;
                double d6 = 0.0;
                if (d2 > 8.9E-308) {
                    d6 = d2 * 0.5;
                }
                if (d3 != 0.0) {
                    double d7 = d3;
                    d4 = FastMath.pow(d6, d3) / (d7 * Gamma.gamma(d7));
                }
                double d8 = 0.0;
                if (d2 + 1.0 > 1.0) {
                    d8 = -d6 * d6;
                }
                double d9 = d4;
                dArray[0] = d9 + d9 * d8 / d5;
                if (d2 != 0.0 && dArray[0] == 0.0) {
                    n2 = 0;
                }
                if (n != 1) {
                    if (d2 <= 0.0) {
                        for (int i3 = 1; i3 < n; ++i3) {
                            dArray[i3] = 0.0;
                        }
                    } else {
                        double d10 = d6;
                        double d11 = d8 != 0.0 ? 8.9E-308 / d8 : 1.78E-307 / d2;
                        for (int i4 = 1; i4 < n; ++i4) {
                            double d12;
                            d4 /= d5;
                            d5 += 1.0;
                            d4 *= d10;
                            if (d12 <= d11 * d5) {
                                d4 = 0.0;
                            }
                            double d13 = d4;
                            dArray[i4] = d13 + d13 * d8 / d5;
                            if (dArray[i4] != 0.0 || n2 <= i4) continue;
                            n2 = i4;
                        }
                    }
                }
            } else if (d2 > 25.0 && n <= n3 + 1) {
                double d14 = FastMath.sqrt(0.6366197723675814 / d2);
                double d15 = 0.125 / d2;
                double d16 = d15 * d15;
                int n4 = d2 >= 130.0 ? 4 : (d2 >= 35.0 ? 8 : 11);
                double d17 = 4.0 * (double)n4;
                double d18 = (int)(d2 / (Math.PI * 2) + 0.5);
                double d19 = d2 - d18 * 6.28125 - d18 * 0.001935307179586477 - (d3 + 0.5) / 0.6366197723675814;
                double d20 = FastMath.sin(d19);
                double d21 = FastMath.cos(d19);
                double d22 = d3 * 2.0;
                for (n3 = 1; n3 <= 2; ++n3) {
                    double d23 = (d17 - 1.0 - d22) * (d17 - 1.0 + d22) * d16 * 0.5;
                    d18 = (d22 - (d17 - 3.0)) * (d22 + (d17 - 3.0));
                    double d24 = d23 * d18 / FACT[2 * n4];
                    double d25 = (d22 - (d17 + 1.0)) * (d22 + (d17 + 1.0));
                    double d26 = d23 * d25 / FACT[2 * n4 + 1];
                    double d27 = d17;
                    int n5 = 2 * n4;
                    d25 = d18;
                    for (int i5 = 2; i5 <= n4; ++i5) {
                        d23 = ((d27 -= 4.0) - 1.0 - d22) * (d27 - 1.0 + d22);
                        d18 = (d22 - (d27 - 3.0)) * (d22 + (d27 - 3.0));
                        d24 = (d24 + 1.0 / FACT[n5 - 2]) * d23 * d18 * d16;
                        d26 = (d26 + 1.0 / FACT[n5 - 1]) * d23 * d25 * d16;
                        n5 -= 2;
                        d25 = d18;
                    }
                    double d28 = d22;
                    d26 = (d26 + 1.0) * (d28 * d28 - 1.0) * (0.125 / d2);
                    dArray[n3 - 1] = d14 * ((d24 += 1.0) * d21 - d26 * d20);
                    if (n == 1) {
                        return new BesselJ$BesselJResult(MathArrays.copyOf(dArray, dArray.length), n2);
                    }
                    d18 = d20;
                    d20 = -d21;
                    d21 = d18;
                    d22 += 2.0;
                }
                if (n > 2) {
                    d22 = d3 * 2.0 + 2.0;
                    for (n3 = 2; n3 < n; ++n3) {
                        dArray[n3] = d22 * dArray[n3 - 1] / d2 - dArray[n3 - 2];
                        d22 += 2.0;
                    }
                }
            } else {
                int n6;
                int n7;
                double d29;
                double d30;
                int n8;
                int n9 = n - n3;
                int n10 = n3 + 1;
                double d31 = 2.0 * ((double)n10 + d3);
                double d32 = 1.0;
                double d33 = d31 / d2;
                double d34 = 2.0E16;
                boolean bl = false;
                if (n9 >= 3) {
                    int n11 = n3 + 2;
                    n8 = n - 1;
                    d31 = 2.0 * ((double)(n11 - 1) + d3);
                    int n12 = n11;
                    while (n12 <= n8) {
                        double d35;
                        n10 = n12++;
                        d30 = d32;
                        d32 = d33;
                        d33 = (d31 += 2.0) * d32 / d2 - d30;
                        if (!(d35 > 1.0E292)) continue;
                        double d36 = d33 /= 1.0E308;
                        double d37 = d32 /= 1.0E308;
                        n11 = n10 + 1;
                        do {
                            ++n10;
                        } while ((d33 = (d31 += 2.0) * (d32 = d33) / d2 - (d30 = d32)) <= 1.0);
                        double d38 = d29 = d31 / d2;
                        d34 = d30 * d32 * (0.5 - 0.5 / (d38 * d38));
                        d34 /= 1.0E16;
                        d33 = d32 * 1.0E308;
                        d31 -= 2.0;
                        n8 = FastMath.min(n, --n10);
                        for (n7 = n11; n7 <= n8 && !((d36 = d31 * (d37 = d36) / d2 - (d30 = d37)) * d37 > d34); ++n7) {
                        }
                        n2 = n8;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        n10 = n8;
                        d31 = 2.0 * ((double)n10 + d3);
                        d34 = FastMath.max(d34, FastMath.sqrt(d32 * 1.0E16) * FastMath.sqrt(d33 * 2.0));
                    }
                }
                if (!bl) {
                    do {
                        ++n10;
                    } while ((d33 = (d31 += 2.0) * (d32 = d33) / d2 - (d30 = d32)) < d34);
                }
                d31 += 2.0;
                d29 = 0.0;
                double d39 = 1.0 / d33;
                int n13 = 2 * ++n10 - 4 * (n10 / 2);
                double d40 = 0.0;
                double d41 = n10 / 2;
                double d42 = d41 - 1.0 + d3;
                double d43 = d41 * 2.0 + d3;
                if (n13 != 0) {
                    d40 = d39 * d42 * d43 / d41;
                }
                n8 = n10 - n;
                n7 = 0;
                boolean bl2 = false;
                for (n6 = 1; n6 <= n8; ++n6) {
                    --n10;
                    double d44 = d29;
                    d29 = d39;
                    d39 = (d31 -= 2.0) * d29 / d2 - d44;
                    if ((n13 = 2 - n13) == 0) continue;
                    d43 = (d41 -= 1.0) * 2.0 + d3;
                    if (n10 == 1) break;
                    d42 = d41 - 1.0 + d3;
                    if (d42 == 0.0) {
                        d42 = 1.0;
                    }
                    d40 = (d40 + d39 * d43) * d42 / d41;
                }
                dArray[n10 - 1] = d39;
                if (n8 >= 0) {
                    if (n <= 1) {
                        d43 = d3;
                        if (d3 + 1.0 == 1.0) {
                            d43 = 1.0;
                        }
                        d40 += dArray[0] * d43;
                        n7 = 1;
                    } else {
                        dArray[--n10 - 1] = (d31 -= 2.0) * d39 / d2 - d29;
                        if (n10 == 1) {
                            bl2 = true;
                        } else if ((n13 = 2 - n13) != 0) {
                            d43 = (d41 -= 1.0) * 2.0 + d3;
                            d42 = d41 - 1.0 + d3;
                            if (d42 == 0.0) {
                                d42 = 1.0;
                            }
                            d40 = (d40 + dArray[n10 - 1] * d43) * d42 / d41;
                        }
                    }
                }
                if (n7 == 0 && !bl2 && (n8 = n10 - 2) != 0) {
                    for (n6 = 1; n6 <= n8; ++n6) {
                        dArray[--n10 - 1] = (d31 -= 2.0) * dArray[n10] / d2 - dArray[n10 + 1];
                        if ((n13 = 2 - n13) == 0) continue;
                        d43 = (d41 -= 1.0) * 2.0 + d3;
                        d42 = d41 - 1.0 + d3;
                        if (d42 == 0.0) {
                            d42 = 1.0;
                        }
                        d40 = (d40 + dArray[n10 - 1] * d43) * d42 / d41;
                    }
                }
                if (n7 == 0) {
                    if (!bl2) {
                        dArray[0] = 2.0 * (d3 + 1.0) * dArray[1] / d2 - dArray[2];
                    }
                    if ((d43 = (d41 -= 1.0) * 2.0 + d3) == 0.0) {
                        d43 = 1.0;
                    }
                    d40 += dArray[0] * d43;
                }
                if (FastMath.abs(d3) > 1.0E-16) {
                    d40 *= Gamma.gamma(d3) * FastMath.pow(d2 * 0.5, -d3);
                }
                d39 = 8.9E-308;
                if (d40 > 1.0) {
                    d39 = d40 * 8.9E-308;
                }
                n10 = 0;
                while (n10 < n) {
                    if (FastMath.abs(dArray[n10]) < d39) {
                        dArray[n10] = 0.0;
                    }
                    int n14 = n10++;
                    dArray[n14] = dArray[n14] / d40;
                }
            }
        } else {
            if (dArray.length > 0) {
                dArray[0] = 0.0;
            }
            n2 = FastMath.min(n, 0) - 1;
        }
        return new BesselJ$BesselJResult(MathArrays.copyOf(dArray, dArray.length), n2);
    }
}

