/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.random;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathIllegalStateException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.EmpiricalDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.RandomDataGenerator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.RandomDataImpl;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.RandomGenerator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;

public class ValueServer {
    public static final int DIGEST_MODE = 0;
    public static final int REPLAY_MODE = 1;
    public static final int UNIFORM_MODE = 2;
    public static final int EXPONENTIAL_MODE = 3;
    public static final int GAUSSIAN_MODE = 4;
    public static final int CONSTANT_MODE = 5;
    private int mode = 5;
    private URL valuesFileURL = null;
    private double mu = 0.0;
    private double sigma = 0.0;
    private EmpiricalDistribution empiricalDistribution = null;
    private BufferedReader filePointer = null;
    private final RandomDataGenerator randomData;

    public ValueServer() {
        this.randomData = new RandomDataGenerator();
    }

    @Deprecated
    public ValueServer(RandomDataImpl randomDataImpl) {
        this.randomData = randomDataImpl.getDelegate();
    }

    public ValueServer(RandomGenerator randomGenerator) {
        this.randomData = new RandomDataGenerator(randomGenerator);
    }

    public double getNext() {
        switch (this.mode) {
            case 0: {
                return this.getNextDigest();
            }
            case 1: {
                return this.getNextReplay();
            }
            case 2: {
                return this.getNextUniform();
            }
            case 3: {
                return this.getNextExponential();
            }
            case 4: {
                return this.getNextGaussian();
            }
            case 5: {
                return this.mu;
            }
        }
        throw new MathIllegalStateException(LocalizedFormats.UNKNOWN_MODE, this.mode, "DIGEST_MODE", 0, "REPLAY_MODE", 1, "UNIFORM_MODE", 2, "EXPONENTIAL_MODE", 3, "GAUSSIAN_MODE", 4, "CONSTANT_MODE", 5);
    }

    public void fill(double[] dArray) {
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            dArray[i2] = this.getNext();
        }
    }

    public double[] fill(int n) {
        double[] dArray = new double[n];
        for (int i2 = 0; i2 < n; ++i2) {
            dArray[i2] = this.getNext();
        }
        return dArray;
    }

    public void computeDistribution() {
        this.computeDistribution(1000);
    }

    public void computeDistribution(int n) {
        this.empiricalDistribution = new EmpiricalDistribution(n, this.randomData.getRandomGenerator());
        this.empiricalDistribution.load(this.valuesFileURL);
        this.mu = this.empiricalDistribution.getSampleStats().getMean();
        this.sigma = this.empiricalDistribution.getSampleStats().getStandardDeviation();
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int n) {
        this.mode = n;
    }

    public URL getValuesFileURL() {
        return this.valuesFileURL;
    }

    public void setValuesFileURL(String string) {
        this.valuesFileURL = new URL(string);
    }

    public void setValuesFileURL(URL uRL) {
        this.valuesFileURL = uRL;
    }

    public EmpiricalDistribution getEmpiricalDistribution() {
        return this.empiricalDistribution;
    }

    public void resetReplayFile() {
        if (this.filePointer != null) {
            try {
                this.filePointer.close();
                this.filePointer = null;
            }
            catch (IOException iOException) {}
        }
        this.filePointer = new BufferedReader(new InputStreamReader(this.valuesFileURL.openStream(), "UTF-8"));
    }

    public void closeReplayFile() {
        if (this.filePointer != null) {
            this.filePointer.close();
            this.filePointer = null;
        }
    }

    public double getMu() {
        return this.mu;
    }

    public void setMu(double d2) {
        this.mu = d2;
    }

    public double getSigma() {
        return this.sigma;
    }

    public void setSigma(double d2) {
        this.sigma = d2;
    }

    public void reSeed(long l) {
        this.randomData.reSeed(l);
    }

    private double getNextDigest() {
        if (this.empiricalDistribution == null || this.empiricalDistribution.getBinStats().size() == 0) {
            throw new MathIllegalStateException(LocalizedFormats.DIGEST_NOT_INITIALIZED, new Object[0]);
        }
        return this.empiricalDistribution.getNextValue();
    }

    private double getNextReplay() {
        String string;
        if (this.filePointer == null) {
            this.resetReplayFile();
        }
        if ((string = this.filePointer.readLine()) == null) {
            this.closeReplayFile();
            this.resetReplayFile();
            string = this.filePointer.readLine();
            if (string == null) {
                throw new MathIllegalStateException(LocalizedFormats.URL_CONTAINS_NO_DATA, this.valuesFileURL);
            }
        }
        return Double.parseDouble(string);
    }

    private double getNextUniform() {
        return this.randomData.nextUniform(0.0, 2.0 * this.mu);
    }

    private double getNextExponential() {
        return this.randomData.nextExponential(this.mu);
    }

    private double getNextGaussian() {
        return this.randomData.nextGaussian(this.mu, this.sigma);
    }
}

