/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.random;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.MersenneTwister;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.RandomGenerator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.RandomVectorGenerator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

public class UnitSphereRandomVectorGenerator
implements RandomVectorGenerator {
    private final RandomGenerator rand;
    private final int dimension;

    public UnitSphereRandomVectorGenerator(int n, RandomGenerator randomGenerator) {
        this.dimension = n;
        this.rand = randomGenerator;
    }

    public UnitSphereRandomVectorGenerator(int n) {
        this(n, new MersenneTwister());
    }

    public double[] nextVector() {
        double[] dArray = new double[this.dimension];
        double d2 = 0.0;
        for (int i2 = 0; i2 < this.dimension; ++i2) {
            double d3;
            dArray[i2] = d3 = this.rand.nextGaussian();
            double d4 = d3;
            d2 += d4 * d4;
        }
        double d5 = 1.0 / FastMath.sqrt(d2);
        int n = 0;
        while (n < this.dimension) {
            int n2 = n++;
            dArray[n2] = dArray[n2] * d5;
        }
        return dArray;
    }
}

