/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.random;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.NormalizedRandomGenerator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.RandomVectorGenerator;
import java.util.Arrays;

public class UncorrelatedRandomVectorGenerator
implements RandomVectorGenerator {
    private final NormalizedRandomGenerator generator;
    private final double[] mean;
    private final double[] standardDeviation;

    public UncorrelatedRandomVectorGenerator(double[] dArray, double[] dArray2, NormalizedRandomGenerator normalizedRandomGenerator) {
        if (dArray.length != dArray2.length) {
            throw new DimensionMismatchException(dArray.length, dArray2.length);
        }
        this.mean = (double[])dArray.clone();
        this.standardDeviation = (double[])dArray2.clone();
        this.generator = normalizedRandomGenerator;
    }

    public UncorrelatedRandomVectorGenerator(int n, NormalizedRandomGenerator normalizedRandomGenerator) {
        this.mean = new double[n];
        this.standardDeviation = new double[n];
        Arrays.fill(this.standardDeviation, 1.0);
        this.generator = normalizedRandomGenerator;
    }

    public double[] nextVector() {
        double[] dArray = new double[this.mean.length];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            dArray[i2] = this.mean[i2] + this.standardDeviation[i2] * this.generator.nextNormalizedDouble();
        }
        return dArray;
    }
}

