/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.random;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NullArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.OutOfRangeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.NormalizedRandomGenerator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.RandomGenerator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

public class StableRandomGenerator
implements NormalizedRandomGenerator {
    private final RandomGenerator generator;
    private final double alpha;
    private final double beta;
    private final double zeta;

    public StableRandomGenerator(RandomGenerator randomGenerator, double d2, double d3) {
        if (randomGenerator == null) {
            throw new NullArgumentException();
        }
        if (!(d2 > 0.0) || !(d2 <= 2.0)) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.OUT_OF_RANGE_LEFT, (Number)d2, 0, 2);
        }
        if (!(d3 >= -1.0) || !(d3 <= 1.0)) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.OUT_OF_RANGE_SIMPLE, (Number)d3, -1, 1);
        }
        this.generator = randomGenerator;
        this.alpha = d2;
        this.beta = d3;
        if (d2 < 2.0 && d3 != 0.0) {
            this.zeta = d3 * FastMath.tan(d2 * Math.PI / 2.0);
            return;
        }
        this.zeta = 0.0;
    }

    public double nextNormalizedDouble() {
        double d2;
        double d3 = -FastMath.log(this.generator.nextDouble());
        double d4 = Math.PI * (this.generator.nextDouble() - 0.5);
        if (this.alpha == 2.0) {
            return FastMath.sqrt(d3 * 2.0) * FastMath.sin(d4);
        }
        if (this.beta == 0.0) {
            d2 = this.alpha == 1.0 ? FastMath.tan(d4) : FastMath.pow(d3 * FastMath.cos((1.0 - this.alpha) * d4), 1.0 / this.alpha - 1.0) * FastMath.sin(this.alpha * d4) / FastMath.pow(FastMath.cos(d4), 1.0 / this.alpha);
        } else {
            double d5 = FastMath.cos(d4);
            if (FastMath.abs(this.alpha - 1.0) > 1.0E-8) {
                double d6 = this.alpha * d4;
                double d7 = d4 - d6;
                d2 = (FastMath.sin(d6) + this.zeta * FastMath.cos(d6)) / d5 * (FastMath.cos(d7) + this.zeta * FastMath.sin(d7)) / FastMath.pow(d3 * d5, (1.0 - this.alpha) / this.alpha);
            } else {
                double d8 = 1.5707963267948966 + this.beta * d4;
                d2 = 0.6366197723675814 * (d8 * FastMath.tan(d4) - this.beta * FastMath.log(d3 * 1.5707963267948966 * d5 / d8));
                if (this.alpha != 1.0) {
                    d2 += this.beta * FastMath.tan(Math.PI * this.alpha / 2.0);
                }
            }
        }
        return d2;
    }
}

