/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.random;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathInternalError;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathParseException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotStrictlyPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.OutOfRangeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.RandomVectorGenerator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class SobolSequenceGenerator
implements RandomVectorGenerator {
    private static final int BITS = 52;
    private static final double SCALE = FastMath.pow(2.0, 52);
    private static final int MAX_DIMENSION = 1000;
    private static final String RESOURCE_NAME = "/assets/org/apache/commons/math3/random/new-joe-kuo-6.1000";
    private static final String FILE_CHARSET = "US-ASCII";
    private final int dimension;
    private int count = 0;
    private final long[][] direction;
    private final long[] x;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SobolSequenceGenerator(int n) {
        if (n <= 0) throw new OutOfRangeException(n, (Number)1, 1000);
        if (n > 1000) {
            throw new OutOfRangeException(n, (Number)1, 1000);
        }
        InputStream inputStream = this.getClass().getResourceAsStream(RESOURCE_NAME);
        if (inputStream == null) {
            throw new MathInternalError();
        }
        this.dimension = n;
        this.direction = new long[n][53];
        this.x = new long[n];
        try {
            this.initFromStream(inputStream);
        }
        catch (IOException iOException) {
            try {
                throw new MathInternalError();
                catch (MathParseException mathParseException) {
                    throw new MathInternalError();
                }
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
        }
        try {
            inputStream.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public SobolSequenceGenerator(int n, InputStream inputStream) {
        if (n <= 0) {
            throw new NotStrictlyPositiveException(n);
        }
        this.dimension = n;
        this.direction = new long[n][53];
        this.x = new long[n];
        int n2 = this.initFromStream(inputStream);
        if (n2 < n) {
            throw new OutOfRangeException(n, (Number)1, n2);
        }
    }

    private int initFromStream(InputStream closeable) {
        for (int i2 = 1; i2 <= 52; ++i2) {
            this.direction[0][i2] = 1L << 52 - i2;
        }
        Charset charset = Charset.forName(FILE_CHARSET);
        closeable = new BufferedReader(new InputStreamReader((InputStream)closeable, charset));
        int n = -1;
        try {
            String string;
            ((BufferedReader)closeable).readLine();
            int n2 = 2;
            int n3 = 1;
            while ((string = ((BufferedReader)closeable).readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
                try {
                    int n4;
                    n = Integer.parseInt(stringTokenizer.nextToken());
                    if (n >= 2 && n <= this.dimension) {
                        n4 = Integer.parseInt(stringTokenizer.nextToken());
                        int n5 = Integer.parseInt(stringTokenizer.nextToken());
                        int[] nArray = new int[n4 + 1];
                        for (int i3 = 1; i3 <= n4; ++i3) {
                            nArray[i3] = Integer.parseInt(stringTokenizer.nextToken());
                        }
                        this.initDirectionVector(n3++, n5, nArray);
                    }
                    if (n > this.dimension) {
                        n4 = n;
                        return n4;
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    throw new MathParseException(string, n2);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MathParseException(string, n2);
                }
                ++n2;
            }
        }
        finally {
            ((BufferedReader)closeable).close();
        }
        return n;
    }

    private void initDirectionVector(int n, int n2, int[] nArray) {
        int n3;
        int n4 = nArray.length - 1;
        for (n3 = 1; n3 <= n4; ++n3) {
            this.direction[n][n3] = (long)nArray[n3] << 52 - n3;
        }
        for (n3 = n4 + 1; n3 <= 52; ++n3) {
            long[] lArray = this.direction[n];
            lArray[n3] = lArray[n3 - n4] ^ this.direction[n][n3 - n4] >> n4;
            for (int i2 = 1; i2 <= n4 - 1; ++i2) {
                long[] lArray2 = this.direction[n];
                int n5 = n3;
                lArray2[n5] = lArray2[n5] ^ (long)(n2 >> n4 - 1 - i2 & 1) * this.direction[n][n3 - i2];
            }
        }
    }

    public double[] nextVector() {
        double[] dArray = new double[this.dimension];
        if (this.count == 0) {
            ++this.count;
            return dArray;
        }
        int n = 1;
        int n2 = this.count - 1;
        while ((n2 & 1) == 1) {
            n2 >>= 1;
            ++n;
        }
        for (n2 = 0; n2 < this.dimension; ++n2) {
            int n3 = n2;
            this.x[n3] = this.x[n3] ^ this.direction[n2][n];
            dArray[n2] = (double)this.x[n2] / SCALE;
        }
        ++this.count;
        return dArray;
    }

    public double[] skipTo(int n) {
        if (n == 0) {
            Arrays.fill(this.x, 0L);
        } else {
            int n2 = n - 1;
            long l = n2 ^ n2 >> 1;
            for (n2 = 0; n2 < this.dimension; ++n2) {
                long l2;
                long l3 = 0L;
                for (int i2 = 1; i2 <= 52 && (l2 = l >> i2 - 1) != 0L; ++i2) {
                    long l4 = l2 & 1L;
                    l3 ^= l4 * this.direction[n2][i2];
                }
                this.x[n2] = l3;
            }
        }
        this.count = n;
        return this.nextVector();
    }

    public int getNextIndex() {
        return this.count;
    }
}

