/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.random;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.AbstractIntegerDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.AbstractRealDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.BetaDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.BinomialDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.CauchyDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.ChiSquaredDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.ExponentialDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.FDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.GammaDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.HypergeometricDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.PascalDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.PoissonDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.TDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.UniformIntegerDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.WeibullDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.ZipfDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathInternalError;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotANumberException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotFiniteNumberException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotStrictlyPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooLargeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.RandomData;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.RandomGenerator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.RandomGeneratorFactory;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.Well19937c;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomDataGenerator
implements RandomData,
Serializable {
    private static final long serialVersionUID = -626730818244969716L;
    private RandomGenerator rand = null;
    private RandomGenerator secRand = null;

    public RandomDataGenerator() {
    }

    public RandomDataGenerator(RandomGenerator randomGenerator) {
        this.rand = randomGenerator;
    }

    @Override
    public String nextHexString(int n) {
        if (n <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.LENGTH, n);
        }
        RandomGenerator randomGenerator = this.getRandomGenerator();
        StringBuilder stringBuilder = new StringBuilder();
        byte[] byArray = new byte[n / 2 + 1];
        randomGenerator.nextBytes(byArray);
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            Object object = (int)byArray[i2];
            if (((String)(object = Integer.toHexString((Integer)object + 128))).length() == 1) {
                object = "0" + (String)object;
            }
            stringBuilder.append((String)object);
        }
        return stringBuilder.toString().substring(0, n);
    }

    @Override
    public int nextInt(int n, int n2) {
        return ((AbstractIntegerDistribution)new UniformIntegerDistribution(this.getRandomGenerator(), n, n2)).sample();
    }

    @Override
    public long nextLong(long l, long l2) {
        if (l >= l2) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_BOUND_NOT_BELOW_UPPER_BOUND, (Number)l, l2, false);
        }
        long l3 = l2 - l + 1L;
        if (l3 <= 0L) {
            long l4;
            RandomGenerator randomGenerator = this.getRandomGenerator();
            while ((l4 = randomGenerator.nextLong()) < l || l4 > l2) {
            }
            return l4;
        }
        if (l3 < Integer.MAX_VALUE) {
            return l + (long)this.getRandomGenerator().nextInt((int)l3);
        }
        return l + RandomDataGenerator.nextLong(this.getRandomGenerator(), l3);
    }

    private static long nextLong(RandomGenerator randomGenerator, long l) {
        if (l > 0L) {
            long l2;
            long l3;
            byte[] byArray = new byte[8];
            do {
                randomGenerator.nextBytes(byArray);
                l2 = 0L;
                byte[] byArray2 = byArray;
                int cfr_ignored_0 = byArray.length;
                for (int i2 = 0; i2 < 8; ++i2) {
                    byte by = byArray2[i2];
                    l2 = l2 << 8 | (long)by & 0xFFL;
                }
            } while ((l2 &= Long.MAX_VALUE) - (l3 = l2 % l) + (l - 1L) < 0L);
            return l3;
        }
        throw new NotStrictlyPositiveException(l);
    }

    @Override
    public String nextSecureHexString(int n) {
        MessageDigest messageDigest;
        if (n <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.LENGTH, n);
        }
        RandomGenerator randomGenerator = this.getSecRan();
        try {
            messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new MathInternalError(noSuchAlgorithmException);
        }
        messageDigest.reset();
        int n2 = n / 40 + 1;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 1; i2 < n2 + 1; ++i2) {
            byte[] byArray = new byte[40];
            randomGenerator.nextBytes(byArray);
            messageDigest.update(byArray);
            byArray = messageDigest.digest();
            for (int i3 = 0; i3 < byArray.length; ++i3) {
                Object object = (int)byArray[i3];
                if (((String)(object = Integer.toHexString((Integer)object + 128))).length() == 1) {
                    object = "0" + (String)object;
                }
                stringBuilder.append((String)object);
            }
        }
        return stringBuilder.toString().substring(0, n);
    }

    @Override
    public int nextSecureInt(int n, int n2) {
        return ((AbstractIntegerDistribution)new UniformIntegerDistribution(this.getSecRan(), n, n2)).sample();
    }

    @Override
    public long nextSecureLong(long l, long l2) {
        if (l >= l2) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_BOUND_NOT_BELOW_UPPER_BOUND, (Number)l, l2, false);
        }
        RandomGenerator randomGenerator = this.getSecRan();
        long l3 = l2 - l + 1L;
        if (l3 <= 0L) {
            long l4;
            while ((l4 = randomGenerator.nextLong()) < l || l4 > l2) {
            }
            return l4;
        }
        if (l3 < Integer.MAX_VALUE) {
            return l + (long)randomGenerator.nextInt((int)l3);
        }
        return l + RandomDataGenerator.nextLong(randomGenerator, l3);
    }

    @Override
    public long nextPoisson(double d2) {
        return ((AbstractIntegerDistribution)new PoissonDistribution(this.getRandomGenerator(), d2, 1.0E-12, 10000000)).sample();
    }

    @Override
    public double nextGaussian(double d2, double d3) {
        if (d3 <= 0.0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.STANDARD_DEVIATION, d3);
        }
        return d3 * this.getRandomGenerator().nextGaussian() + d2;
    }

    @Override
    public double nextExponential(double d2) {
        return ((AbstractRealDistribution)new ExponentialDistribution(this.getRandomGenerator(), d2, 1.0E-9)).sample();
    }

    public double nextGamma(double d2, double d3) {
        return ((AbstractRealDistribution)new GammaDistribution(this.getRandomGenerator(), d2, d3, 1.0E-9)).sample();
    }

    public int nextHypergeometric(int n, int n2, int n3) {
        return new HypergeometricDistribution(this.getRandomGenerator(), n, n2, n3).sample();
    }

    public int nextPascal(int n, double d2) {
        return new PascalDistribution(this.getRandomGenerator(), n, d2).sample();
    }

    public double nextT(double d2) {
        return new TDistribution(this.getRandomGenerator(), d2, 1.0E-9).sample();
    }

    public double nextWeibull(double d2, double d3) {
        return new WeibullDistribution(this.getRandomGenerator(), d2, d3, 1.0E-9).sample();
    }

    public int nextZipf(int n, double d2) {
        return ((AbstractIntegerDistribution)new ZipfDistribution(this.getRandomGenerator(), n, d2)).sample();
    }

    public double nextBeta(double d2, double d3) {
        return ((AbstractRealDistribution)new BetaDistribution(this.getRandomGenerator(), d2, d3, 1.0E-9)).sample();
    }

    public int nextBinomial(int n, double d2) {
        return new BinomialDistribution(this.getRandomGenerator(), n, d2).sample();
    }

    public double nextCauchy(double d2, double d3) {
        return new CauchyDistribution(this.getRandomGenerator(), d2, d3, 1.0E-9).sample();
    }

    public double nextChiSquare(double d2) {
        return new ChiSquaredDistribution(this.getRandomGenerator(), d2, 1.0E-9).sample();
    }

    public double nextF(double d2, double d3) {
        return new FDistribution(this.getRandomGenerator(), d2, d3, 1.0E-9).sample();
    }

    @Override
    public double nextUniform(double d2, double d3) {
        return this.nextUniform(d2, d3, false);
    }

    @Override
    public double nextUniform(double d2, double d3, boolean bl) {
        if (d2 >= d3) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_BOUND_NOT_BELOW_UPPER_BOUND, (Number)d2, d3, false);
        }
        if (Double.isInfinite(d2)) {
            throw new NotFiniteNumberException((Localizable)LocalizedFormats.INFINITE_BOUND, d2, new Object[0]);
        }
        if (Double.isInfinite(d3)) {
            throw new NotFiniteNumberException((Localizable)LocalizedFormats.INFINITE_BOUND, d3, new Object[0]);
        }
        if (Double.isNaN(d2) || Double.isNaN(d3)) {
            throw new NotANumberException();
        }
        RandomGenerator randomGenerator = this.getRandomGenerator();
        double d4 = randomGenerator.nextDouble();
        while (!bl && d4 <= 0.0) {
            d4 = randomGenerator.nextDouble();
        }
        return d4 * d3 + (1.0 - d4) * d2;
    }

    @Override
    public int[] nextPermutation(int n, int n2) {
        if (n2 > n) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.PERMUTATION_EXCEEDS_N, (Number)n2, n, true);
        }
        if (n2 <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.PERMUTATION_SIZE, n2);
        }
        int[] nArray = MathArrays.natural(n);
        MathArrays.shuffle(nArray, this.getRandomGenerator());
        return MathArrays.copyOf(nArray, n2);
    }

    @Override
    public Object[] nextSample(Collection<?> objectArray, int n) {
        int n2 = objectArray.size();
        if (n > n2) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.SAMPLE_SIZE_EXCEEDS_COLLECTION_SIZE, (Number)n, n2, true);
        }
        if (n <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NUMBER_OF_SAMPLES, n);
        }
        objectArray = objectArray.toArray();
        int[] nArray = this.nextPermutation(n2, n);
        Object[] objectArray2 = new Object[n];
        for (int i2 = 0; i2 < n; ++i2) {
            objectArray2[i2] = objectArray[nArray[i2]];
        }
        return objectArray2;
    }

    public void reSeed(long l) {
        this.getRandomGenerator().setSeed(l);
    }

    public void reSeedSecure() {
        this.getSecRan().setSeed(System.currentTimeMillis());
    }

    public void reSeedSecure(long l) {
        this.getSecRan().setSeed(l);
    }

    public void reSeed() {
        this.getRandomGenerator().setSeed(System.currentTimeMillis() + (long)System.identityHashCode(this));
    }

    public void setSecureAlgorithm(String string, String string2) {
        this.secRand = RandomGeneratorFactory.createRandomGenerator(SecureRandom.getInstance(string, string2));
    }

    public RandomGenerator getRandomGenerator() {
        if (this.rand == null) {
            this.initRan();
        }
        return this.rand;
    }

    private void initRan() {
        this.rand = new Well19937c(System.currentTimeMillis() + (long)System.identityHashCode(this));
    }

    private RandomGenerator getSecRan() {
        if (this.secRand == null) {
            this.secRand = RandomGeneratorFactory.createRandomGenerator(new SecureRandom());
            this.secRand.setSeed(System.currentTimeMillis() + (long)System.identityHashCode(this));
        }
        return this.secRand;
    }
}

