/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.random;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.BitsStreamGenerator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import java.io.Serializable;

public class MersenneTwister
extends BitsStreamGenerator
implements Serializable {
    private static final long serialVersionUID = 8661194735290153518L;
    private static final int N = 624;
    private static final int M = 397;
    private static final int[] MAG01 = new int[]{0, -1727483681};
    private int[] mt = new int[624];
    private int mti;

    public MersenneTwister() {
        ((BitsStreamGenerator)this).setSeed(System.currentTimeMillis() + (long)System.identityHashCode(this));
    }

    public MersenneTwister(int n) {
        ((BitsStreamGenerator)this).setSeed(n);
    }

    public MersenneTwister(int[] nArray) {
        ((BitsStreamGenerator)this).setSeed(nArray);
    }

    public MersenneTwister(long l) {
        ((BitsStreamGenerator)this).setSeed(l);
    }

    public void setSeed(int n) {
        long l = n;
        this.mt[0] = (int)l;
        this.mti = 1;
        while (this.mti < 624) {
            long l2 = l;
            l = 1812433253L * (l2 ^ l2 >> 30) + (long)this.mti & 0xFFFFFFFFL;
            this.mt[this.mti] = (int)l;
            ++this.mti;
        }
        this.clear();
    }

    public void setSeed(int[] nArray) {
        long l;
        long l2;
        long l3;
        int n;
        if (nArray == null) {
            ((BitsStreamGenerator)this).setSeed(System.currentTimeMillis() + (long)System.identityHashCode(this));
            return;
        }
        ((BitsStreamGenerator)this).setSeed(19650218);
        int n2 = 1;
        int n3 = 0;
        for (n = FastMath.max(624, nArray.length); n != 0; --n) {
            l3 = (long)this.mt[n2] & Integer.MAX_VALUE | (this.mt[n2] < 0 ? 0x80000000L : 0L);
            long l4 = l2 = (long)this.mt[n2 - 1] & Integer.MAX_VALUE | (this.mt[n2 - 1] < 0 ? 0x80000000L : 0L);
            l = (l3 ^ (l4 ^ l4 >> 30) * 1664525L) + (long)nArray[n3] + (long)n3;
            this.mt[n2] = (int)l;
            ++n3;
            if (++n2 >= 624) {
                this.mt[0] = this.mt[623];
                n2 = 1;
            }
            if (n3 < nArray.length) continue;
            n3 = 0;
        }
        for (n = 623; n != 0; --n) {
            l3 = (long)this.mt[n2] & Integer.MAX_VALUE | (this.mt[n2] < 0 ? 0x80000000L : 0L);
            long l5 = l2 = (long)this.mt[n2 - 1] & Integer.MAX_VALUE | (this.mt[n2 - 1] < 0 ? 0x80000000L : 0L);
            l = (l3 ^ (l5 ^ l5 >> 30) * 1566083941L) - (long)n2;
            this.mt[n2] = (int)l;
            if (++n2 < 624) continue;
            this.mt[0] = this.mt[623];
            n2 = 1;
        }
        this.mt[0] = Integer.MIN_VALUE;
        this.clear();
    }

    public void setSeed(long l) {
        ((BitsStreamGenerator)this).setSeed(new int[]{(int)(l >>> 32), (int)l});
    }

    protected int next(int n) {
        int n2;
        if (this.mti >= 624) {
            int n3;
            int n4 = this.mt[0];
            for (n3 = 0; n3 < 227; ++n3) {
                n2 = n4;
                n4 = this.mt[n3 + 1];
                n2 = n2 & Integer.MIN_VALUE | n4 & Integer.MAX_VALUE;
                this.mt[n3] = this.mt[n3 + 397] ^ n2 >>> 1 ^ MAG01[n2 & 1];
            }
            for (n3 = 227; n3 < 623; ++n3) {
                n2 = n4;
                n4 = this.mt[n3 + 1];
                n2 = n2 & Integer.MIN_VALUE | n4 & Integer.MAX_VALUE;
                this.mt[n3] = this.mt[n3 + -227] ^ n2 >>> 1 ^ MAG01[n2 & 1];
            }
            n2 = n4 & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
            this.mt[623] = this.mt[396] ^ n2 >>> 1 ^ MAG01[n2 & 1];
            this.mti = 0;
        }
        n2 = this.mt[this.mti++];
        n2 ^= n2 >>> 11;
        n2 ^= n2 << 7 & 0x9D2C5680;
        n2 ^= n2 << 15 & 0xEFC60000;
        n2 ^= n2 >>> 18;
        return n2 >>> 32 - n;
    }
}

