/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.random;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.OutOfRangeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.RandomVectorGenerator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;

public class HaltonSequenceGenerator
implements RandomVectorGenerator {
    private static final int[] PRIMES = new int[]{2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97, 101, 103, 107, 109, 113, 127, 131, 137, 139, 149, 151, 157, 163, 167, 173};
    private static final int[] WEIGHTS = new int[]{1, 2, 3, 3, 8, 11, 12, 14, 7, 18, 12, 13, 17, 18, 29, 14, 18, 43, 41, 44, 40, 30, 47, 65, 71, 28, 40, 60, 79, 89, 56, 50, 52, 61, 108, 56, 66, 63, 60, 66};
    private final int dimension;
    private int count = 0;
    private final int[] base;
    private final int[] weight;

    public HaltonSequenceGenerator(int n) {
        this(n, PRIMES, WEIGHTS);
    }

    public HaltonSequenceGenerator(int n, int[] nArray, int[] nArray2) {
        MathUtils.checkNotNull(nArray);
        if (n <= 0 || n > nArray.length) {
            throw new OutOfRangeException(n, (Number)1, PRIMES.length);
        }
        if (nArray2 != null && nArray2.length != nArray.length) {
            throw new DimensionMismatchException(nArray2.length, nArray.length);
        }
        this.dimension = n;
        this.base = (int[])nArray.clone();
        this.weight = nArray2 == null ? null : (int[])nArray2.clone();
        this.count = 0;
    }

    public double[] nextVector() {
        double[] dArray = new double[this.dimension];
        for (int i2 = 0; i2 < this.dimension; ++i2) {
            int n = this.count;
            double d2 = 1.0 / (double)this.base[i2];
            while (n > 0) {
                int n2 = this.scramble(i2, 0, this.base[i2], n % this.base[i2]);
                int n3 = i2;
                dArray[n3] = dArray[n3] + d2 * (double)n2;
                n /= this.base[i2];
                d2 /= (double)this.base[i2];
            }
        }
        ++this.count;
        return dArray;
    }

    protected int scramble(int n, int n2, int n3, int n4) {
        if (this.weight != null) {
            return this.weight[n] * n4 % n3;
        }
        return n4;
    }

    public double[] skipTo(int n) {
        this.count = n;
        return this.nextVector();
    }

    public int getNextIndex() {
        return this.count;
    }
}

