/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.random;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.AbstractRealDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.ConstantRealDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.NormalDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.distribution.RealDistribution;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathIllegalStateException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathInternalError;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotStrictlyPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.OutOfRangeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.ZeroException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.EmpiricalDistribution$ArrayDataAdapter;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.EmpiricalDistribution$DataAdapter;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.EmpiricalDistribution$StreamDataAdapter;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.RandomDataGenerator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.RandomDataImpl;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.RandomGenerator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.StatisticalSummary;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.stat.descriptive.SummaryStatistics;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmpiricalDistribution
extends AbstractRealDistribution {
    public static final int DEFAULT_BIN_COUNT = 1000;
    private static final String FILE_CHARSET = "US-ASCII";
    private static final long serialVersionUID = 5729073523949762654L;
    protected final RandomDataGenerator randomData;
    private final List<SummaryStatistics> binStats;
    private SummaryStatistics sampleStats = null;
    private double max = Double.NEGATIVE_INFINITY;
    private double min = Double.POSITIVE_INFINITY;
    private double delta = 0.0;
    private final int binCount;
    private boolean loaded = false;
    private double[] upperBounds = null;

    public EmpiricalDistribution() {
        this(1000);
    }

    public EmpiricalDistribution(int n) {
        this(n, new RandomDataGenerator());
    }

    public EmpiricalDistribution(int n, RandomGenerator randomGenerator) {
        this(n, new RandomDataGenerator(randomGenerator));
    }

    public EmpiricalDistribution(RandomGenerator randomGenerator) {
        this(1000, randomGenerator);
    }

    @Deprecated
    public EmpiricalDistribution(int n, RandomDataImpl randomDataImpl) {
        this(n, randomDataImpl.getDelegate());
    }

    @Deprecated
    public EmpiricalDistribution(RandomDataImpl randomDataImpl) {
        this(1000, randomDataImpl);
    }

    private EmpiricalDistribution(int n, RandomDataGenerator randomDataGenerator) {
        super(randomDataGenerator.getRandomGenerator());
        if (n <= 0) {
            throw new NotStrictlyPositiveException(n);
        }
        this.binCount = n;
        this.randomData = randomDataGenerator;
        this.binStats = new ArrayList<SummaryStatistics>();
    }

    public void load(double[] dArray) {
        EmpiricalDistribution$ArrayDataAdapter empiricalDistribution$ArrayDataAdapter = new EmpiricalDistribution$ArrayDataAdapter(this, dArray);
        try {
            ((EmpiricalDistribution$DataAdapter)empiricalDistribution$ArrayDataAdapter).computeStats();
            this.fillBinStats(new EmpiricalDistribution$ArrayDataAdapter(this, dArray));
        }
        catch (IOException iOException) {
            throw new MathInternalError();
        }
        this.loaded = true;
    }

    public void load(URL uRL) {
        MathUtils.checkNotNull(uRL);
        Charset charset = Charset.forName(FILE_CHARSET);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream(), charset));
        try {
            EmpiricalDistribution$StreamDataAdapter empiricalDistribution$StreamDataAdapter = new EmpiricalDistribution$StreamDataAdapter(this, bufferedReader);
            ((EmpiricalDistribution$DataAdapter)empiricalDistribution$StreamDataAdapter).computeStats();
            if (this.sampleStats.getN() == 0L) {
                throw new ZeroException((Localizable)LocalizedFormats.URL_CONTAINS_NO_DATA, uRL);
            }
            bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream(), charset));
            this.fillBinStats(new EmpiricalDistribution$StreamDataAdapter(this, bufferedReader));
            this.loaded = true;
        }
        catch (Throwable throwable) {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            bufferedReader.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public void load(File file) {
        MathUtils.checkNotNull(file);
        Charset charset = Charset.forName(FILE_CHARSET);
        Object object = new FileInputStream(file);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object, charset));
        try {
            object = new EmpiricalDistribution$StreamDataAdapter(this, bufferedReader);
            ((EmpiricalDistribution$DataAdapter)object).computeStats();
            object = new FileInputStream(file);
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object, charset));
            this.fillBinStats(new EmpiricalDistribution$StreamDataAdapter(this, bufferedReader));
            this.loaded = true;
        }
        catch (Throwable throwable) {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            bufferedReader.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    private void fillBinStats(EmpiricalDistribution$DataAdapter empiricalDistribution$DataAdapter) {
        int n;
        this.min = this.sampleStats.getMin();
        this.max = this.sampleStats.getMax();
        this.delta = (this.max - this.min) / (double)this.binCount;
        if (!this.binStats.isEmpty()) {
            this.binStats.clear();
        }
        for (n = 0; n < this.binCount; ++n) {
            SummaryStatistics summaryStatistics = new SummaryStatistics();
            this.binStats.add(n, summaryStatistics);
        }
        empiricalDistribution$DataAdapter.computeBinStats();
        this.upperBounds = new double[this.binCount];
        this.upperBounds[0] = (double)this.binStats.get(0).getN() / (double)this.sampleStats.getN();
        for (n = 1; n < this.binCount - 1; ++n) {
            this.upperBounds[n] = this.upperBounds[n - 1] + (double)this.binStats.get(n).getN() / (double)this.sampleStats.getN();
        }
        this.upperBounds[this.binCount - 1] = 1.0;
    }

    private int findBin(double d2) {
        return FastMath.min(FastMath.max((int)FastMath.ceil((d2 - this.min) / this.delta) - 1, 0), this.binCount - 1);
    }

    public double getNextValue() {
        if (!this.loaded) {
            throw new MathIllegalStateException(LocalizedFormats.DISTRIBUTION_NOT_LOADED, new Object[0]);
        }
        return this.sample();
    }

    public StatisticalSummary getSampleStats() {
        return this.sampleStats;
    }

    public int getBinCount() {
        return this.binCount;
    }

    public List<SummaryStatistics> getBinStats() {
        return this.binStats;
    }

    public double[] getUpperBounds() {
        double[] dArray = new double[this.binCount];
        for (int i2 = 0; i2 < this.binCount - 1; ++i2) {
            dArray[i2] = this.min + this.delta * (double)(i2 + 1);
        }
        dArray[this.binCount - 1] = this.max;
        return dArray;
    }

    public double[] getGeneratorUpperBounds() {
        int n = this.upperBounds.length;
        double[] dArray = new double[n];
        System.arraycopy(this.upperBounds, 0, dArray, 0, n);
        return dArray;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void reSeed(long l) {
        this.randomData.reSeed(l);
    }

    @Override
    public double probability(double d2) {
        return 0.0;
    }

    @Override
    public double density(double d2) {
        if (d2 < this.min || d2 > this.max) {
            return 0.0;
        }
        int n = this.findBin(d2);
        EmpiricalDistribution empiricalDistribution = this;
        RealDistribution realDistribution = empiricalDistribution.getKernel(empiricalDistribution.binStats.get(n));
        return realDistribution.density(d2) * this.pB(n) / this.kB(n);
    }

    @Override
    public double cumulativeProbability(double d2) {
        if (d2 < this.min) {
            return 0.0;
        }
        if (d2 >= this.max) {
            return 1.0;
        }
        int n = this.findBin(d2);
        double d3 = this.pBminus(n);
        double d4 = this.pB(n);
        RealDistribution realDistribution = this.k(d2);
        if (realDistribution instanceof ConstantRealDistribution) {
            if (d2 < realDistribution.getNumericalMean()) {
                return d3;
            }
            return d3 + d4;
        }
        double[] dArray = this.getUpperBounds();
        double d5 = this.kB(n);
        double d6 = n == 0 ? this.min : dArray[n - 1];
        double d7 = (realDistribution.cumulativeProbability(d2) - realDistribution.cumulativeProbability(d6)) / d5;
        return d3 + d4 * d7;
    }

    @Override
    public double inverseCumulativeProbability(double d2) {
        double d3;
        if (d2 < 0.0 || d2 > 1.0) {
            throw new OutOfRangeException(d2, (Number)0, 1);
        }
        if (d2 == 0.0) {
            return this.getSupportLowerBound();
        }
        if (d2 == 1.0) {
            return this.getSupportUpperBound();
        }
        int n = 0;
        while (this.cumBinP(n) < d2) {
            ++n;
        }
        EmpiricalDistribution empiricalDistribution = this;
        RealDistribution realDistribution = empiricalDistribution.getKernel(empiricalDistribution.binStats.get(n));
        double d4 = this.kB(n);
        double[] dArray = this.getUpperBounds();
        double d5 = n == 0 ? this.min : dArray[n - 1];
        double d6 = realDistribution.cumulativeProbability(d5);
        double d7 = this.pB(n);
        double d8 = this.pBminus(n);
        double d9 = d2 - d8;
        if (d3 <= 0.0) {
            return d5;
        }
        return realDistribution.inverseCumulativeProbability(d6 + d9 * d4 / d7);
    }

    @Override
    public double getNumericalMean() {
        return this.sampleStats.getMean();
    }

    @Override
    public double getNumericalVariance() {
        return this.sampleStats.getVariance();
    }

    @Override
    public double getSupportLowerBound() {
        return this.min;
    }

    @Override
    public double getSupportUpperBound() {
        return this.max;
    }

    @Override
    public boolean isSupportLowerBoundInclusive() {
        return true;
    }

    @Override
    public boolean isSupportUpperBoundInclusive() {
        return true;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }

    @Override
    public void reseedRandomGenerator(long l) {
        this.randomData.reSeed(l);
    }

    private double pB(int n) {
        if (n == 0) {
            return this.upperBounds[0];
        }
        return this.upperBounds[n] - this.upperBounds[n - 1];
    }

    private double pBminus(int n) {
        if (n == 0) {
            return 0.0;
        }
        return this.upperBounds[n - 1];
    }

    private double kB(int n) {
        double[] dArray = this.getUpperBounds();
        EmpiricalDistribution empiricalDistribution = this;
        RealDistribution realDistribution = empiricalDistribution.getKernel(empiricalDistribution.binStats.get(n));
        if (n == 0) {
            return realDistribution.cumulativeProbability(this.min, dArray[0]);
        }
        return realDistribution.cumulativeProbability(dArray[n - 1], dArray[n]);
    }

    private RealDistribution k(double d2) {
        int n = this.findBin(d2);
        EmpiricalDistribution empiricalDistribution = this;
        return empiricalDistribution.getKernel(empiricalDistribution.binStats.get(n));
    }

    private double cumBinP(int n) {
        return this.upperBounds[n];
    }

    protected RealDistribution getKernel(SummaryStatistics summaryStatistics) {
        if (summaryStatistics.getN() == 1L || summaryStatistics.getVariance() == 0.0) {
            return new ConstantRealDistribution(summaryStatistics.getMean());
        }
        return new NormalDistribution(this.randomData.getRandomGenerator(), summaryStatistics.getMean(), summaryStatistics.getStandardDeviation(), 1.0E-9);
    }

    static /* synthetic */ int access$100(EmpiricalDistribution empiricalDistribution, double d2) {
        return empiricalDistribution.findBin(d2);
    }

    static /* synthetic */ List access$200(EmpiricalDistribution empiricalDistribution) {
        return empiricalDistribution.binStats;
    }

    static /* synthetic */ SummaryStatistics access$302(EmpiricalDistribution empiricalDistribution, SummaryStatistics summaryStatistics) {
        empiricalDistribution.sampleStats = summaryStatistics;
        return empiricalDistribution.sampleStats;
    }

    static /* synthetic */ SummaryStatistics access$300(EmpiricalDistribution empiricalDistribution) {
        return empiricalDistribution.sampleStats;
    }
}

