/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.random;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RectangularCholeskyDecomposition;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.NormalizedRandomGenerator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.RandomVectorGenerator;

public class CorrelatedRandomVectorGenerator
implements RandomVectorGenerator {
    private final double[] mean;
    private final NormalizedRandomGenerator generator;
    private final double[] normalized;
    private final RealMatrix root;

    public CorrelatedRandomVectorGenerator(double[] object, RealMatrix realMatrix, double d2, NormalizedRandomGenerator normalizedRandomGenerator) {
        int n = realMatrix.getRowDimension();
        if (((double[])object).length != n) {
            throw new DimensionMismatchException(((double[])object).length, n);
        }
        this.mean = (double[])object.clone();
        object = new RectangularCholeskyDecomposition(realMatrix, d2);
        this.root = ((RectangularCholeskyDecomposition)object).getRootMatrix();
        this.generator = normalizedRandomGenerator;
        this.normalized = new double[((RectangularCholeskyDecomposition)object).getRank()];
    }

    public CorrelatedRandomVectorGenerator(RealMatrix realMatrix, double d2, NormalizedRandomGenerator normalizedRandomGenerator) {
        int n = realMatrix.getRowDimension();
        this.mean = new double[n];
        for (int i2 = 0; i2 < n; ++i2) {
            this.mean[i2] = 0.0;
        }
        RectangularCholeskyDecomposition rectangularCholeskyDecomposition = new RectangularCholeskyDecomposition(realMatrix, d2);
        this.root = rectangularCholeskyDecomposition.getRootMatrix();
        this.generator = normalizedRandomGenerator;
        this.normalized = new double[rectangularCholeskyDecomposition.getRank()];
    }

    public NormalizedRandomGenerator getGenerator() {
        return this.generator;
    }

    public int getRank() {
        return this.normalized.length;
    }

    public RealMatrix getRootMatrix() {
        return this.root;
    }

    public double[] nextVector() {
        for (int i2 = 0; i2 < this.normalized.length; ++i2) {
            this.normalized[i2] = this.generator.nextNormalizedDouble();
        }
        double[] dArray = new double[this.mean.length];
        for (int i3 = 0; i3 < dArray.length; ++i3) {
            dArray[i3] = this.mean[i3];
            for (int i4 = 0; i4 < this.root.getColumnDimension(); ++i4) {
                int n = i3;
                dArray[n] = dArray[n] + this.root.getEntry(i3, i4) * this.normalized[i4];
            }
        }
        return dArray;
    }
}

