/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.random;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotStrictlyPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.RandomGenerator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;

public abstract class AbstractRandomGenerator
implements RandomGenerator {
    private double cachedNormalDeviate = Double.NaN;

    public void clear() {
        this.cachedNormalDeviate = Double.NaN;
    }

    public void setSeed(int n) {
        this.setSeed((long)n);
    }

    public void setSeed(int[] nArray) {
        long l = 0L;
        for (int n : nArray) {
            l = l * 0xFFFFFFFBL + (long)n;
        }
        this.setSeed(l);
    }

    public abstract void setSeed(long var1);

    public void nextBytes(byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            int n2 = this.nextInt();
            for (int i2 = 0; i2 < 3; ++i2) {
                if (i2 > 0) {
                    n2 >>= 8;
                }
                byArray[n++] = (byte)n2;
                if (n != byArray.length) continue;
                return;
            }
        }
    }

    public int nextInt() {
        return (int)((2.0 * this.nextDouble() - 1.0) * 2.147483647E9);
    }

    public int nextInt(int n) {
        if (n <= 0) {
            throw new NotStrictlyPositiveException(n);
        }
        int n2 = (int)(this.nextDouble() * (double)n);
        if (n2 < n) {
            return n2;
        }
        return n - 1;
    }

    public long nextLong() {
        return (long)((2.0 * this.nextDouble() - 1.0) * 9.223372036854776E18);
    }

    public boolean nextBoolean() {
        return this.nextDouble() <= 0.5;
    }

    public float nextFloat() {
        return (float)this.nextDouble();
    }

    public abstract double nextDouble();

    public double nextGaussian() {
        if (!Double.isNaN(this.cachedNormalDeviate)) {
            double d2 = this.cachedNormalDeviate;
            this.cachedNormalDeviate = Double.NaN;
            return d2;
        }
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 1.0;
        while (d5 >= 1.0) {
            d3 = 2.0 * this.nextDouble() - 1.0;
            d4 = 2.0 * this.nextDouble() - 1.0;
            double d6 = d3;
            double d7 = d4;
            d5 = d6 * d6 + d7 * d7;
        }
        if (d5 != 0.0) {
            d5 = FastMath.sqrt(-2.0 * FastMath.log(d5) / d5);
        }
        this.cachedNormalDeviate = d4 * d5;
        return d3 * d5;
    }
}

