/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.primes;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.primes.SmallPrimes;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PollardRho {
    private PollardRho() {
    }

    public static List<Integer> primeFactors(int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (1 == (n = SmallPrimes.smallTrialDivision(n, arrayList))) {
            return arrayList;
        }
        if (SmallPrimes.millerRabinPrimeTest(n)) {
            arrayList.add(n);
            return arrayList;
        }
        int n2 = PollardRho.rhoBrent(n);
        arrayList.add(n2);
        arrayList.add(n / n2);
        return arrayList;
    }

    static int rhoBrent(int n) {
        int n2 = SmallPrimes.PRIMES_LAST;
        int n3 = 2;
        int n4 = 1;
        while (true) {
            int n5;
            int n6 = n3;
            for (n5 = 0; n5 < n4; ++n5) {
                long l = (long)n3 * (long)n3;
                n3 = (int)((l + (long)n2) % (long)n);
            }
            n5 = 0;
            do {
                int n7;
                int n8 = FastMath.min(25, n4 - n5);
                int n9 = 1;
                for (n7 = -3; n7 < n8; ++n7) {
                    long l = (long)n3 * (long)n3;
                    long l2 = FastMath.abs(n6 - (n3 = (int)((l + (long)n2) % (long)n)));
                    if (0L == l2) {
                        n2 += SmallPrimes.PRIMES_LAST;
                        n5 = -25;
                        n3 = 2;
                        n4 = 1;
                        break;
                    }
                    long l3 = l2 * (long)n9;
                    if ((n9 = (int)(l3 % (long)n)) != 0) continue;
                    return PollardRho.gcdPositive(FastMath.abs((int)l2), n);
                }
                if (1 == (n7 = PollardRho.gcdPositive(FastMath.abs(n9), n))) continue;
                return n7;
            } while ((n5 += 25) < n4);
            n4 = 2 * n4;
        }
    }

    static int gcdPositive(int n, int n2) {
        if (n == 0) {
            return n2;
        }
        if (n2 == 0) {
            return n;
        }
        int n3 = Integer.numberOfTrailingZeros(n);
        n >>= n3;
        int n4 = Integer.numberOfTrailingZeros(n2);
        n2 >>= n4;
        n3 = FastMath.min(n3, n4);
        while (n != n2) {
            n4 = n - n2;
            n2 = FastMath.min(n, n2);
            n = FastMath.abs(n4);
            n >>= Integer.numberOfTrailingZeros(n);
        }
        return n << n3;
    }
}

