/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.optimization.linear;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.AbstractRealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.Array2DRowRealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.MatrixUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealVector;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optimization.GoalType;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optimization.PointValuePair;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optimization.linear.LinearConstraint;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optimization.linear.LinearObjectiveFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optimization.linear.Relationship;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Precision;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
class SimplexTableau
implements Serializable {
    private static final String NEGATIVE_VAR_COLUMN_LABEL = "x-";
    private static final int DEFAULT_ULPS = 10;
    private static final double CUTOFF_THRESHOLD = 1.0E-12;
    private static final long serialVersionUID = -1369660067587938365L;
    private final LinearObjectiveFunction f;
    private final List<LinearConstraint> constraints;
    private final boolean restrictToNonNegative;
    private final List<String> columnLabels = new ArrayList<String>();
    private transient RealMatrix tableau;
    private final int numDecisionVariables;
    private final int numSlackVariables;
    private int numArtificialVariables;
    private final double epsilon;
    private final int maxUlps;

    SimplexTableau(LinearObjectiveFunction linearObjectiveFunction, Collection<LinearConstraint> collection, GoalType goalType, boolean bl, double d2) {
        this(linearObjectiveFunction, collection, goalType, bl, d2, 10);
    }

    SimplexTableau(LinearObjectiveFunction linearObjectiveFunction, Collection<LinearConstraint> collection, GoalType goalType, boolean bl, double d2, int n) {
        this.f = linearObjectiveFunction;
        this.constraints = this.normalizeConstraints(collection);
        this.restrictToNonNegative = bl;
        this.epsilon = d2;
        this.maxUlps = n;
        this.numDecisionVariables = linearObjectiveFunction.getCoefficients().getDimension() + (bl ? 0 : 1);
        this.numSlackVariables = this.getConstraintTypeCounts(Relationship.LEQ) + this.getConstraintTypeCounts(Relationship.GEQ);
        this.numArtificialVariables = this.getConstraintTypeCounts(Relationship.EQ) + this.getConstraintTypeCounts(Relationship.GEQ);
        this.tableau = this.createTableau(goalType == GoalType.MAXIMIZE);
        this.initializeColumnLabels();
    }

    protected void initializeColumnLabels() {
        int n;
        if (this.getNumObjectiveFunctions() == 2) {
            this.columnLabels.add("W");
        }
        this.columnLabels.add("Z");
        for (n = 0; n < this.getOriginalNumDecisionVariables(); ++n) {
            this.columnLabels.add("x" + n);
        }
        if (!this.restrictToNonNegative) {
            this.columnLabels.add(NEGATIVE_VAR_COLUMN_LABEL);
        }
        for (n = 0; n < this.getNumSlackVariables(); ++n) {
            this.columnLabels.add("s" + n);
        }
        for (n = 0; n < this.getNumArtificialVariables(); ++n) {
            this.columnLabels.add("a" + n);
        }
        this.columnLabels.add("RHS");
    }

    protected RealMatrix createTableau(boolean bl) {
        int n;
        int n2 = this.numDecisionVariables + this.numSlackVariables + this.numArtificialVariables + this.getNumObjectiveFunctions() + 1;
        int n3 = this.constraints.size() + this.getNumObjectiveFunctions();
        Array2DRowRealMatrix array2DRowRealMatrix = new Array2DRowRealMatrix(n3, n2);
        if (this.getNumObjectiveFunctions() == 2) {
            ((AbstractRealMatrix)array2DRowRealMatrix).setEntry(0, 0, -1.0);
        }
        int n4 = n = this.getNumObjectiveFunctions() == 1 ? 0 : 1;
        ((AbstractRealMatrix)array2DRowRealMatrix).setEntry(n4, n4, bl ? 1.0 : -1.0);
        RealVector realVector = bl ? this.f.getCoefficients().mapMultiply(-1.0) : this.f.getCoefficients();
        this.copyArray(realVector.toArray(), array2DRowRealMatrix.getDataRef()[n]);
        ((AbstractRealMatrix)array2DRowRealMatrix).setEntry(n, n2 - 1, bl ? this.f.getConstantTerm() : -1.0 * this.f.getConstantTerm());
        if (!this.restrictToNonNegative) {
            ((AbstractRealMatrix)array2DRowRealMatrix).setEntry(n, this.getSlackVariableOffset() - 1, SimplexTableau.getInvertedCoefficientSum(realVector));
        }
        bl = false;
        n = 0;
        for (int i2 = 0; i2 < this.constraints.size(); ++i2) {
            LinearConstraint linearConstraint = this.constraints.get(i2);
            int n5 = this.getNumObjectiveFunctions() + i2;
            this.copyArray(linearConstraint.getCoefficients().toArray(), array2DRowRealMatrix.getDataRef()[n5]);
            if (!this.restrictToNonNegative) {
                ((AbstractRealMatrix)array2DRowRealMatrix).setEntry(n5, this.getSlackVariableOffset() - 1, SimplexTableau.getInvertedCoefficientSum(linearConstraint.getCoefficients()));
            }
            ((AbstractRealMatrix)array2DRowRealMatrix).setEntry(n5, n2 - 1, linearConstraint.getValue());
            if (linearConstraint.getRelationship() == Relationship.LEQ) {
                ((AbstractRealMatrix)array2DRowRealMatrix).setEntry(n5, this.getSlackVariableOffset() + (int)(bl++ ? 1 : 0), 1.0);
            } else if (linearConstraint.getRelationship() == Relationship.GEQ) {
                ((AbstractRealMatrix)array2DRowRealMatrix).setEntry(n5, this.getSlackVariableOffset() + (int)(bl++ ? 1 : 0), -1.0);
            }
            if (linearConstraint.getRelationship() != Relationship.EQ && linearConstraint.getRelationship() != Relationship.GEQ) continue;
            ((AbstractRealMatrix)array2DRowRealMatrix).setEntry(0, this.getArtificialVariableOffset() + n, 1.0);
            ((AbstractRealMatrix)array2DRowRealMatrix).setEntry(n5, this.getArtificialVariableOffset() + n++, 1.0);
            array2DRowRealMatrix.setRowVector(0, array2DRowRealMatrix.getRowVector(0).subtract(array2DRowRealMatrix.getRowVector(n5)));
        }
        return array2DRowRealMatrix;
    }

    public List<LinearConstraint> normalizeConstraints(Collection<LinearConstraint> object) {
        ArrayList<LinearConstraint> arrayList = new ArrayList<LinearConstraint>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            LinearConstraint linearConstraint = (LinearConstraint)object.next();
            arrayList.add(this.normalize(linearConstraint));
        }
        return arrayList;
    }

    private LinearConstraint normalize(LinearConstraint linearConstraint) {
        if (linearConstraint.getValue() < 0.0) {
            return new LinearConstraint(linearConstraint.getCoefficients().mapMultiply(-1.0), linearConstraint.getRelationship().oppositeRelationship(), -1.0 * linearConstraint.getValue());
        }
        return new LinearConstraint(linearConstraint.getCoefficients(), linearConstraint.getRelationship(), linearConstraint.getValue());
    }

    protected final int getNumObjectiveFunctions() {
        if (this.numArtificialVariables > 0) {
            return 2;
        }
        return 1;
    }

    private int getConstraintTypeCounts(Relationship relationship) {
        int n = 0;
        for (LinearConstraint linearConstraint : this.constraints) {
            if (linearConstraint.getRelationship() != relationship) continue;
            ++n;
        }
        return n;
    }

    protected static double getInvertedCoefficientSum(RealVector object) {
        double d2 = 0.0;
        double[] dArray = ((RealVector)object).toArray();
        object = dArray;
        int n = dArray.length;
        for (int i2 = 0; i2 < n; ++i2) {
            Object object2 = object[i2];
            d2 -= object2;
        }
        return d2;
    }

    protected Integer getBasicRow(int n) {
        Integer n2 = null;
        for (int i2 = 0; i2 < this.getHeight(); ++i2) {
            double d2 = this.getEntry(i2, n);
            if (Precision.equals(d2, 1.0, this.maxUlps) && n2 == null) {
                n2 = i2;
                continue;
            }
            if (Precision.equals(d2, 0.0, this.maxUlps)) continue;
            return null;
        }
        return n2;
    }

    protected void dropPhase1Objective() {
        int n;
        int n2;
        if (this.getNumObjectiveFunctions() == 1) {
            return;
        }
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        treeSet.add(0);
        for (n2 = this.getNumObjectiveFunctions(); n2 < this.getArtificialVariableOffset(); ++n2) {
            double d2 = this.tableau.getEntry(0, n2);
            if (Precision.compareTo(d2, 0.0, this.epsilon) <= 0) continue;
            treeSet.add(n2);
        }
        for (n2 = 0; n2 < this.getNumArtificialVariables(); ++n2) {
            int n3 = n2 + this.getArtificialVariableOffset();
            if (this.getBasicRow(n3) != null) continue;
            treeSet.add(n3);
        }
        double[][] dArray = new double[this.getHeight() - 1][this.getWidth() - treeSet.size()];
        for (int i2 = 1; i2 < this.getHeight(); ++i2) {
            n = 0;
            for (int i3 = 0; i3 < this.getWidth(); ++i3) {
                if (treeSet.contains(i3)) continue;
                dArray[i2 - 1][n++] = this.tableau.getEntry(i2, i3);
            }
        }
        TreeSet<Integer> treeSet2 = treeSet;
        Integer[] integerArray = treeSet2.toArray(new Integer[treeSet2.size()]);
        for (n = integerArray.length - 1; n >= 0; --n) {
            this.columnLabels.remove(integerArray[n]);
        }
        this.tableau = new Array2DRowRealMatrix(dArray);
        this.numArtificialVariables = 0;
    }

    private void copyArray(double[] dArray, double[] dArray2) {
        System.arraycopy(dArray, 0, dArray2, this.getNumObjectiveFunctions(), dArray.length);
    }

    boolean isOptimal() {
        for (int i2 = this.getNumObjectiveFunctions(); i2 < this.getWidth() - 1; ++i2) {
            double d2 = this.tableau.getEntry(0, i2);
            if (Precision.compareTo(d2, 0.0, this.epsilon) >= 0) continue;
            return false;
        }
        return true;
    }

    protected PointValuePair getSolution() {
        int n = this.columnLabels.indexOf(NEGATIVE_VAR_COLUMN_LABEL);
        Serializable serializable = n > 0 ? this.getBasicRow(n) : null;
        double d2 = serializable == null ? 0.0 : this.getEntry((Integer)serializable, this.getRhsOffset());
        serializable = new HashSet();
        double[] dArray = new double[this.getOriginalNumDecisionVariables()];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            int n2 = this.columnLabels.indexOf("x" + i2);
            if (n2 < 0) {
                dArray[i2] = 0.0;
                continue;
            }
            Integer n3 = this.getBasicRow(n2);
            if (n3 != null && n3 == 0) {
                dArray[i2] = 0.0;
                continue;
            }
            if (serializable.contains(n3)) {
                dArray[i2] = 0.0 - (this.restrictToNonNegative ? 0.0 : d2);
                continue;
            }
            serializable.add(n3);
            dArray[i2] = (n3 == null ? 0.0 : this.getEntry(n3, this.getRhsOffset())) - (this.restrictToNonNegative ? 0.0 : d2);
        }
        return new PointValuePair(dArray, this.f.getValue(dArray));
    }

    protected void divideRow(int n, double d2) {
        for (int i2 = 0; i2 < this.getWidth(); ++i2) {
            this.tableau.setEntry(n, i2, this.tableau.getEntry(n, i2) / d2);
        }
    }

    protected void subtractRow(int n, int n2, double d2) {
        for (int i2 = 0; i2 < this.getWidth(); ++i2) {
            double d3;
            double d4 = this.tableau.getEntry(n, i2) - this.tableau.getEntry(n2, i2) * d2;
            if (FastMath.abs(d3) < 1.0E-12) {
                d4 = 0.0;
            }
            this.tableau.setEntry(n, i2, d4);
        }
    }

    protected final int getWidth() {
        return this.tableau.getColumnDimension();
    }

    protected final int getHeight() {
        return this.tableau.getRowDimension();
    }

    protected final double getEntry(int n, int n2) {
        return this.tableau.getEntry(n, n2);
    }

    protected final void setEntry(int n, int n2, double d2) {
        this.tableau.setEntry(n, n2, d2);
    }

    protected final int getSlackVariableOffset() {
        return this.getNumObjectiveFunctions() + this.numDecisionVariables;
    }

    protected final int getArtificialVariableOffset() {
        return this.getNumObjectiveFunctions() + this.numDecisionVariables + this.numSlackVariables;
    }

    protected final int getRhsOffset() {
        return this.getWidth() - 1;
    }

    protected final int getNumDecisionVariables() {
        return this.numDecisionVariables;
    }

    protected final int getOriginalNumDecisionVariables() {
        return this.f.getCoefficients().getDimension();
    }

    protected final int getNumSlackVariables() {
        return this.numSlackVariables;
    }

    protected final int getNumArtificialVariables() {
        return this.numArtificialVariables;
    }

    protected final double[][] getData() {
        return this.tableau.getData();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof SimplexTableau) {
            object = (SimplexTableau)object;
            return this.restrictToNonNegative == ((SimplexTableau)object).restrictToNonNegative && this.numDecisionVariables == ((SimplexTableau)object).numDecisionVariables && this.numSlackVariables == ((SimplexTableau)object).numSlackVariables && this.numArtificialVariables == ((SimplexTableau)object).numArtificialVariables && this.epsilon == ((SimplexTableau)object).epsilon && this.maxUlps == ((SimplexTableau)object).maxUlps && this.f.equals(((SimplexTableau)object).f) && this.constraints.equals(((SimplexTableau)object).constraints) && this.tableau.equals(((SimplexTableau)object).tableau);
        }
        return false;
    }

    public int hashCode() {
        return Boolean.valueOf(this.restrictToNonNegative).hashCode() ^ this.numDecisionVariables ^ this.numSlackVariables ^ this.numArtificialVariables ^ Double.valueOf(this.epsilon).hashCode() ^ this.maxUlps ^ this.f.hashCode() ^ this.constraints.hashCode() ^ this.tableau.hashCode();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        MatrixUtils.serializeRealMatrix(this.tableau, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        MatrixUtils.deserializeRealMatrix(this, "tableau", objectInputStream);
    }
}

