/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.optimization.general;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.ConvergenceException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optimization.ConvergenceChecker;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optimization.PointVectorValuePair;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optimization.general.AbstractLeastSquaresOptimizer;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Precision;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class LevenbergMarquardtOptimizer
extends AbstractLeastSquaresOptimizer {
    private int solvedCols;
    private double[] diagR;
    private double[] jacNorm;
    private double[] beta;
    private int[] permutation;
    private int rank;
    private double lmPar;
    private double[] lmDir;
    private final double initialStepBoundFactor;
    private final double costRelativeTolerance;
    private final double parRelativeTolerance;
    private final double orthoTolerance;
    private final double qrRankingThreshold;
    private double[] weightedResidual;
    private double[][] weightedJacobian;

    public LevenbergMarquardtOptimizer() {
        this(100.0, 1.0E-10, 1.0E-10, 1.0E-10, Precision.SAFE_MIN);
    }

    public LevenbergMarquardtOptimizer(ConvergenceChecker<PointVectorValuePair> convergenceChecker) {
        this(100.0, convergenceChecker, 1.0E-10, 1.0E-10, 1.0E-10, Precision.SAFE_MIN);
    }

    public LevenbergMarquardtOptimizer(double d2, ConvergenceChecker<PointVectorValuePair> convergenceChecker, double d3, double d4, double d5, double d6) {
        super(convergenceChecker);
        this.initialStepBoundFactor = d2;
        this.costRelativeTolerance = d3;
        this.parRelativeTolerance = d4;
        this.orthoTolerance = d5;
        this.qrRankingThreshold = d6;
    }

    public LevenbergMarquardtOptimizer(double d2, double d3, double d4) {
        this(100.0, d2, d3, d4, Precision.SAFE_MIN);
    }

    public LevenbergMarquardtOptimizer(double d2, double d3, double d4, double d5, double d6) {
        super(null);
        this.initialStepBoundFactor = d2;
        this.costRelativeTolerance = d3;
        this.parRelativeTolerance = d4;
        this.orthoTolerance = d5;
        this.qrRankingThreshold = d6;
    }

    @Override
    protected PointVectorValuePair doOptimize() {
        int n = this.getTarget().length;
        double[] dArray = this.getStartPoint();
        int n2 = dArray.length;
        this.solvedCols = FastMath.min(n, n2);
        this.diagR = new double[n2];
        this.jacNorm = new double[n2];
        this.beta = new double[n2];
        this.permutation = new int[n2];
        this.lmDir = new double[n2];
        double d2 = 0.0;
        double d3 = 0.0;
        double[] dArray2 = new double[n2];
        double[] dArray3 = new double[n2];
        double[] dArray4 = new double[n];
        double[] cfr_ignored_0 = new double[n];
        double[] dArray5 = new double[n];
        double[] dArray6 = new double[n2];
        double[] dArray7 = new double[n2];
        double[] dArray8 = new double[n2];
        RealMatrix realMatrix = this.getWeightSquareRoot();
        double[] dArray9 = this.computeObjectiveValue(dArray);
        double[] dArray10 = this.computeResiduals(dArray9);
        PointVectorValuePair pointVectorValuePair = new PointVectorValuePair(dArray, dArray9);
        double d4 = this.computeCost(dArray10);
        this.lmPar = 0.0;
        boolean bl = true;
        int n3 = 0;
        ConvergenceChecker<PointVectorValuePair> convergenceChecker = this.getConvergenceChecker();
        block0: while (true) {
            double d5;
            int n4;
            int n5;
            ++n3;
            PointVectorValuePair pointVectorValuePair2 = pointVectorValuePair;
            LevenbergMarquardtOptimizer levenbergMarquardtOptimizer = this;
            levenbergMarquardtOptimizer.qrDecomposition(levenbergMarquardtOptimizer.computeWeightedJacobian(dArray));
            this.weightedResidual = realMatrix.operate(dArray10);
            for (n5 = 0; n5 < n; ++n5) {
                dArray5[n5] = this.weightedResidual[n5];
            }
            this.qTy(dArray5);
            for (n5 = 0; n5 < this.solvedCols; ++n5) {
                int n6 = this.permutation[n5];
                this.weightedJacobian[n5][n6] = this.diagR[n6];
            }
            if (bl) {
                d3 = 0.0;
                for (n5 = 0; n5 < n2; ++n5) {
                    double d6;
                    double d7 = this.jacNorm[n5];
                    if (d7 == 0.0) {
                        d7 = 1.0;
                    }
                    double d8 = d6 = d7 * dArray[n5];
                    d3 += d8 * d8;
                    dArray2[n5] = d7;
                }
                d2 = (d3 = FastMath.sqrt(d3)) == 0.0 ? this.initialStepBoundFactor : this.initialStepBoundFactor * d3;
            }
            double d9 = 0.0;
            if (d4 != 0.0) {
                for (n4 = 0; n4 < this.solvedCols; ++n4) {
                    int n7 = this.permutation[n4];
                    d5 = this.jacNorm[n7];
                    if (d5 == 0.0) continue;
                    double d10 = 0.0;
                    for (int i2 = 0; i2 <= n4; ++i2) {
                        d10 += this.weightedJacobian[i2][n7] * dArray5[i2];
                    }
                    d9 = FastMath.max(d9, FastMath.abs(d10) / (d5 * d4));
                }
            }
            if (d9 <= this.orthoTolerance) {
                this.setCost(d4);
                this.point = pointVectorValuePair.getPoint();
                return pointVectorValuePair;
            }
            for (n4 = 0; n4 < n2; ++n4) {
                dArray2[n4] = FastMath.max(dArray2[n4], this.jacNorm[n4]);
            }
            double d11 = 0.0;
            do {
                int n8;
                double d12;
                double d13;
                if (!(d11 < 1.0E-4)) continue block0;
                for (int i3 = 0; i3 < this.solvedCols; ++i3) {
                    int n9 = this.permutation[i3];
                    dArray3[n9] = dArray[n9];
                }
                d5 = d4;
                double[] dArray11 = this.weightedResidual;
                this.weightedResidual = dArray4;
                dArray4 = dArray11;
                dArray11 = dArray9;
                double[] dArray12 = dArray9;
                this.determineLMParameter(dArray5, d2, dArray2, dArray6, dArray7, dArray8);
                double d14 = 0.0;
                for (int i4 = 0; i4 < this.solvedCols; ++i4) {
                    int n10 = this.permutation[i4];
                    this.lmDir[n10] = -this.lmDir[n10];
                    dArray[n10] = dArray3[n10] + this.lmDir[n10];
                    double d15 = d13 = dArray2[n10] * this.lmDir[n10];
                    d14 += d15 * d15;
                }
                d14 = FastMath.sqrt(d14);
                if (bl) {
                    d2 = FastMath.min(d2, d14);
                }
                dArray9 = this.computeObjectiveValue(dArray);
                dArray10 = this.computeResiduals(dArray9);
                pointVectorValuePair = new PointVectorValuePair(dArray, dArray9);
                d4 = this.computeCost(dArray10);
                double d16 = -1.0;
                if (d4 * 0.1 < d5) {
                    double d17 = d13 = d4 / d5;
                    d16 = 1.0 - d17 * d17;
                }
                for (int i5 = 0; i5 < this.solvedCols; ++i5) {
                    int n11 = this.permutation[i5];
                    d12 = this.lmDir[n11];
                    dArray6[i5] = 0.0;
                    for (int i6 = 0; i6 <= i5; ++i6) {
                        int n12 = i6;
                        dArray6[n12] = dArray6[n12] + this.weightedJacobian[i6][n11] * d12;
                    }
                }
                d13 = 0.0;
                for (int i7 = 0; i7 < this.solvedCols; ++i7) {
                    d13 += dArray6[i7] * dArray6[i7];
                }
                double d18 = d5;
                d12 = d18 * d18;
                double d19 = this.lmPar * d14 * d14 / d12;
                double d20 = (d13 /= d12) + d19 * 2.0;
                double d21 = -(d13 + d19);
                double d22 = d11 = d20 == 0.0 ? 0.0 : d16 / d20;
                if (d22 <= 0.25) {
                    double d23;
                    double d24 = d23 = d16 < 0.0 ? d21 * 0.5 / (d21 + d16 * 0.5) : 0.5;
                    if (d4 * 0.1 >= d5 || d23 < 0.1) {
                        d23 = 0.1;
                    }
                    d2 = d23 * FastMath.min(d2, d14 * 10.0);
                    this.lmPar /= d23;
                } else if (this.lmPar == 0.0 || d11 >= 0.75) {
                    d2 = d14 * 2.0;
                    this.lmPar *= 0.5;
                }
                if (d11 >= 1.0E-4) {
                    bl = false;
                    d3 = 0.0;
                    for (n8 = 0; n8 < n2; ++n8) {
                        double d25;
                        double d26 = d25 = dArray2[n8] * dArray[n8];
                        d3 += d26 * d26;
                    }
                    d3 = FastMath.sqrt(d3);
                    if (convergenceChecker != null && convergenceChecker.converged(n3, pointVectorValuePair2, pointVectorValuePair)) {
                        this.setCost(d4);
                        this.point = pointVectorValuePair.getPoint();
                        return pointVectorValuePair;
                    }
                } else {
                    d4 = d5;
                    for (n8 = 0; n8 < this.solvedCols; ++n8) {
                        int n13 = this.permutation[n8];
                        dArray[n13] = dArray3[n13];
                    }
                    dArray11 = this.weightedResidual;
                    this.weightedResidual = dArray4;
                    dArray4 = dArray11;
                    dArray9 = dArray12;
                    pointVectorValuePair = new PointVectorValuePair(dArray, dArray9);
                }
                if (FastMath.abs(d16) <= this.costRelativeTolerance && d20 <= this.costRelativeTolerance && d11 <= 2.0 || d2 <= this.parRelativeTolerance * d3) {
                    this.setCost(d4);
                    this.point = pointVectorValuePair.getPoint();
                    return pointVectorValuePair;
                }
                if (FastMath.abs(d16) <= 2.2204E-16 && d20 <= 2.2204E-16 && d11 <= 2.0) {
                    throw new ConvergenceException(LocalizedFormats.TOO_SMALL_COST_RELATIVE_TOLERANCE, this.costRelativeTolerance);
                }
                if (!(d2 <= d3 * 2.2204E-16)) continue;
                throw new ConvergenceException(LocalizedFormats.TOO_SMALL_PARAMETERS_RELATIVE_TOLERANCE, this.parRelativeTolerance);
            } while (!(d9 <= 2.2204E-16));
            break;
        }
        throw new ConvergenceException(LocalizedFormats.TOO_SMALL_ORTHOGONALITY_TOLERANCE, this.orthoTolerance);
    }

    private void determineLMParameter(double[] dArray, double d2, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5) {
        double d3;
        int n;
        int n2;
        double d4;
        int n3;
        int n4 = this.weightedJacobian[0].length;
        for (n3 = 0; n3 < this.rank; ++n3) {
            this.lmDir[this.permutation[n3]] = dArray[n3];
        }
        for (n3 = this.rank; n3 < n4; ++n3) {
            this.lmDir[this.permutation[n3]] = 0.0;
        }
        for (n3 = this.rank - 1; n3 >= 0; --n3) {
            int n5 = this.permutation[n3];
            double d5 = this.lmDir[n5] / this.diagR[n5];
            for (int i2 = 0; i2 < n3; ++i2) {
                int n6 = this.permutation[i2];
                this.lmDir[n6] = this.lmDir[n6] - d5 * this.weightedJacobian[i2][n5];
            }
            this.lmDir[n5] = d5;
        }
        double d6 = 0.0;
        for (int i3 = 0; i3 < this.solvedCols; ++i3) {
            double d7;
            int n7 = this.permutation[i3];
            dArray3[n7] = d7 = dArray2[n7] * this.lmDir[n7];
            double d8 = d7;
            d6 += d8 * d8;
        }
        d6 = FastMath.sqrt(d6);
        double d9 = d6 - d2;
        if (d4 <= d2 * 0.1) {
            this.lmPar = 0.0;
            return;
        }
        double d10 = 0.0;
        if (this.rank == this.solvedCols) {
            for (n2 = 0; n2 < this.solvedCols; ++n2) {
                int n8 = n = this.permutation[n2];
                dArray3[n8] = dArray3[n8] * (dArray2[n] / d6);
            }
            double d11 = 0.0;
            for (n2 = 0; n2 < this.solvedCols; ++n2) {
                double d12;
                n = this.permutation[n2];
                d3 = 0.0;
                for (int i4 = 0; i4 < n2; ++i4) {
                    d3 += this.weightedJacobian[i4][n] * dArray3[this.permutation[i4]];
                }
                dArray3[n] = d12 = (dArray3[n] - d3) / this.diagR[n];
                double d13 = d12;
                d11 += d13 * d13;
            }
            d10 = d9 / (d2 * d11);
        }
        double d14 = 0.0;
        for (n2 = 0; n2 < this.solvedCols; ++n2) {
            n = this.permutation[n2];
            d3 = 0.0;
            for (int i5 = 0; i5 <= n2; ++i5) {
                d3 += this.weightedJacobian[i5][n] * dArray[i5];
            }
            double d15 = d3 /= dArray2[n];
            d14 += d15 * d15;
        }
        double d16 = FastMath.sqrt(d14);
        d3 = d16 / d2;
        if (d3 == 0.0) {
            d3 = 2.2251E-308 / FastMath.min(d2, 0.1);
        }
        this.lmPar = FastMath.min(d3, FastMath.max(this.lmPar, d10));
        if (this.lmPar == 0.0) {
            this.lmPar = d16 / d6;
        }
        for (int i6 = 10; i6 >= 0; --i6) {
            int n9;
            int n10;
            double d17;
            int n11;
            int n12;
            if (this.lmPar == 0.0) {
                this.lmPar = FastMath.max(2.2251E-308, d3 * 0.001);
            }
            double d18 = FastMath.sqrt(this.lmPar);
            for (n12 = 0; n12 < this.solvedCols; ++n12) {
                n11 = this.permutation[n12];
                dArray3[n11] = d18 * dArray2[n11];
            }
            this.determineLMDirection(dArray, dArray3, dArray4, dArray5);
            d6 = 0.0;
            for (n12 = 0; n12 < this.solvedCols; ++n12) {
                n11 = this.permutation[n12];
                dArray5[n11] = d17 = dArray2[n11] * this.lmDir[n11];
                double d19 = d17;
                d6 += d19 * d19;
            }
            d6 = FastMath.sqrt(d6);
            double d20 = d9;
            d9 = d6 - d2;
            if (FastMath.abs(d9) <= d2 * 0.1 || d10 == 0.0 && d9 <= d20 && d20 < 0.0) {
                return;
            }
            for (n10 = 0; n10 < this.solvedCols; ++n10) {
                n9 = this.permutation[n10];
                dArray3[n9] = dArray5[n9] * dArray2[n9] / d6;
            }
            for (n10 = 0; n10 < this.solvedCols; ++n10) {
                int n13 = n9 = this.permutation[n10];
                dArray3[n13] = dArray3[n13] / dArray4[n10];
                double d21 = dArray3[n9];
                for (n4 = n10 + 1; n4 < this.solvedCols; ++n4) {
                    int n14 = this.permutation[n4];
                    dArray3[n14] = dArray3[n14] - this.weightedJacobian[n4][n9] * d21;
                }
            }
            d14 = 0.0;
            for (n10 = 0; n10 < this.solvedCols; ++n10) {
                double d22;
                double d23 = d22 = dArray3[this.permutation[n10]];
                d14 += d23 * d23;
            }
            d17 = d9 / (d2 * d14);
            if (d9 > 0.0) {
                d10 = FastMath.max(d10, this.lmPar);
            } else if (d9 < 0.0) {
                d3 = FastMath.min(d3, this.lmPar);
            }
            this.lmPar = FastMath.max(d10, this.lmPar + d17);
        }
    }

    private void determineLMDirection(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        int n;
        int n2;
        for (n2 = 0; n2 < this.solvedCols; ++n2) {
            n = this.permutation[n2];
            for (int i2 = n2 + 1; i2 < this.solvedCols; ++i2) {
                this.weightedJacobian[i2][n] = this.weightedJacobian[n2][this.permutation[i2]];
            }
            this.lmDir[n2] = this.diagR[n];
            dArray4[n2] = dArray[n2];
        }
        for (n2 = 0; n2 < this.solvedCols; ++n2) {
            n = this.permutation[n2];
            double d2 = dArray2[n];
            if (d2 != 0.0) {
                Arrays.fill(dArray3, n2 + 1, dArray3.length, 0.0);
            }
            dArray3[n2] = d2;
            double d3 = 0.0;
            for (int i3 = n2; i3 < this.solvedCols; ++i3) {
                double d4;
                double d5;
                double d6;
                double d7;
                n = this.permutation[i3];
                if (dArray3[i3] == 0.0) continue;
                double d8 = this.weightedJacobian[i3][n];
                if (FastMath.abs(d7) < FastMath.abs(dArray3[i3])) {
                    double d9 = d6 = d8 / dArray3[i3];
                    d5 = 1.0 / FastMath.sqrt(1.0 + d9 * d9);
                    d4 = d5 * d6;
                } else {
                    double d10 = d6 = dArray3[i3] / d8;
                    d4 = 1.0 / FastMath.sqrt(1.0 + d10 * d10);
                    d5 = d4 * d6;
                }
                this.weightedJacobian[i3][n] = d4 * d8 + d5 * dArray3[i3];
                d6 = d4 * dArray4[i3] + d5 * d3;
                d3 = -d5 * dArray4[i3] + d4 * d3;
                dArray4[i3] = d6;
                for (int i4 = i3 + 1; i4 < this.solvedCols; ++i4) {
                    double d11 = this.weightedJacobian[i4][n];
                    double d12 = d4 * d11 + d5 * dArray3[i4];
                    dArray3[i4] = -d5 * d11 + d4 * dArray3[i4];
                    this.weightedJacobian[i4][n] = d12;
                }
            }
            dArray3[n2] = this.weightedJacobian[n2][this.permutation[n2]];
            this.weightedJacobian[n2][this.permutation[n2]] = this.lmDir[n2];
        }
        n2 = this.solvedCols;
        for (n = 0; n < this.solvedCols; ++n) {
            if (dArray3[n] == 0.0 && n2 == this.solvedCols) {
                n2 = n;
            }
            if (n2 >= this.solvedCols) continue;
            dArray4[n] = 0.0;
        }
        if (n2 > 0) {
            for (n = n2 - 1; n >= 0; --n) {
                int n3 = this.permutation[n];
                double d13 = 0.0;
                for (int i5 = n + 1; i5 < n2; ++i5) {
                    d13 += this.weightedJacobian[i5][n3] * dArray4[i5];
                }
                dArray4[n] = (dArray4[n] - d13) / dArray3[n];
            }
        }
        for (n = 0; n < this.lmDir.length; ++n) {
            this.lmDir[this.permutation[n]] = dArray4[n];
        }
    }

    private void qrDecomposition(RealMatrix realMatrix) {
        int n;
        this.weightedJacobian = realMatrix.scalarMultiply(-1.0).getData();
        int n2 = this.weightedJacobian.length;
        int n3 = this.weightedJacobian[0].length;
        for (n = 0; n < n3; ++n) {
            int n4 = n;
            this.permutation[n4] = n4;
            double d2 = 0.0;
            for (int i2 = 0; i2 < n2; ++i2) {
                double d3;
                double d4 = d3 = this.weightedJacobian[i2][n];
                d2 += d4 * d4;
            }
            this.jacNorm[n] = FastMath.sqrt(d2);
        }
        for (n = 0; n < n3; ++n) {
            double d5;
            double d6;
            double d7;
            int n5;
            int n6 = -1;
            double d8 = Double.NEGATIVE_INFINITY;
            for (n5 = n; n5 < n3; ++n5) {
                d7 = 0.0;
                for (int i3 = n; i3 < n2; ++i3) {
                    double d9;
                    double d10 = d9 = this.weightedJacobian[i3][this.permutation[n5]];
                    d7 += d10 * d10;
                }
                if (Double.isInfinite(d7) || Double.isNaN(d7)) {
                    throw new ConvergenceException(LocalizedFormats.UNABLE_TO_PERFORM_QR_DECOMPOSITION_ON_JACOBIAN, n2, n3);
                }
                if (!(d7 > d8)) continue;
                n6 = n5;
                d8 = d7;
            }
            if (d8 <= this.qrRankingThreshold) {
                this.rank = n;
                return;
            }
            n5 = this.permutation[n6];
            this.permutation[n6] = this.permutation[n];
            this.permutation[n] = n5;
            d7 = this.weightedJacobian[n][n5];
            double d11 = d6 > 0.0 ? -FastMath.sqrt(d8) : FastMath.sqrt(d8);
            this.beta[n5] = d5 = 1.0 / (d8 - d7 * d11);
            this.diagR[n5] = d11;
            double[] dArray = this.weightedJacobian[n];
            int n7 = n5;
            dArray[n7] = dArray[n7] - d11;
            for (int i4 = n3 - 1 - n; i4 > 0; --i4) {
                double d12 = 0.0;
                for (n6 = n; n6 < n2; ++n6) {
                    d12 += this.weightedJacobian[n6][n5] * this.weightedJacobian[n6][this.permutation[n + i4]];
                }
                d12 *= d5;
                for (n6 = n; n6 < n2; ++n6) {
                    double[] dArray2 = this.weightedJacobian[n6];
                    int n8 = this.permutation[n + i4];
                    dArray2[n8] = dArray2[n8] - d12 * this.weightedJacobian[n6][n5];
                }
            }
        }
        this.rank = this.solvedCols;
    }

    private void qTy(double[] dArray) {
        int n = this.weightedJacobian.length;
        int n2 = this.weightedJacobian[0].length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3;
            int n4 = this.permutation[i2];
            double d2 = 0.0;
            for (n3 = i2; n3 < n; ++n3) {
                d2 += this.weightedJacobian[n3][n4] * dArray[n3];
            }
            d2 *= this.beta[n4];
            for (n3 = i2; n3 < n; ++n3) {
                int n5 = n3;
                dArray[n5] = dArray[n5] - d2 * this.weightedJacobian[n3][n4];
            }
        }
    }
}

