/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.optimization.direct;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.MultivariateFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotStrictlyPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooSmallException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optimization.ConvergenceChecker;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optimization.GoalType;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optimization.MultivariateOptimizer;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optimization.PointValuePair;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optimization.direct.BaseAbstractMultivariateOptimizer;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optimization.direct.PowellOptimizer$LineSearch;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optimization.univariate.UnivariatePointValuePair;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class PowellOptimizer
extends BaseAbstractMultivariateOptimizer<MultivariateFunction>
implements MultivariateOptimizer {
    private static final double MIN_RELATIVE_TOLERANCE = 2.0 * FastMath.ulp(1.0);
    private final double relativeThreshold;
    private final double absoluteThreshold;
    private final PowellOptimizer$LineSearch line;

    public PowellOptimizer(double d2, double d3, ConvergenceChecker<PointValuePair> convergenceChecker) {
        this(d2, d3, FastMath.sqrt(d2), FastMath.sqrt(d3), convergenceChecker);
    }

    public PowellOptimizer(double d2, double d3, double d4, double d5, ConvergenceChecker<PointValuePair> convergenceChecker) {
        super(convergenceChecker);
        if (d2 < MIN_RELATIVE_TOLERANCE) {
            throw new NumberIsTooSmallException(d2, (Number)MIN_RELATIVE_TOLERANCE, true);
        }
        if (d3 <= 0.0) {
            throw new NotStrictlyPositiveException(d3);
        }
        this.relativeThreshold = d2;
        this.absoluteThreshold = d3;
        this.line = new PowellOptimizer$LineSearch(this, d4, d5);
    }

    public PowellOptimizer(double d2, double d3) {
        this(d2, d3, null);
    }

    public PowellOptimizer(double d2, double d3, double d4, double d5) {
        this(d2, d3, d4, d5, null);
    }

    @Override
    protected PointValuePair doOptimize() {
        GoalType goalType = this.getGoalType();
        double[] dArray = this.getStartPoint();
        int n = dArray.length;
        double[][] dArray2 = new double[n][n];
        for (int i2 = 0; i2 < n; ++i2) {
            dArray2[i2][i2] = 1.0;
        }
        ConvergenceChecker<PointValuePair> convergenceChecker = this.getConvergenceChecker();
        double d2 = this.computeObjectiveValue(dArray);
        double[] dArray3 = (double[])dArray.clone();
        int n2 = 0;
        while (true) {
            double d3;
            double d4;
            double d5;
            Object object;
            int n3;
            ++n2;
            double d6 = d2;
            double d7 = 0.0;
            int n4 = 0;
            for (n3 = 0; n3 < n; ++n3) {
                object = MathArrays.copyOf(dArray2[n3]);
                d5 = d2;
                UnivariatePointValuePair univariatePointValuePair = this.line.search(dArray, (double[])object);
                d2 = univariatePointValuePair.getValue();
                double d8 = univariatePointValuePair.getPoint();
                double[][] dArray4 = this.newPointAndDirection(dArray, (double[])object, d8);
                object = dArray4;
                dArray = dArray4[0];
                if (!(d5 - d2 > d7)) continue;
                d7 = d5 - d2;
                n4 = n3;
            }
            n3 = 2.0 * (d6 - d2) <= this.relativeThreshold * (FastMath.abs(d6) + FastMath.abs(d2)) + this.absoluteThreshold ? 1 : 0;
            object = new PointValuePair(dArray3, d6);
            PointValuePair pointValuePair = new PointValuePair(dArray, d2);
            if (n3 == 0 && convergenceChecker != null) {
                n3 = convergenceChecker.converged(n2, (PointValuePair)object, pointValuePair) ? 1 : 0;
            }
            if (n3 != 0) {
                if (goalType == GoalType.MINIMIZE) {
                    if (d2 < d6) {
                        return pointValuePair;
                    }
                    return object;
                }
                if (d2 > d6) {
                    return pointValuePair;
                }
                return object;
            }
            object = new double[n];
            double[] dArray5 = new double[n];
            for (int i3 = 0; i3 < n; ++i3) {
                object[i3] = dArray[i3] - dArray3[i3];
                dArray5[i3] = 2.0 * dArray[i3] - dArray3[i3];
            }
            dArray3 = (double[])dArray.clone();
            d5 = this.computeObjectiveValue(dArray5);
            if (!(d6 > d5)) continue;
            double d9 = 2.0 * (d6 + d5 - d2 * 2.0);
            double d10 = d4 = d6 - d2 - d7;
            d9 *= d10 * d10;
            d4 = d6 - d5;
            d9 -= d7 * d4 * d4;
            if (!(d3 < 0.0)) continue;
            Object object2 = this.line.search(dArray, (double[])object);
            d2 = ((UnivariatePointValuePair)object2).getValue();
            double d11 = ((UnivariatePointValuePair)object2).getPoint();
            double[][] dArray6 = this.newPointAndDirection(dArray, (double[])object, d11);
            object2 = dArray6;
            dArray = dArray6[0];
            int n5 = n - 1;
            dArray2[n4] = dArray2[n5];
            dArray2[n5] = (double[])object2[1];
        }
    }

    private double[][] newPointAndDirection(double[] dArray, double[] dArray2, double d2) {
        int n = dArray.length;
        double[] dArray3 = new double[n];
        double[] dArray4 = new double[n];
        for (int i2 = 0; i2 < n; ++i2) {
            dArray4[i2] = dArray2[i2] * d2;
            dArray3[i2] = dArray[i2] + dArray4[i2];
        }
        double[][] dArrayArray = new double[2][];
        double[][] dArrayArray2 = dArrayArray;
        dArrayArray[0] = dArray3;
        dArrayArray2[1] = dArray4;
        return dArrayArray2;
    }
}

