/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.optimization.direct;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.MultivariateFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.OutOfRangeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.TooManyEvaluationsException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.Array2DRowRealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.EigenDecomposition;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.MatrixUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optimization.ConvergenceChecker;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optimization.GoalType;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optimization.MultivariateOptimizer;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optimization.OptimizationData;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optimization.PointValuePair;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optimization.SimpleValueChecker;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optimization.direct.BaseAbstractMultivariateSimpleBoundsOptimizer;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optimization.direct.CMAESOptimizer$DoubleIndex;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optimization.direct.CMAESOptimizer$FitnessFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optimization.direct.CMAESOptimizer$PopulationSize;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optimization.direct.CMAESOptimizer$Sigma;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.MersenneTwister;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.RandomGenerator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class CMAESOptimizer
extends BaseAbstractMultivariateSimpleBoundsOptimizer<MultivariateFunction>
implements MultivariateOptimizer {
    public static final int DEFAULT_CHECKFEASABLECOUNT = 0;
    public static final double DEFAULT_STOPFITNESS = 0.0;
    public static final boolean DEFAULT_ISACTIVECMA = true;
    public static final int DEFAULT_MAXITERATIONS = 30000;
    public static final int DEFAULT_DIAGONALONLY = 0;
    public static final RandomGenerator DEFAULT_RANDOMGENERATOR = new MersenneTwister();
    private int lambda;
    private boolean isActiveCMA;
    private int checkFeasableCount;
    private double[] inputSigma;
    private int dimension;
    private int diagonalOnly = 0;
    private boolean isMinimize = true;
    private boolean generateStatistics = false;
    private int maxIterations;
    private double stopFitness;
    private double stopTolUpX;
    private double stopTolX;
    private double stopTolFun;
    private double stopTolHistFun;
    private int mu;
    private double logMu2;
    private RealMatrix weights;
    private double mueff;
    private double sigma;
    private double cc;
    private double cs;
    private double damps;
    private double ccov1;
    private double ccovmu;
    private double chiN;
    private double ccov1Sep;
    private double ccovmuSep;
    private RealMatrix xmean;
    private RealMatrix pc;
    private RealMatrix ps;
    private double normps;
    private RealMatrix B;
    private RealMatrix D;
    private RealMatrix BD;
    private RealMatrix diagD;
    private RealMatrix C;
    private RealMatrix diagC;
    private int iterations;
    private double[] fitnessHistory;
    private int historySize;
    private RandomGenerator random;
    private List<Double> statisticsSigmaHistory = new ArrayList<Double>();
    private List<RealMatrix> statisticsMeanHistory = new ArrayList<RealMatrix>();
    private List<Double> statisticsFitnessHistory = new ArrayList<Double>();
    private List<RealMatrix> statisticsDHistory = new ArrayList<RealMatrix>();

    @Deprecated
    public CMAESOptimizer() {
        this(0);
    }

    @Deprecated
    public CMAESOptimizer(int n) {
        this(n, null, 30000, 0.0, true, 0, 0, DEFAULT_RANDOMGENERATOR, false, null);
    }

    @Deprecated
    public CMAESOptimizer(int n, double[] dArray) {
        this(n, dArray, 30000, 0.0, true, 0, 0, DEFAULT_RANDOMGENERATOR, false);
    }

    @Deprecated
    public CMAESOptimizer(int n, double[] dArray, int n2, double d2, boolean bl, int n3, int n4, RandomGenerator randomGenerator, boolean bl2) {
        this(n, dArray, n2, d2, bl, n3, n4, randomGenerator, bl2, new SimpleValueChecker());
    }

    @Deprecated
    public CMAESOptimizer(int n, double[] dArray, int n2, double d2, boolean bl, int n3, int n4, RandomGenerator randomGenerator, boolean bl2, ConvergenceChecker<PointValuePair> convergenceChecker) {
        super(convergenceChecker);
        this.lambda = n;
        this.inputSigma = dArray == null ? null : (double[])dArray.clone();
        this.maxIterations = n2;
        this.stopFitness = d2;
        this.isActiveCMA = bl;
        this.diagonalOnly = n3;
        this.checkFeasableCount = n4;
        this.random = randomGenerator;
        this.generateStatistics = bl2;
    }

    public CMAESOptimizer(int n, double d2, boolean bl, int n2, int n3, RandomGenerator randomGenerator, boolean bl2, ConvergenceChecker<PointValuePair> convergenceChecker) {
        super(convergenceChecker);
        this.maxIterations = n;
        this.stopFitness = d2;
        this.isActiveCMA = bl;
        this.diagonalOnly = n2;
        this.checkFeasableCount = n3;
        this.random = randomGenerator;
        this.generateStatistics = bl2;
    }

    public List<Double> getStatisticsSigmaHistory() {
        return this.statisticsSigmaHistory;
    }

    public List<RealMatrix> getStatisticsMeanHistory() {
        return this.statisticsMeanHistory;
    }

    public List<Double> getStatisticsFitnessHistory() {
        return this.statisticsFitnessHistory;
    }

    public List<RealMatrix> getStatisticsDHistory() {
        return this.statisticsDHistory;
    }

    @Override
    protected PointValuePair optimizeInternal(int n, MultivariateFunction multivariateFunction, GoalType goalType, OptimizationData ... optimizationDataArray) {
        this.parseOptimizationData(optimizationDataArray);
        return super.optimizeInternal(n, multivariateFunction, goalType, optimizationDataArray);
    }

    @Override
    protected PointValuePair doOptimize() {
        this.checkParameters();
        this.isMinimize = this.getGoalType().equals(GoalType.MINIMIZE);
        CMAESOptimizer$FitnessFunction cMAESOptimizer$FitnessFunction = new CMAESOptimizer$FitnessFunction(this);
        Object object = this.getStartPoint();
        this.dimension = ((double[])object).length;
        this.initializeCMA((double[])object);
        this.iterations = 0;
        double d2 = cMAESOptimizer$FitnessFunction.value((double[])object);
        CMAESOptimizer.push(this.fitnessHistory, d2);
        object = new PointValuePair(this.getStartPoint(), this.isMinimize ? d2 : -d2);
        Object object2 = null;
        this.iterations = 1;
        block2: while (this.iterations <= this.maxIterations) {
            int n;
            RealMatrix realMatrix;
            CMAESOptimizer cMAESOptimizer = this;
            Object object3 = cMAESOptimizer.randn1(cMAESOptimizer.dimension, this.lambda);
            Object object4 = CMAESOptimizer.zeros(this.dimension, this.lambda);
            double[] dArray = new double[this.lambda];
            for (int i2 = 0; i2 < this.lambda; ++i2) {
                realMatrix = null;
                for (int i3 = 0; i3 < this.checkFeasableCount + 1; ++i3) {
                    realMatrix = this.diagonalOnly <= 0 ? this.xmean.add(this.BD.multiply(object3.getColumnMatrix(i2)).scalarMultiply(this.sigma)) : this.xmean.add(CMAESOptimizer.times(this.diagD, object3.getColumnMatrix(i2)).scalarMultiply(this.sigma));
                    if (i3 >= this.checkFeasableCount || cMAESOptimizer$FitnessFunction.isFeasible(realMatrix.getColumn(0))) break;
                    CMAESOptimizer cMAESOptimizer2 = this;
                    object3.setColumn(i2, cMAESOptimizer2.randn(cMAESOptimizer2.dimension));
                }
                CMAESOptimizer.copyColumn(realMatrix, 0, (RealMatrix)object4, i2);
                try {
                    dArray[i2] = cMAESOptimizer$FitnessFunction.value(object4.getColumn(i2));
                    continue;
                }
                catch (TooManyEvaluationsException tooManyEvaluationsException) {
                    break block2;
                }
            }
            int[] nArray = this.sortedIndices(dArray);
            realMatrix = this.xmean;
            RealMatrix realMatrix2 = CMAESOptimizer.selectColumns((RealMatrix)object4, MathArrays.copyOf(nArray, this.mu));
            this.xmean = realMatrix2.multiply(this.weights);
            object4 = CMAESOptimizer.selectColumns((RealMatrix)object3, MathArrays.copyOf(nArray, this.mu));
            RealMatrix realMatrix3 = object4.multiply(this.weights);
            boolean bl = this.updateEvolutionPaths(realMatrix3, realMatrix);
            if (this.diagonalOnly <= 0) {
                this.updateCovariance(bl, realMatrix2, (RealMatrix)object3, nArray, realMatrix);
            } else {
                this.updateCovarianceDiagonalOnly(bl, (RealMatrix)object4);
            }
            this.sigma *= FastMath.exp(FastMath.min(1.0, (this.normps / this.chiN - 1.0) * this.cs / this.damps));
            double d3 = dArray[nArray[0]];
            double d4 = dArray[nArray[nArray.length - 1]];
            if (d2 > d3) {
                d2 = d3;
                object2 = object;
                object = new PointValuePair(CMAESOptimizer$FitnessFunction.access$000(cMAESOptimizer$FitnessFunction, realMatrix2.getColumn(0)), this.isMinimize ? d3 : -d3);
                if (this.getConvergenceChecker() != null && this.getConvergenceChecker().converged(this.iterations, (PointValuePair)object, (PointValuePair)object2)) break;
            }
            if (this.stopFitness != 0.0 && d3 < (this.isMinimize ? this.stopFitness : -this.stopFitness)) break;
            object3 = CMAESOptimizer.sqrt(this.diagC).getColumn(0);
            object4 = this.pc.getColumn(0);
            for (n = 0; n < this.dimension && !(this.sigma * FastMath.max(FastMath.abs((double)object4[n]), (double)object3[n]) > this.stopTolX); ++n) {
                if (n >= this.dimension - 1) break block2;
            }
            for (n = 0; n < this.dimension; ++n) {
                if (this.sigma * object3[n] > this.stopTolUpX) break block2;
            }
            double d5 = CMAESOptimizer.min(this.fitnessHistory);
            double d6 = CMAESOptimizer.max(this.fitnessHistory);
            if (this.iterations > 2 && FastMath.max(d6, d4) - FastMath.min(d5, d3) < this.stopTolFun || this.iterations > this.fitnessHistory.length && d6 - d5 < this.stopTolHistFun || CMAESOptimizer.max(this.diagD) / CMAESOptimizer.min(this.diagD) > 1.0E7) break;
            if (this.getConvergenceChecker() != null) {
                object3 = new PointValuePair(realMatrix2.getColumn(0), this.isMinimize ? d3 : -d3);
                if (object2 != null && this.getConvergenceChecker().converged(this.iterations, (PointValuePair)object3, (PointValuePair)object2)) break;
                object2 = object3;
            }
            if (d2 == dArray[nArray[(int)(0.1 + (double)this.lambda / 4.0)]]) {
                this.sigma *= FastMath.exp(0.2 + this.cs / this.damps);
            }
            if (this.iterations > 2 && FastMath.max(d6, d3) - FastMath.min(d5, d3) == 0.0) {
                this.sigma *= FastMath.exp(0.2 + this.cs / this.damps);
            }
            CMAESOptimizer.push(this.fitnessHistory, d3);
            cMAESOptimizer$FitnessFunction.setValueRange(d4 - d3);
            if (this.generateStatistics) {
                this.statisticsSigmaHistory.add(this.sigma);
                this.statisticsFitnessHistory.add(d3);
                this.statisticsMeanHistory.add(this.xmean.transpose());
                this.statisticsDHistory.add(this.diagD.transpose().scalarMultiply(100000.0));
            }
            ++this.iterations;
        }
        return object;
    }

    private void parseOptimizationData(OptimizationData ... optimizationDataArray) {
        for (OptimizationData optimizationData : optimizationDataArray) {
            if (optimizationData instanceof CMAESOptimizer$Sigma) {
                this.inputSigma = ((CMAESOptimizer$Sigma)optimizationData).getSigma();
                continue;
            }
            if (!(optimizationData instanceof CMAESOptimizer$PopulationSize)) continue;
            this.lambda = ((CMAESOptimizer$PopulationSize)optimizationData).getPopulationSize();
        }
    }

    private void checkParameters() {
        double[] dArray = this.getStartPoint();
        double[] dArray2 = this.getLowerBound();
        double[] dArray3 = this.getUpperBound();
        if (this.inputSigma != null) {
            if (this.inputSigma.length != dArray.length) {
                throw new DimensionMismatchException(this.inputSigma.length, dArray.length);
            }
            for (int i2 = 0; i2 < dArray.length; ++i2) {
                if (this.inputSigma[i2] < 0.0) {
                    throw new NotPositiveException(this.inputSigma[i2]);
                }
                if (!(this.inputSigma[i2] > dArray3[i2] - dArray2[i2])) continue;
                throw new OutOfRangeException(this.inputSigma[i2], (Number)0, dArray3[i2] - dArray2[i2]);
            }
        }
    }

    private void initializeCMA(double[] dArray) {
        int n;
        if (this.lambda <= 0) {
            this.lambda = 4 + (int)(3.0 * FastMath.log(this.dimension));
        }
        double[][] dArray2 = new double[dArray.length][1];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            dArray2[i2][0] = this.inputSigma == null ? 0.3 : this.inputSigma[i2];
        }
        Array2DRowRealMatrix array2DRowRealMatrix = new Array2DRowRealMatrix(dArray2, false);
        this.sigma = CMAESOptimizer.max(array2DRowRealMatrix);
        this.stopTolUpX = 1000.0 * CMAESOptimizer.max(array2DRowRealMatrix);
        this.stopTolX = 1.0E-11 * CMAESOptimizer.max(array2DRowRealMatrix);
        this.stopTolFun = 1.0E-12;
        this.stopTolHistFun = 1.0E-13;
        this.mu = this.lambda / 2;
        this.logMu2 = FastMath.log((double)this.mu + 0.5);
        this.weights = CMAESOptimizer.log(CMAESOptimizer.sequence(1.0, this.mu, 1.0)).scalarMultiply(-1.0).scalarAdd(this.logMu2);
        double d2 = 0.0;
        double d3 = 0.0;
        for (n = 0; n < this.mu; ++n) {
            double d4 = this.weights.getEntry(n, 0);
            d2 += d4;
            double d5 = d4;
            d3 += d5 * d5;
        }
        this.weights = this.weights.scalarMultiply(1.0 / d2);
        double d6 = d2;
        this.mueff = d6 * d6 / d3;
        this.cc = (4.0 + this.mueff / (double)this.dimension) / ((double)(this.dimension + 4) + 2.0 * this.mueff / (double)this.dimension);
        this.cs = (this.mueff + 2.0) / ((double)this.dimension + this.mueff + 3.0);
        this.damps = (1.0 + 2.0 * FastMath.max(0.0, FastMath.sqrt((this.mueff - 1.0) / (double)(this.dimension + 1)) - 1.0)) * FastMath.max(0.3, 1.0 - (double)this.dimension / (1.0E-6 + (double)this.maxIterations)) + this.cs;
        this.ccov1 = 2.0 / (((double)this.dimension + 1.3) * ((double)this.dimension + 1.3) + this.mueff);
        this.ccovmu = FastMath.min(1.0 - this.ccov1, 2.0 * (this.mueff - 2.0 + 1.0 / this.mueff) / ((double)((this.dimension + 2) * (this.dimension + 2)) + this.mueff));
        this.ccov1Sep = FastMath.min(1.0, this.ccov1 * ((double)this.dimension + 1.5) / 3.0);
        this.ccovmuSep = FastMath.min(1.0 - this.ccov1, this.ccovmu * ((double)this.dimension + 1.5) / 3.0);
        this.chiN = FastMath.sqrt(this.dimension) * (1.0 - 1.0 / (4.0 * (double)this.dimension) + 1.0 / (21.0 * (double)this.dimension * (double)this.dimension));
        this.xmean = MatrixUtils.createColumnRealMatrix(dArray);
        this.diagD = array2DRowRealMatrix.scalarMultiply(1.0 / this.sigma);
        this.diagC = CMAESOptimizer.square(this.diagD);
        this.pc = CMAESOptimizer.zeros(this.dimension, 1);
        this.ps = CMAESOptimizer.zeros(this.dimension, 1);
        this.normps = this.ps.getFrobeniusNorm();
        this.B = CMAESOptimizer.eye(this.dimension, this.dimension);
        this.D = CMAESOptimizer.ones(this.dimension, 1);
        this.BD = CMAESOptimizer.times(this.B, CMAESOptimizer.repmat(this.diagD.transpose(), this.dimension, 1));
        this.C = this.B.multiply(CMAESOptimizer.diag(CMAESOptimizer.square(this.D)).multiply(this.B.transpose()));
        this.historySize = 10 + (int)((double)(30 * this.dimension) / (double)this.lambda);
        this.fitnessHistory = new double[this.historySize];
        for (n = 0; n < this.historySize; ++n) {
            this.fitnessHistory[n] = Double.MAX_VALUE;
        }
    }

    private boolean updateEvolutionPaths(RealMatrix realMatrix, RealMatrix realMatrix2) {
        this.ps = this.ps.scalarMultiply(1.0 - this.cs).add(this.B.multiply(realMatrix).scalarMultiply(FastMath.sqrt(this.cs * (2.0 - this.cs) * this.mueff)));
        this.normps = this.ps.getFrobeniusNorm();
        boolean bl = this.normps / FastMath.sqrt(1.0 - FastMath.pow(1.0 - this.cs, 2 * this.iterations)) / this.chiN < 1.4 + 2.0 / ((double)this.dimension + 1.0);
        this.pc = this.pc.scalarMultiply(1.0 - this.cc);
        if (bl) {
            this.pc = this.pc.add(this.xmean.subtract(realMatrix2).scalarMultiply(FastMath.sqrt(this.cc * (2.0 - this.cc) * this.mueff) / this.sigma));
        }
        return bl;
    }

    private void updateCovarianceDiagonalOnly(boolean bl, RealMatrix realMatrix) {
        double d2 = bl ? 0.0 : this.ccov1Sep * this.cc * (2.0 - this.cc);
        d2 = d2 + (1.0 - this.ccov1Sep - this.ccovmuSep);
        this.diagC = this.diagC.scalarMultiply(d2).add(CMAESOptimizer.square(this.pc).scalarMultiply(this.ccov1Sep)).add(CMAESOptimizer.times(this.diagC, CMAESOptimizer.square(realMatrix).multiply(this.weights)).scalarMultiply(this.ccovmuSep));
        this.diagD = CMAESOptimizer.sqrt(this.diagC);
        if (this.diagonalOnly > 1 && this.iterations > this.diagonalOnly) {
            this.diagonalOnly = 0;
            this.B = CMAESOptimizer.eye(this.dimension, this.dimension);
            this.BD = CMAESOptimizer.diag(this.diagD);
            this.C = CMAESOptimizer.diag(this.diagC);
        }
    }

    private void updateCovariance(boolean bl, RealMatrix realMatrix, RealMatrix realMatrix2, int[] nArray, RealMatrix realMatrix3) {
        double d2 = 0.0;
        if (this.ccov1 + this.ccovmu > 0.0) {
            realMatrix = realMatrix.subtract(CMAESOptimizer.repmat(realMatrix3, 1, this.mu)).scalarMultiply(1.0 / this.sigma);
            realMatrix3 = this.pc.multiply(this.pc.transpose()).scalarMultiply(this.ccov1);
            double d3 = bl ? 0.0 : this.ccov1 * this.cc * (2.0 - this.cc);
            d3 = d3 + (1.0 - this.ccov1 - this.ccovmu);
            if (this.isActiveCMA) {
                d2 = (1.0 - this.ccovmu) * 0.25 * this.mueff / (FastMath.pow((double)(this.dimension + 2), 1.5) + 2.0 * this.mueff);
                Object object = CMAESOptimizer.reverse(nArray);
                RealMatrix realMatrix4 = CMAESOptimizer.selectColumns(realMatrix2, MathArrays.copyOf((int[])object, this.mu));
                object = realMatrix4;
                realMatrix2 = CMAESOptimizer.sqrt(CMAESOptimizer.sumRows(CMAESOptimizer.square(realMatrix4)));
                nArray = this.sortedIndices(realMatrix2.getRow(0));
                RealMatrix realMatrix5 = CMAESOptimizer.selectColumns(realMatrix2, nArray);
                int[] nArray2 = CMAESOptimizer.reverse(nArray);
                realMatrix2 = CMAESOptimizer.selectColumns(realMatrix2, nArray2);
                realMatrix2 = CMAESOptimizer.divide(realMatrix2, realMatrix5);
                double d4 = 0.33999999999999997 / CMAESOptimizer.square(realMatrix2 = CMAESOptimizer.selectColumns(realMatrix2, nArray = CMAESOptimizer.inverse(nArray))).multiply(this.weights).getEntry(0, 0);
                if (d2 > d4) {
                    d2 = d4;
                }
                object = CMAESOptimizer.times((RealMatrix)object, CMAESOptimizer.repmat(realMatrix2, this.dimension, 1));
                RealMatrix realMatrix6 = this.BD.multiply((RealMatrix)object);
                object = realMatrix6;
                object = realMatrix6.multiply(CMAESOptimizer.diag(this.weights)).multiply(object.transpose());
                this.C = this.C.scalarMultiply(d3 += d2 * 0.5).add(realMatrix3).add(realMatrix.scalarMultiply(this.ccovmu + d2 * 0.5).multiply(CMAESOptimizer.times(CMAESOptimizer.repmat(this.weights, 1, this.dimension), realMatrix.transpose()))).subtract(object.scalarMultiply(d2));
            } else {
                this.C = this.C.scalarMultiply(d3).add(realMatrix3).add(realMatrix.scalarMultiply(this.ccovmu).multiply(CMAESOptimizer.times(CMAESOptimizer.repmat(this.weights, 1, this.dimension), realMatrix.transpose())));
            }
        }
        this.updateBD(d2);
    }

    private void updateBD(double d2) {
        if (this.ccov1 + this.ccovmu + d2 > 0.0 && (double)this.iterations % 1.0 / (this.ccov1 + this.ccovmu + d2) / (double)this.dimension / 10.0 < 1.0) {
            double d3;
            this.C = CMAESOptimizer.triu(this.C, 0).add(CMAESOptimizer.triu(this.C, 1).transpose());
            EigenDecomposition eigenDecomposition = new EigenDecomposition(this.C);
            this.B = eigenDecomposition.getV();
            this.D = eigenDecomposition.getD();
            this.diagD = CMAESOptimizer.diag(this.D);
            if (CMAESOptimizer.min(this.diagD) <= 0.0) {
                for (int i2 = 0; i2 < this.dimension; ++i2) {
                    if (!(this.diagD.getEntry(i2, 0) < 0.0)) continue;
                    this.diagD.setEntry(i2, 0, 0.0);
                }
                d3 = CMAESOptimizer.max(this.diagD) / 1.0E14;
                this.C = this.C.add(CMAESOptimizer.eye(this.dimension, this.dimension).scalarMultiply(d3));
                this.diagD = this.diagD.add(CMAESOptimizer.ones(this.dimension, 1).scalarMultiply(d3));
            }
            if (CMAESOptimizer.max(this.diagD) > 1.0E14 * CMAESOptimizer.min(this.diagD)) {
                d3 = CMAESOptimizer.max(this.diagD) / 1.0E14 - CMAESOptimizer.min(this.diagD);
                this.C = this.C.add(CMAESOptimizer.eye(this.dimension, this.dimension).scalarMultiply(d3));
                this.diagD = this.diagD.add(CMAESOptimizer.ones(this.dimension, 1).scalarMultiply(d3));
            }
            this.diagC = CMAESOptimizer.diag(this.C);
            this.diagD = CMAESOptimizer.sqrt(this.diagD);
            this.BD = CMAESOptimizer.times(this.B, CMAESOptimizer.repmat(this.diagD.transpose(), this.dimension, 1));
        }
    }

    private static void push(double[] dArray, double d2) {
        for (int i2 = dArray.length - 1; i2 > 0; --i2) {
            dArray[i2] = dArray[i2 - 1];
        }
        dArray[0] = d2;
    }

    private int[] sortedIndices(double[] dArray) {
        Object[] objectArray = new CMAESOptimizer$DoubleIndex[dArray.length];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            objectArray[i2] = new CMAESOptimizer$DoubleIndex(dArray[i2], i2);
        }
        Arrays.sort(objectArray);
        int[] nArray = new int[dArray.length];
        for (int i3 = 0; i3 < dArray.length; ++i3) {
            nArray[i3] = CMAESOptimizer$DoubleIndex.access$100((CMAESOptimizer$DoubleIndex)objectArray[i3]);
        }
        return nArray;
    }

    private static RealMatrix log(RealMatrix realMatrix) {
        double[][] dArray = new double[realMatrix.getRowDimension()][realMatrix.getColumnDimension()];
        for (int i2 = 0; i2 < realMatrix.getRowDimension(); ++i2) {
            for (int i3 = 0; i3 < realMatrix.getColumnDimension(); ++i3) {
                dArray[i2][i3] = FastMath.log(realMatrix.getEntry(i2, i3));
            }
        }
        return new Array2DRowRealMatrix(dArray, false);
    }

    private static RealMatrix sqrt(RealMatrix realMatrix) {
        double[][] dArray = new double[realMatrix.getRowDimension()][realMatrix.getColumnDimension()];
        for (int i2 = 0; i2 < realMatrix.getRowDimension(); ++i2) {
            for (int i3 = 0; i3 < realMatrix.getColumnDimension(); ++i3) {
                dArray[i2][i3] = FastMath.sqrt(realMatrix.getEntry(i2, i3));
            }
        }
        return new Array2DRowRealMatrix(dArray, false);
    }

    private static RealMatrix square(RealMatrix realMatrix) {
        double[][] dArray = new double[realMatrix.getRowDimension()][realMatrix.getColumnDimension()];
        for (int i2 = 0; i2 < realMatrix.getRowDimension(); ++i2) {
            for (int i3 = 0; i3 < realMatrix.getColumnDimension(); ++i3) {
                double d2;
                double d3 = d2 = realMatrix.getEntry(i2, i3);
                dArray[i2][i3] = d3 * d3;
            }
        }
        return new Array2DRowRealMatrix(dArray, false);
    }

    private static RealMatrix times(RealMatrix realMatrix, RealMatrix realMatrix2) {
        double[][] dArray = new double[realMatrix.getRowDimension()][realMatrix.getColumnDimension()];
        for (int i2 = 0; i2 < realMatrix.getRowDimension(); ++i2) {
            for (int i3 = 0; i3 < realMatrix.getColumnDimension(); ++i3) {
                dArray[i2][i3] = realMatrix.getEntry(i2, i3) * realMatrix2.getEntry(i2, i3);
            }
        }
        return new Array2DRowRealMatrix(dArray, false);
    }

    private static RealMatrix divide(RealMatrix realMatrix, RealMatrix realMatrix2) {
        double[][] dArray = new double[realMatrix.getRowDimension()][realMatrix.getColumnDimension()];
        for (int i2 = 0; i2 < realMatrix.getRowDimension(); ++i2) {
            for (int i3 = 0; i3 < realMatrix.getColumnDimension(); ++i3) {
                dArray[i2][i3] = realMatrix.getEntry(i2, i3) / realMatrix2.getEntry(i2, i3);
            }
        }
        return new Array2DRowRealMatrix(dArray, false);
    }

    private static RealMatrix selectColumns(RealMatrix realMatrix, int[] nArray) {
        double[][] dArray = new double[realMatrix.getRowDimension()][nArray.length];
        for (int i2 = 0; i2 < realMatrix.getRowDimension(); ++i2) {
            for (int i3 = 0; i3 < nArray.length; ++i3) {
                dArray[i2][i3] = realMatrix.getEntry(i2, nArray[i3]);
            }
        }
        return new Array2DRowRealMatrix(dArray, false);
    }

    private static RealMatrix triu(RealMatrix realMatrix, int n) {
        double[][] dArray = new double[realMatrix.getRowDimension()][realMatrix.getColumnDimension()];
        for (int i2 = 0; i2 < realMatrix.getRowDimension(); ++i2) {
            for (int i3 = 0; i3 < realMatrix.getColumnDimension(); ++i3) {
                dArray[i2][i3] = i2 <= i3 - n ? realMatrix.getEntry(i2, i3) : 0.0;
            }
        }
        return new Array2DRowRealMatrix(dArray, false);
    }

    private static RealMatrix sumRows(RealMatrix realMatrix) {
        double[][] dArray = new double[1][realMatrix.getColumnDimension()];
        for (int i2 = 0; i2 < realMatrix.getColumnDimension(); ++i2) {
            double d2 = 0.0;
            for (int i3 = 0; i3 < realMatrix.getRowDimension(); ++i3) {
                d2 += realMatrix.getEntry(i3, i2);
            }
            dArray[0][i2] = d2;
        }
        return new Array2DRowRealMatrix(dArray, false);
    }

    private static RealMatrix diag(RealMatrix realMatrix) {
        if (realMatrix.getColumnDimension() == 1) {
            double[][] dArray = new double[realMatrix.getRowDimension()][realMatrix.getRowDimension()];
            for (int i2 = 0; i2 < realMatrix.getRowDimension(); ++i2) {
                dArray[i2][i2] = realMatrix.getEntry(i2, 0);
            }
            return new Array2DRowRealMatrix(dArray, false);
        }
        double[][] dArray = new double[realMatrix.getRowDimension()][1];
        for (int i3 = 0; i3 < realMatrix.getColumnDimension(); ++i3) {
            int n = i3;
            dArray[i3][0] = realMatrix.getEntry(n, n);
        }
        return new Array2DRowRealMatrix(dArray, false);
    }

    private static void copyColumn(RealMatrix realMatrix, int n, RealMatrix realMatrix2, int n2) {
        for (int i2 = 0; i2 < realMatrix.getRowDimension(); ++i2) {
            realMatrix2.setEntry(i2, n2, realMatrix.getEntry(i2, n));
        }
    }

    private static RealMatrix ones(int n, int n2) {
        double[][] dArray = new double[n][n2];
        for (int i2 = 0; i2 < n; ++i2) {
            Arrays.fill(dArray[i2], 1.0);
        }
        return new Array2DRowRealMatrix(dArray, false);
    }

    private static RealMatrix eye(int n, int n2) {
        double[][] dArray = new double[n][n2];
        for (int i2 = 0; i2 < n; ++i2) {
            if (i2 >= n2) continue;
            dArray[i2][i2] = 1.0;
        }
        return new Array2DRowRealMatrix(dArray, false);
    }

    private static RealMatrix zeros(int n, int n2) {
        return new Array2DRowRealMatrix(n, n2);
    }

    private static RealMatrix repmat(RealMatrix realMatrix, int n, int n2) {
        int n3 = realMatrix.getRowDimension();
        int n4 = realMatrix.getColumnDimension();
        double[][] dArray = new double[n * n3][n2 * n4];
        for (int i2 = 0; i2 < n * n3; ++i2) {
            for (int i3 = 0; i3 < n2 * n4; ++i3) {
                dArray[i2][i3] = realMatrix.getEntry(i2 % n3, i3 % n4);
            }
        }
        return new Array2DRowRealMatrix(dArray, false);
    }

    private static RealMatrix sequence(double d2, double d3, double d4) {
        int n = (int)((d3 - d2) / d4 + 1.0);
        double[][] dArray = new double[n][1];
        double d5 = d2;
        for (int i2 = 0; i2 < n; ++i2) {
            dArray[i2][0] = d5;
            d5 += d4;
        }
        return new Array2DRowRealMatrix(dArray, false);
    }

    private static double max(RealMatrix realMatrix) {
        double d2 = -1.7976931348623157E308;
        for (int i2 = 0; i2 < realMatrix.getRowDimension(); ++i2) {
            for (int i3 = 0; i3 < realMatrix.getColumnDimension(); ++i3) {
                double d3 = realMatrix.getEntry(i2, i3);
                if (!(d2 < d3)) continue;
                d2 = d3;
            }
        }
        return d2;
    }

    private static double min(RealMatrix realMatrix) {
        double d2 = Double.MAX_VALUE;
        for (int i2 = 0; i2 < realMatrix.getRowDimension(); ++i2) {
            for (int i3 = 0; i3 < realMatrix.getColumnDimension(); ++i3) {
                double d3 = realMatrix.getEntry(i2, i3);
                if (!(d2 > d3)) continue;
                d2 = d3;
            }
        }
        return d2;
    }

    private static double max(double[] dArray) {
        double d2 = -1.7976931348623157E308;
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            if (!(d2 < dArray[i2])) continue;
            d2 = dArray[i2];
        }
        return d2;
    }

    private static double min(double[] dArray) {
        double d2 = Double.MAX_VALUE;
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            if (!(d2 > dArray[i2])) continue;
            d2 = dArray[i2];
        }
        return d2;
    }

    private static int[] inverse(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray2[nArray[i2]] = i2;
        }
        return nArray2;
    }

    private static int[] reverse(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray2[i2] = nArray[nArray.length - i2 - 1];
        }
        return nArray2;
    }

    private double[] randn(int n) {
        double[] dArray = new double[n];
        for (int i2 = 0; i2 < n; ++i2) {
            dArray[i2] = this.random.nextGaussian();
        }
        return dArray;
    }

    private RealMatrix randn1(int n, int n2) {
        double[][] dArray = new double[n][n2];
        for (int i2 = 0; i2 < n; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                dArray[i2][i3] = this.random.nextGaussian();
            }
        }
        return new Array2DRowRealMatrix(dArray, false);
    }

    static /* synthetic */ boolean access$200(CMAESOptimizer cMAESOptimizer) {
        return cMAESOptimizer.isMinimize;
    }
}

