/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.optimization;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.MultivariateVectorFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.ConvergenceException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathIllegalStateException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotStrictlyPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NullArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optimization.BaseMultivariateVectorMultiStartOptimizer$1;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optimization.BaseMultivariateVectorOptimizer;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optimization.ConvergenceChecker;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optimization.PointVectorValuePair;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.RandomVectorGenerator;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class BaseMultivariateVectorMultiStartOptimizer<FUNC extends MultivariateVectorFunction>
implements BaseMultivariateVectorOptimizer<FUNC> {
    private final BaseMultivariateVectorOptimizer<FUNC> optimizer;
    private int maxEvaluations;
    private int totalEvaluations;
    private int starts;
    private RandomVectorGenerator generator;
    private PointVectorValuePair[] optima;

    protected BaseMultivariateVectorMultiStartOptimizer(BaseMultivariateVectorOptimizer<FUNC> baseMultivariateVectorOptimizer, int n, RandomVectorGenerator randomVectorGenerator) {
        if (baseMultivariateVectorOptimizer == null || randomVectorGenerator == null) {
            throw new NullArgumentException();
        }
        if (n <= 0) {
            throw new NotStrictlyPositiveException(n);
        }
        this.optimizer = baseMultivariateVectorOptimizer;
        this.starts = n;
        this.generator = randomVectorGenerator;
    }

    public PointVectorValuePair[] getOptima() {
        if (this.optima == null) {
            throw new MathIllegalStateException(LocalizedFormats.NO_OPTIMUM_COMPUTED_YET, new Object[0]);
        }
        return (PointVectorValuePair[])this.optima.clone();
    }

    @Override
    public int getMaxEvaluations() {
        return this.maxEvaluations;
    }

    @Override
    public int getEvaluations() {
        return this.totalEvaluations;
    }

    @Override
    public ConvergenceChecker<PointVectorValuePair> getConvergenceChecker() {
        return this.optimizer.getConvergenceChecker();
    }

    @Override
    public PointVectorValuePair optimize(int n, FUNC FUNC, double[] dArray, double[] dArray2, double[] dArray3) {
        this.maxEvaluations = n;
        RuntimeException runtimeException = null;
        this.optima = new PointVectorValuePair[this.starts];
        this.totalEvaluations = 0;
        for (int i2 = 0; i2 < this.starts; ++i2) {
            try {
                this.optima[i2] = this.optimizer.optimize(n - this.totalEvaluations, FUNC, dArray, dArray2, i2 == 0 ? dArray3 : this.generator.nextVector());
            }
            catch (ConvergenceException convergenceException) {
                this.optima[i2] = null;
            }
            catch (RuntimeException runtimeException2) {
                runtimeException = runtimeException2;
                runtimeException = runtimeException2;
                this.optima[i2] = null;
            }
            this.totalEvaluations += this.optimizer.getEvaluations();
        }
        this.sortPairs(dArray, dArray2);
        if (this.optima[0] == null) {
            throw runtimeException;
        }
        return this.optima[0];
    }

    private void sortPairs(double[] dArray, double[] dArray2) {
        Arrays.sort(this.optima, new BaseMultivariateVectorMultiStartOptimizer$1(this, dArray, dArray2));
    }
}

