/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.univariate;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooLargeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.OutOfRangeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.OptimizationData;

public class SearchInterval
implements OptimizationData {
    private final double lower;
    private final double upper;
    private final double start;

    public SearchInterval(double d2, double d3, double d4) {
        if (d2 >= d3) {
            throw new NumberIsTooLargeException(d2, (Number)d3, false);
        }
        if (d4 < d2 || d4 > d3) {
            throw new OutOfRangeException(d4, (Number)d2, d3);
        }
        this.lower = d2;
        this.upper = d3;
        this.start = d4;
    }

    public SearchInterval(double d2, double d3) {
        this(d2, d3, 0.5 * (d2 + d3));
    }

    public double getMin() {
        return this.lower;
    }

    public double getMax() {
        return this.upper;
    }

    public double getStartValue() {
        return this.start;
    }
}

