/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.univariate;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathIllegalStateException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotStrictlyPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.MaxEval;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.OptimizationData;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.nonlinear.scalar.GoalType;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.univariate.MultiStartUnivariateOptimizer$1;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.univariate.SearchInterval;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.univariate.UnivariateOptimizer;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.univariate.UnivariatePointValuePair;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.RandomGenerator;
import java.util.Arrays;

public class MultiStartUnivariateOptimizer
extends UnivariateOptimizer {
    private final UnivariateOptimizer optimizer;
    private int totalEvaluations;
    private int starts;
    private RandomGenerator generator;
    private UnivariatePointValuePair[] optima;
    private OptimizationData[] optimData;
    private int maxEvalIndex = -1;
    private int searchIntervalIndex = -1;

    public MultiStartUnivariateOptimizer(UnivariateOptimizer univariateOptimizer, int n, RandomGenerator randomGenerator) {
        super(univariateOptimizer.getConvergenceChecker());
        if (n <= 0) {
            throw new NotStrictlyPositiveException(n);
        }
        this.optimizer = univariateOptimizer;
        this.starts = n;
        this.generator = randomGenerator;
    }

    public int getEvaluations() {
        return this.totalEvaluations;
    }

    public UnivariatePointValuePair[] getOptima() {
        if (this.optima == null) {
            throw new MathIllegalStateException(LocalizedFormats.NO_OPTIMUM_COMPUTED_YET, new Object[0]);
        }
        return (UnivariatePointValuePair[])this.optima.clone();
    }

    public UnivariatePointValuePair optimize(OptimizationData ... optimizationDataArray) {
        this.optimData = optimizationDataArray;
        return super.optimize(optimizationDataArray);
    }

    protected UnivariatePointValuePair doOptimize() {
        for (int i2 = 0; i2 < this.optimData.length; ++i2) {
            if (this.optimData[i2] instanceof MaxEval) {
                this.optimData[i2] = null;
                this.maxEvalIndex = i2;
                continue;
            }
            if (!(this.optimData[i2] instanceof SearchInterval)) continue;
            this.optimData[i2] = null;
            this.searchIntervalIndex = i2;
        }
        if (this.maxEvalIndex == -1) {
            throw new MathIllegalStateException();
        }
        if (this.searchIntervalIndex == -1) {
            throw new MathIllegalStateException();
        }
        RuntimeException runtimeException = null;
        this.optima = new UnivariatePointValuePair[this.starts];
        this.totalEvaluations = 0;
        int n = this.getMaxEvaluations();
        double d2 = this.getMin();
        double d3 = this.getMax();
        double d4 = this.getStartValue();
        for (int i3 = 0; i3 < this.starts; ++i3) {
            try {
                this.optimData[this.maxEvalIndex] = new MaxEval(n - this.totalEvaluations);
                double d5 = i3 == 0 ? d4 : d2 + this.generator.nextDouble() * (d3 - d2);
                this.optimData[this.searchIntervalIndex] = new SearchInterval(d2, d3, d5);
                this.optima[i3] = this.optimizer.optimize(this.optimData);
            }
            catch (RuntimeException runtimeException2) {
                RuntimeException runtimeException3 = runtimeException2;
                runtimeException = runtimeException2;
                this.optima[i3] = null;
            }
            this.totalEvaluations += this.optimizer.getEvaluations();
        }
        MultiStartUnivariateOptimizer multiStartUnivariateOptimizer = this;
        multiStartUnivariateOptimizer.sortPairs(multiStartUnivariateOptimizer.getGoalType());
        if (this.optima[0] == null) {
            throw runtimeException;
        }
        return this.optima[0];
    }

    private void sortPairs(GoalType goalType) {
        Arrays.sort(this.optima, new MultiStartUnivariateOptimizer$1(this, goalType));
    }
}

