/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.univariate;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotStrictlyPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooSmallException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.ConvergenceChecker;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.nonlinear.scalar.GoalType;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.univariate.UnivariateOptimizer;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.univariate.UnivariatePointValuePair;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.Precision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrentOptimizer
extends UnivariateOptimizer {
    private static final double GOLDEN_SECTION = 0.5 * (3.0 - FastMath.sqrt(5.0));
    private static final double MIN_RELATIVE_TOLERANCE = 2.0 * FastMath.ulp(1.0);
    private final double relativeThreshold;
    private final double absoluteThreshold;

    public BrentOptimizer(double d2, double d3, ConvergenceChecker<UnivariatePointValuePair> convergenceChecker) {
        super(convergenceChecker);
        if (d2 < MIN_RELATIVE_TOLERANCE) {
            throw new NumberIsTooSmallException(d2, (Number)MIN_RELATIVE_TOLERANCE, true);
        }
        if (d3 <= 0.0) {
            throw new NotStrictlyPositiveException(d3);
        }
        this.relativeThreshold = d2;
        this.absoluteThreshold = d3;
    }

    public BrentOptimizer(double d2, double d3) {
        this(d2, d3, null);
    }

    @Override
    protected UnivariatePointValuePair doOptimize() {
        UnivariatePointValuePair univariatePointValuePair;
        double d2;
        double d3;
        double d4;
        boolean bl = this.getGoalType() == GoalType.MINIMIZE;
        double d5 = this.getMin();
        double d6 = this.getStartValue();
        double d7 = this.getMax();
        ConvergenceChecker<UnivariatePointValuePair> convergenceChecker = this.getConvergenceChecker();
        if (d5 < d7) {
            d4 = d5;
            d3 = d7;
        } else {
            d4 = d7;
            d3 = d5;
        }
        double d8 = d2 = d6;
        double d9 = d2;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = this.computeObjectiveValue(d2);
        if (!bl) {
            d12 = -d12;
        }
        double d13 = d12;
        double d14 = d12;
        UnivariatePointValuePair univariatePointValuePair2 = null;
        UnivariatePointValuePair univariatePointValuePair3 = univariatePointValuePair = new UnivariatePointValuePair(d2, bl ? d12 : -d12);
        while (true) {
            double d15 = 0.5 * (d4 + d3);
            double d16 = this.relativeThreshold * FastMath.abs(d2) + this.absoluteThreshold;
            double d17 = d16 * 2.0;
            boolean bl2 = FastMath.abs(d2 - d15) <= d17 - 0.5 * (d3 - d4);
            if (!bl2) {
                double d18;
                if (FastMath.abs(d11) > d16) {
                    double d19;
                    double d20 = (d2 - d9) * (d12 - d13);
                    double d21 = (d2 - d8) * (d12 - d14);
                    double d22 = (d2 - d8) * d21 - (d2 - d9) * d20;
                    d21 = 2.0 * (d21 - d20);
                    if (d19 > 0.0) {
                        d22 = -d22;
                    } else {
                        d21 = -d21;
                    }
                    d20 = d11;
                    d11 = d10;
                    if (d22 > d21 * (d4 - d2) && d22 < d21 * (d3 - d2) && FastMath.abs(d22) < FastMath.abs(d21 * 0.5 * d20)) {
                        d10 = d22 / d21;
                        d18 = d2 + d10;
                        if (d18 - d4 < d17 || d3 - d18 < d17) {
                            d10 = d2 <= d15 ? d16 : -d16;
                        }
                    } else {
                        d11 = d2 < d15 ? d3 - d2 : d4 - d2;
                        d10 = GOLDEN_SECTION * d11;
                    }
                } else {
                    d11 = d2 < d15 ? d3 - d2 : d4 - d2;
                    d10 = GOLDEN_SECTION * d11;
                }
                d18 = FastMath.abs(d10) < d16 ? (d10 >= 0.0 ? d2 + d16 : d2 - d16) : d2 + d10;
                double d23 = this.computeObjectiveValue(d18);
                if (!bl) {
                    d23 = -d23;
                }
                univariatePointValuePair2 = univariatePointValuePair;
                univariatePointValuePair = new UnivariatePointValuePair(d18, bl ? d23 : -d23);
                univariatePointValuePair3 = this.best(univariatePointValuePair3, this.best(univariatePointValuePair2, univariatePointValuePair, bl), bl);
                if (convergenceChecker != null && convergenceChecker.converged(this.getIterations(), univariatePointValuePair2, univariatePointValuePair)) {
                    return univariatePointValuePair3;
                }
                if (d23 <= d12) {
                    if (d18 < d2) {
                        d3 = d2;
                    } else {
                        d4 = d2;
                    }
                    d8 = d9;
                    d13 = d14;
                    d9 = d2;
                    d14 = d12;
                    d2 = d18;
                    d12 = d23;
                } else {
                    if (d18 < d2) {
                        d4 = d18;
                    } else {
                        d3 = d18;
                    }
                    if (d23 <= d14 || Precision.equals(d9, d2)) {
                        d8 = d9;
                        d13 = d14;
                        d9 = d18;
                        d14 = d23;
                    } else if (d23 <= d13 || Precision.equals(d8, d2) || Precision.equals(d8, d9)) {
                        d8 = d18;
                        d13 = d23;
                    }
                }
            } else {
                return this.best(univariatePointValuePair3, this.best(univariatePointValuePair2, univariatePointValuePair, bl), bl);
            }
            this.incrementIterationCount();
        }
    }

    private UnivariatePointValuePair best(UnivariatePointValuePair univariatePointValuePair, UnivariatePointValuePair univariatePointValuePair2, boolean bl) {
        if (univariatePointValuePair == null) {
            return univariatePointValuePair2;
        }
        if (univariatePointValuePair2 == null) {
            return univariatePointValuePair;
        }
        if (bl) {
            if (univariatePointValuePair.getValue() <= univariatePointValuePair2.getValue()) {
                return univariatePointValuePair;
            }
            return univariatePointValuePair2;
        }
        if (univariatePointValuePair.getValue() >= univariatePointValuePair2.getValue()) {
            return univariatePointValuePair;
        }
        return univariatePointValuePair2;
    }
}

