/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.univariate;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.UnivariateFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MaxCountExceededException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotStrictlyPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.TooManyEvaluationsException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.nonlinear.scalar.GoalType;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.IntegerSequence$Incrementor;

public class BracketFinder {
    private static final double EPS_MIN = 1.0E-21;
    private static final double GOLD = 1.618034;
    private final double growLimit;
    private IntegerSequence$Incrementor evaluations;
    private double lo;
    private double hi;
    private double mid;
    private double fLo;
    private double fHi;
    private double fMid;

    public BracketFinder() {
        this(100.0, 500);
    }

    public BracketFinder(double d2, int n) {
        if (d2 <= 0.0) {
            throw new NotStrictlyPositiveException(d2);
        }
        if (n <= 0) {
            throw new NotStrictlyPositiveException(n);
        }
        this.growLimit = d2;
        this.evaluations = IntegerSequence$Incrementor.create().withMaximalCount(n);
    }

    public void search(UnivariateFunction univariateFunction, GoalType goalType, double d2, double d3) {
        double d4;
        double d5;
        this.evaluations = this.evaluations.withStart(0);
        boolean bl = goalType == GoalType.MINIMIZE;
        double d6 = this.eval(univariateFunction, d2);
        double d7 = this.eval(univariateFunction, d3);
        if (bl ? d6 < d7 : d6 > d7) {
            d5 = d2;
            d2 = d3;
            d3 = d5;
            d5 = d6;
            d6 = d7;
            d7 = d5;
        }
        d5 = d3 + 1.618034 * (d3 - d2);
        double d8 = this.eval(univariateFunction, d5);
        while (bl ? d8 < d7 : d8 > d7) {
            double d9;
            double d10;
            d4 = (d3 - d2) * (d7 - d8);
            double d11 = (d3 - d5) * (d7 - d6);
            double d12 = d11 - d4;
            double d13 = FastMath.abs(d10) < 1.0E-21 ? 2.0E-21 : d12 * 2.0;
            double d14 = d3;
            double d15 = d14 - ((d14 - d5) * d11 - (d3 - d2) * d4) / d13;
            double d16 = d3 + this.growLimit * (d5 - d3);
            if ((d15 - d5) * (d3 - d15) > 0.0) {
                d9 = this.eval(univariateFunction, d15);
                if (bl ? d9 < d8 : d9 > d8) {
                    d2 = d3;
                    d3 = d15;
                    d6 = d7;
                    d7 = d9;
                    break;
                }
                if (bl ? d9 > d7 : d9 < d7) {
                    d5 = d15;
                    d8 = d9;
                    break;
                }
                d15 = d5 + 1.618034 * (d5 - d3);
                d9 = this.eval(univariateFunction, d15);
            } else if ((d15 - d16) * (d16 - d5) >= 0.0) {
                d15 = d16;
                d9 = this.eval(univariateFunction, d15);
            } else if ((d15 - d16) * (d5 - d15) > 0.0) {
                d9 = this.eval(univariateFunction, d15);
                if (bl ? d9 < d8 : d9 > d8) {
                    d3 = d5;
                    d5 = d15;
                    d15 = d5 + 1.618034 * (d5 - d3);
                    d7 = d8;
                    d8 = d9;
                    d9 = this.eval(univariateFunction, d15);
                }
            } else {
                d15 = d5 + 1.618034 * (d5 - d3);
                d9 = this.eval(univariateFunction, d15);
            }
            d2 = d3;
            d6 = d7;
            d3 = d5;
            d7 = d8;
            d5 = d15;
            d8 = d9;
        }
        this.lo = d2;
        this.fLo = d6;
        this.mid = d3;
        this.fMid = d7;
        this.hi = d5;
        this.fHi = d8;
        if (this.lo > this.hi) {
            d4 = this.lo;
            this.lo = this.hi;
            this.hi = d4;
            d4 = this.fLo;
            this.fLo = this.fHi;
            this.fHi = d4;
        }
    }

    public int getMaxEvaluations() {
        return this.evaluations.getMaximalCount();
    }

    public int getEvaluations() {
        return this.evaluations.getCount();
    }

    public double getLo() {
        return this.lo;
    }

    public double getFLo() {
        return this.fLo;
    }

    public double getHi() {
        return this.hi;
    }

    public double getFHi() {
        return this.fHi;
    }

    public double getMid() {
        return this.mid;
    }

    public double getFMid() {
        return this.fMid;
    }

    private double eval(UnivariateFunction univariateFunction, double d2) {
        try {
            this.evaluations.increment();
        }
        catch (MaxCountExceededException maxCountExceededException) {
            throw new TooManyEvaluationsException(maxCountExceededException.getMax());
        }
        return univariateFunction.value(d2);
    }
}

