/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.nonlinear.scalar.noderiv;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathUnsupportedOperationException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NullArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.ConvergenceChecker;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.OptimizationData;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.PointValuePair;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.SimpleValueChecker;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.nonlinear.scalar.GoalType;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.nonlinear.scalar.MultivariateOptimizer;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.nonlinear.scalar.noderiv.AbstractSimplex;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.nonlinear.scalar.noderiv.SimplexOptimizer$1;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.nonlinear.scalar.noderiv.SimplexOptimizer$2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimplexOptimizer
extends MultivariateOptimizer {
    private AbstractSimplex simplex;

    public SimplexOptimizer(ConvergenceChecker<PointValuePair> convergenceChecker) {
        super(convergenceChecker);
    }

    public SimplexOptimizer(double d2, double d3) {
        this(new SimpleValueChecker(d2, d3));
    }

    @Override
    public PointValuePair optimize(OptimizationData ... optimizationDataArray) {
        return super.optimize(optimizationDataArray);
    }

    @Override
    protected PointValuePair doOptimize() {
        this.checkParameters();
        SimplexOptimizer$1 simplexOptimizer$1 = new SimplexOptimizer$1(this);
        boolean bl = this.getGoalType() == GoalType.MINIMIZE;
        SimplexOptimizer$2 simplexOptimizer$2 = new SimplexOptimizer$2(this, bl);
        this.simplex.build(this.getStartPoint());
        this.simplex.evaluate(simplexOptimizer$1, simplexOptimizer$2);
        PointValuePair[] pointValuePairArray = null;
        ConvergenceChecker<PointValuePair> convergenceChecker = this.getConvergenceChecker();
        while (true) {
            if (this.getIterations() > 0) {
                boolean bl2 = true;
                for (int i2 = 0; i2 < this.simplex.getSize(); ++i2) {
                    PointValuePair pointValuePair = pointValuePairArray[i2];
                    bl2 = bl2 && convergenceChecker.converged(0, pointValuePair, this.simplex.getPoint(i2));
                }
                if (bl2) {
                    return this.simplex.getPoint(0);
                }
            }
            pointValuePairArray = this.simplex.getPoints();
            this.simplex.iterate(simplexOptimizer$1, simplexOptimizer$2);
            this.incrementIterationCount();
        }
    }

    @Override
    protected void parseOptimizationData(OptimizationData ... optimizationDataArray) {
        super.parseOptimizationData(optimizationDataArray);
        for (OptimizationData optimizationData : optimizationDataArray) {
            if (!(optimizationData instanceof AbstractSimplex)) continue;
            this.simplex = (AbstractSimplex)optimizationData;
            return;
        }
    }

    private void checkParameters() {
        if (this.simplex == null) {
            throw new NullArgumentException();
        }
        if (this.getLowerBound() != null || this.getUpperBound() != null) {
            throw new MathUnsupportedOperationException(LocalizedFormats.CONSTRAINT, new Object[0]);
        }
    }
}

