/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.nonlinear.scalar.noderiv;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotStrictlyPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.OutOfRangeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.TooManyEvaluationsException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.Array2DRowRealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.EigenDecomposition;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.MatrixUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrix;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.ConvergenceChecker;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.OptimizationData;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.PointValuePair;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.nonlinear.scalar.GoalType;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.nonlinear.scalar.MultivariateOptimizer;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.nonlinear.scalar.noderiv.CMAESOptimizer$DoubleIndex;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.nonlinear.scalar.noderiv.CMAESOptimizer$FitnessFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.nonlinear.scalar.noderiv.CMAESOptimizer$PopulationSize;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.nonlinear.scalar.noderiv.CMAESOptimizer$Sigma;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.nonlinear.scalar.noderiv.CMAESOptimizer$ValuePenaltyPair;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.random.RandomGenerator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMAESOptimizer
extends MultivariateOptimizer {
    private int lambda;
    private final boolean isActiveCMA;
    private final int checkFeasableCount;
    private double[] inputSigma;
    private int dimension;
    private int diagonalOnly;
    private boolean isMinimize = true;
    private final boolean generateStatistics;
    private final int maxIterations;
    private final double stopFitness;
    private double stopTolUpX;
    private double stopTolX;
    private double stopTolFun;
    private double stopTolHistFun;
    private int mu;
    private double logMu2;
    private RealMatrix weights;
    private double mueff;
    private double sigma;
    private double cc;
    private double cs;
    private double damps;
    private double ccov1;
    private double ccovmu;
    private double chiN;
    private double ccov1Sep;
    private double ccovmuSep;
    private RealMatrix xmean;
    private RealMatrix pc;
    private RealMatrix ps;
    private double normps;
    private RealMatrix B;
    private RealMatrix D;
    private RealMatrix BD;
    private RealMatrix diagD;
    private RealMatrix C;
    private RealMatrix diagC;
    private int iterations;
    private double[] fitnessHistory;
    private int historySize;
    private final RandomGenerator random;
    private final List<Double> statisticsSigmaHistory = new ArrayList<Double>();
    private final List<RealMatrix> statisticsMeanHistory = new ArrayList<RealMatrix>();
    private final List<Double> statisticsFitnessHistory = new ArrayList<Double>();
    private final List<RealMatrix> statisticsDHistory = new ArrayList<RealMatrix>();

    public CMAESOptimizer(int n, double d2, boolean bl, int n2, int n3, RandomGenerator randomGenerator, boolean bl2, ConvergenceChecker<PointValuePair> convergenceChecker) {
        super(convergenceChecker);
        this.maxIterations = n;
        this.stopFitness = d2;
        this.isActiveCMA = bl;
        this.diagonalOnly = n2;
        this.checkFeasableCount = n3;
        this.random = randomGenerator;
        this.generateStatistics = bl2;
    }

    public List<Double> getStatisticsSigmaHistory() {
        return this.statisticsSigmaHistory;
    }

    public List<RealMatrix> getStatisticsMeanHistory() {
        return this.statisticsMeanHistory;
    }

    public List<Double> getStatisticsFitnessHistory() {
        return this.statisticsFitnessHistory;
    }

    public List<RealMatrix> getStatisticsDHistory() {
        return this.statisticsDHistory;
    }

    @Override
    public PointValuePair optimize(OptimizationData ... optimizationDataArray) {
        return super.optimize(optimizationDataArray);
    }

    @Override
    protected PointValuePair doOptimize() {
        this.isMinimize = this.getGoalType().equals(GoalType.MINIMIZE);
        CMAESOptimizer$FitnessFunction cMAESOptimizer$FitnessFunction = new CMAESOptimizer$FitnessFunction(this);
        Object object = this.getStartPoint();
        this.dimension = ((double[])object).length;
        this.initializeCMA((double[])object);
        this.iterations = 0;
        CMAESOptimizer$ValuePenaltyPair cMAESOptimizer$ValuePenaltyPair = cMAESOptimizer$FitnessFunction.value((double[])object);
        object = cMAESOptimizer$ValuePenaltyPair;
        double d2 = CMAESOptimizer$ValuePenaltyPair.access$000(cMAESOptimizer$ValuePenaltyPair) + CMAESOptimizer$ValuePenaltyPair.access$100((CMAESOptimizer$ValuePenaltyPair)object);
        CMAESOptimizer.push(this.fitnessHistory, d2);
        object = new PointValuePair(this.getStartPoint(), this.isMinimize ? d2 : -d2);
        Object object2 = null;
        this.iterations = 1;
        block2: while (this.iterations <= this.maxIterations) {
            int n;
            int n2;
            int n3;
            this.incrementIterationCount();
            CMAESOptimizer cMAESOptimizer = this;
            Object object3 = cMAESOptimizer.randn1(cMAESOptimizer.dimension, this.lambda);
            RealMatrix realMatrix = CMAESOptimizer.zeros(this.dimension, this.lambda);
            double[] dArray = new double[this.lambda];
            Object object4 = new CMAESOptimizer$ValuePenaltyPair[this.lambda];
            for (n3 = 0; n3 < this.lambda; n3 += 1) {
                RealMatrix realMatrix2 = null;
                for (n2 = 0; n2 < this.checkFeasableCount + 1; ++n2) {
                    realMatrix2 = this.diagonalOnly <= 0 ? this.xmean.add(this.BD.multiply(object3.getColumnMatrix(n3)).scalarMultiply(this.sigma)) : this.xmean.add(CMAESOptimizer.times(this.diagD, object3.getColumnMatrix(n3)).scalarMultiply(this.sigma));
                    if (n2 >= this.checkFeasableCount || cMAESOptimizer$FitnessFunction.isFeasible(realMatrix2.getColumn(0))) break;
                    CMAESOptimizer cMAESOptimizer2 = this;
                    object3.setColumn(n3, cMAESOptimizer2.randn(cMAESOptimizer2.dimension));
                }
                CMAESOptimizer.copyColumn(realMatrix2, 0, realMatrix, n3);
                try {
                    object4[n3] = cMAESOptimizer$FitnessFunction.value(realMatrix.getColumn(n3));
                    continue;
                }
                catch (TooManyEvaluationsException tooManyEvaluationsException) {
                    break block2;
                }
            }
            double d3 = this.valueRange((CMAESOptimizer$ValuePenaltyPair[])object4);
            for (n2 = 0; n2 < ((CMAESOptimizer$ValuePenaltyPair[])object4).length; ++n2) {
                dArray[n2] = CMAESOptimizer$ValuePenaltyPair.access$000(object4[n2]) + CMAESOptimizer$ValuePenaltyPair.access$100(object4[n2]) * d3;
            }
            int[] nArray = this.sortedIndices(dArray);
            object4 = this.xmean;
            realMatrix = CMAESOptimizer.selectColumns(realMatrix, MathArrays.copyOf(nArray, this.mu));
            this.xmean = realMatrix.multiply(this.weights);
            RealMatrix realMatrix3 = CMAESOptimizer.selectColumns((RealMatrix)object3, MathArrays.copyOf(nArray, this.mu));
            RealMatrix realMatrix4 = realMatrix3.multiply(this.weights);
            n3 = this.updateEvolutionPaths(realMatrix4, (RealMatrix)object4) ? 1 : 0;
            if (this.diagonalOnly <= 0) {
                this.updateCovariance(n3 != 0, realMatrix, (RealMatrix)object3, nArray, (RealMatrix)object4);
            } else {
                this.updateCovarianceDiagonalOnly(n3 != 0, realMatrix3);
            }
            this.sigma *= FastMath.exp(FastMath.min(1.0, (this.normps / this.chiN - 1.0) * this.cs / this.damps));
            double d4 = dArray[nArray[0]];
            double d5 = dArray[nArray[nArray.length - 1]];
            if (d2 > d4) {
                d2 = d4;
                object2 = object;
                object = new PointValuePair(CMAESOptimizer$FitnessFunction.access$200(cMAESOptimizer$FitnessFunction, realMatrix.getColumn(0)), this.isMinimize ? d4 : -d4);
                if (this.getConvergenceChecker() != null && this.getConvergenceChecker().converged(this.iterations, (double[])object, (double[])object2)) break;
            }
            if (this.stopFitness != 0.0 && d4 < (this.isMinimize ? this.stopFitness : -this.stopFitness)) break;
            object3 = CMAESOptimizer.sqrt(this.diagC).getColumn(0);
            object4 = this.pc.getColumn(0);
            for (n = 0; n < this.dimension && !(this.sigma * FastMath.max(FastMath.abs((double)object4[n]), (double)object3[n]) > this.stopTolX); ++n) {
                if (n >= this.dimension - 1) break block2;
            }
            for (n = 0; n < this.dimension; ++n) {
                if (this.sigma * object3[n] > this.stopTolUpX) break block2;
            }
            double d6 = CMAESOptimizer.min(this.fitnessHistory);
            double d7 = CMAESOptimizer.max(this.fitnessHistory);
            if (this.iterations > 2 && FastMath.max(d7, d5) - FastMath.min(d6, d4) < this.stopTolFun || this.iterations > this.fitnessHistory.length && d7 - d6 < this.stopTolHistFun || CMAESOptimizer.max(this.diagD) / CMAESOptimizer.min(this.diagD) > 1.0E7) break;
            if (this.getConvergenceChecker() != null) {
                object3 = new PointValuePair(realMatrix.getColumn(0), this.isMinimize ? d4 : -d4);
                if (object2 != null && this.getConvergenceChecker().converged(this.iterations, (double[])object3, (double[])object2)) break;
                object2 = object3;
            }
            if (d2 == dArray[nArray[(int)(0.1 + (double)this.lambda / 4.0)]]) {
                this.sigma *= FastMath.exp(0.2 + this.cs / this.damps);
            }
            if (this.iterations > 2 && FastMath.max(d7, d4) - FastMath.min(d6, d4) == 0.0) {
                this.sigma *= FastMath.exp(0.2 + this.cs / this.damps);
            }
            CMAESOptimizer.push(this.fitnessHistory, d4);
            if (this.generateStatistics) {
                this.statisticsSigmaHistory.add(this.sigma);
                this.statisticsFitnessHistory.add(d4);
                this.statisticsMeanHistory.add(this.xmean.transpose());
                this.statisticsDHistory.add(this.diagD.transpose().scalarMultiply(100000.0));
            }
            ++this.iterations;
        }
        return object;
    }

    @Override
    protected void parseOptimizationData(OptimizationData ... optimizationDataArray) {
        super.parseOptimizationData(optimizationDataArray);
        for (OptimizationData optimizationData : optimizationDataArray) {
            if (optimizationData instanceof CMAESOptimizer$Sigma) {
                this.inputSigma = ((CMAESOptimizer$Sigma)optimizationData).getSigma();
                continue;
            }
            if (!(optimizationData instanceof CMAESOptimizer$PopulationSize)) continue;
            this.lambda = ((CMAESOptimizer$PopulationSize)optimizationData).getPopulationSize();
        }
        this.checkParameters();
    }

    private void checkParameters() {
        double[] dArray = this.getStartPoint();
        double[] dArray2 = this.getLowerBound();
        double[] dArray3 = this.getUpperBound();
        if (this.inputSigma != null) {
            if (this.inputSigma.length != dArray.length) {
                throw new DimensionMismatchException(this.inputSigma.length, dArray.length);
            }
            for (int i2 = 0; i2 < dArray.length; ++i2) {
                if (!(this.inputSigma[i2] > dArray3[i2] - dArray2[i2])) continue;
                throw new OutOfRangeException(this.inputSigma[i2], (Number)0, dArray3[i2] - dArray2[i2]);
            }
        }
    }

    private void initializeCMA(double[] dArray) {
        int n;
        if (this.lambda <= 0) {
            throw new NotStrictlyPositiveException(this.lambda);
        }
        double[][] dArray2 = new double[dArray.length][1];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            dArray2[i2][0] = this.inputSigma[i2];
        }
        Array2DRowRealMatrix array2DRowRealMatrix = new Array2DRowRealMatrix(dArray2, false);
        this.sigma = CMAESOptimizer.max(array2DRowRealMatrix);
        this.stopTolUpX = 1000.0 * CMAESOptimizer.max(array2DRowRealMatrix);
        this.stopTolX = 1.0E-11 * CMAESOptimizer.max(array2DRowRealMatrix);
        this.stopTolFun = 1.0E-12;
        this.stopTolHistFun = 1.0E-13;
        this.mu = this.lambda / 2;
        this.logMu2 = FastMath.log((double)this.mu + 0.5);
        this.weights = CMAESOptimizer.log(CMAESOptimizer.sequence(1.0, this.mu, 1.0)).scalarMultiply(-1.0).scalarAdd(this.logMu2);
        double d2 = 0.0;
        double d3 = 0.0;
        for (n = 0; n < this.mu; ++n) {
            double d4 = this.weights.getEntry(n, 0);
            d2 += d4;
            double d5 = d4;
            d3 += d5 * d5;
        }
        this.weights = this.weights.scalarMultiply(1.0 / d2);
        double d6 = d2;
        this.mueff = d6 * d6 / d3;
        this.cc = (4.0 + this.mueff / (double)this.dimension) / ((double)(this.dimension + 4) + 2.0 * this.mueff / (double)this.dimension);
        this.cs = (this.mueff + 2.0) / ((double)this.dimension + this.mueff + 3.0);
        this.damps = (1.0 + 2.0 * FastMath.max(0.0, FastMath.sqrt((this.mueff - 1.0) / (double)(this.dimension + 1)) - 1.0)) * FastMath.max(0.3, 1.0 - (double)this.dimension / (1.0E-6 + (double)this.maxIterations)) + this.cs;
        this.ccov1 = 2.0 / (((double)this.dimension + 1.3) * ((double)this.dimension + 1.3) + this.mueff);
        this.ccovmu = FastMath.min(1.0 - this.ccov1, 2.0 * (this.mueff - 2.0 + 1.0 / this.mueff) / ((double)((this.dimension + 2) * (this.dimension + 2)) + this.mueff));
        this.ccov1Sep = FastMath.min(1.0, this.ccov1 * ((double)this.dimension + 1.5) / 3.0);
        this.ccovmuSep = FastMath.min(1.0 - this.ccov1, this.ccovmu * ((double)this.dimension + 1.5) / 3.0);
        this.chiN = FastMath.sqrt(this.dimension) * (1.0 - 1.0 / (4.0 * (double)this.dimension) + 1.0 / (21.0 * (double)this.dimension * (double)this.dimension));
        this.xmean = MatrixUtils.createColumnRealMatrix(dArray);
        this.diagD = array2DRowRealMatrix.scalarMultiply(1.0 / this.sigma);
        this.diagC = CMAESOptimizer.square(this.diagD);
        this.pc = CMAESOptimizer.zeros(this.dimension, 1);
        this.ps = CMAESOptimizer.zeros(this.dimension, 1);
        this.normps = this.ps.getFrobeniusNorm();
        this.B = CMAESOptimizer.eye(this.dimension, this.dimension);
        this.D = CMAESOptimizer.ones(this.dimension, 1);
        this.BD = CMAESOptimizer.times(this.B, CMAESOptimizer.repmat(this.diagD.transpose(), this.dimension, 1));
        this.C = this.B.multiply(CMAESOptimizer.diag(CMAESOptimizer.square(this.D)).multiply(this.B.transpose()));
        this.historySize = 10 + (int)((double)(30 * this.dimension) / (double)this.lambda);
        this.fitnessHistory = new double[this.historySize];
        for (n = 0; n < this.historySize; ++n) {
            this.fitnessHistory[n] = Double.MAX_VALUE;
        }
    }

    private boolean updateEvolutionPaths(RealMatrix realMatrix, RealMatrix realMatrix2) {
        this.ps = this.ps.scalarMultiply(1.0 - this.cs).add(this.B.multiply(realMatrix).scalarMultiply(FastMath.sqrt(this.cs * (2.0 - this.cs) * this.mueff)));
        this.normps = this.ps.getFrobeniusNorm();
        boolean bl = this.normps / FastMath.sqrt(1.0 - FastMath.pow(1.0 - this.cs, 2 * this.iterations)) / this.chiN < 1.4 + 2.0 / ((double)this.dimension + 1.0);
        this.pc = this.pc.scalarMultiply(1.0 - this.cc);
        if (bl) {
            this.pc = this.pc.add(this.xmean.subtract(realMatrix2).scalarMultiply(FastMath.sqrt(this.cc * (2.0 - this.cc) * this.mueff) / this.sigma));
        }
        return bl;
    }

    private void updateCovarianceDiagonalOnly(boolean bl, RealMatrix realMatrix) {
        double d2 = bl ? 0.0 : this.ccov1Sep * this.cc * (2.0 - this.cc);
        d2 = d2 + (1.0 - this.ccov1Sep - this.ccovmuSep);
        this.diagC = this.diagC.scalarMultiply(d2).add(CMAESOptimizer.square(this.pc).scalarMultiply(this.ccov1Sep)).add(CMAESOptimizer.times(this.diagC, CMAESOptimizer.square(realMatrix).multiply(this.weights)).scalarMultiply(this.ccovmuSep));
        this.diagD = CMAESOptimizer.sqrt(this.diagC);
        if (this.diagonalOnly > 1 && this.iterations > this.diagonalOnly) {
            this.diagonalOnly = 0;
            this.B = CMAESOptimizer.eye(this.dimension, this.dimension);
            this.BD = CMAESOptimizer.diag(this.diagD);
            this.C = CMAESOptimizer.diag(this.diagC);
        }
    }

    private void updateCovariance(boolean bl, RealMatrix realMatrix, RealMatrix realMatrix2, int[] nArray, RealMatrix realMatrix3) {
        double d2 = 0.0;
        if (this.ccov1 + this.ccovmu > 0.0) {
            realMatrix = realMatrix.subtract(CMAESOptimizer.repmat(realMatrix3, 1, this.mu)).scalarMultiply(1.0 / this.sigma);
            realMatrix3 = this.pc.multiply(this.pc.transpose()).scalarMultiply(this.ccov1);
            double d3 = bl ? 0.0 : this.ccov1 * this.cc * (2.0 - this.cc);
            d3 = d3 + (1.0 - this.ccov1 - this.ccovmu);
            if (this.isActiveCMA) {
                d2 = (1.0 - this.ccovmu) * 0.25 * this.mueff / (FastMath.pow((double)(this.dimension + 2), 1.5) + 2.0 * this.mueff);
                Object object = CMAESOptimizer.reverse(nArray);
                RealMatrix realMatrix4 = CMAESOptimizer.selectColumns(realMatrix2, MathArrays.copyOf((int[])object, this.mu));
                object = realMatrix4;
                realMatrix2 = CMAESOptimizer.sqrt(CMAESOptimizer.sumRows(CMAESOptimizer.square(realMatrix4)));
                nArray = this.sortedIndices(realMatrix2.getRow(0));
                RealMatrix realMatrix5 = CMAESOptimizer.selectColumns(realMatrix2, nArray);
                int[] nArray2 = CMAESOptimizer.reverse(nArray);
                realMatrix2 = CMAESOptimizer.selectColumns(realMatrix2, nArray2);
                realMatrix2 = CMAESOptimizer.divide(realMatrix2, realMatrix5);
                double d4 = 0.33999999999999997 / CMAESOptimizer.square(realMatrix2 = CMAESOptimizer.selectColumns(realMatrix2, nArray = CMAESOptimizer.inverse(nArray))).multiply(this.weights).getEntry(0, 0);
                if (d2 > d4) {
                    d2 = d4;
                }
                object = CMAESOptimizer.times((RealMatrix)object, CMAESOptimizer.repmat(realMatrix2, this.dimension, 1));
                RealMatrix realMatrix6 = this.BD.multiply((RealMatrix)object);
                object = realMatrix6;
                object = realMatrix6.multiply(CMAESOptimizer.diag(this.weights)).multiply(object.transpose());
                this.C = this.C.scalarMultiply(d3 += d2 * 0.5).add(realMatrix3).add(realMatrix.scalarMultiply(this.ccovmu + d2 * 0.5).multiply(CMAESOptimizer.times(CMAESOptimizer.repmat(this.weights, 1, this.dimension), realMatrix.transpose()))).subtract(object.scalarMultiply(d2));
            } else {
                this.C = this.C.scalarMultiply(d3).add(realMatrix3).add(realMatrix.scalarMultiply(this.ccovmu).multiply(CMAESOptimizer.times(CMAESOptimizer.repmat(this.weights, 1, this.dimension), realMatrix.transpose())));
            }
        }
        this.updateBD(d2);
    }

    private void updateBD(double d2) {
        if (this.ccov1 + this.ccovmu + d2 > 0.0 && (double)this.iterations % 1.0 / (this.ccov1 + this.ccovmu + d2) / (double)this.dimension / 10.0 < 1.0) {
            double d3;
            this.C = CMAESOptimizer.triu(this.C, 0).add(CMAESOptimizer.triu(this.C, 1).transpose());
            EigenDecomposition eigenDecomposition = new EigenDecomposition(this.C);
            this.B = eigenDecomposition.getV();
            this.D = eigenDecomposition.getD();
            this.diagD = CMAESOptimizer.diag(this.D);
            if (CMAESOptimizer.min(this.diagD) <= 0.0) {
                for (int i2 = 0; i2 < this.dimension; ++i2) {
                    if (!(this.diagD.getEntry(i2, 0) < 0.0)) continue;
                    this.diagD.setEntry(i2, 0, 0.0);
                }
                d3 = CMAESOptimizer.max(this.diagD) / 1.0E14;
                this.C = this.C.add(CMAESOptimizer.eye(this.dimension, this.dimension).scalarMultiply(d3));
                this.diagD = this.diagD.add(CMAESOptimizer.ones(this.dimension, 1).scalarMultiply(d3));
            }
            if (CMAESOptimizer.max(this.diagD) > 1.0E14 * CMAESOptimizer.min(this.diagD)) {
                d3 = CMAESOptimizer.max(this.diagD) / 1.0E14 - CMAESOptimizer.min(this.diagD);
                this.C = this.C.add(CMAESOptimizer.eye(this.dimension, this.dimension).scalarMultiply(d3));
                this.diagD = this.diagD.add(CMAESOptimizer.ones(this.dimension, 1).scalarMultiply(d3));
            }
            this.diagC = CMAESOptimizer.diag(this.C);
            this.diagD = CMAESOptimizer.sqrt(this.diagD);
            this.BD = CMAESOptimizer.times(this.B, CMAESOptimizer.repmat(this.diagD.transpose(), this.dimension, 1));
        }
    }

    private static void push(double[] dArray, double d2) {
        for (int i2 = dArray.length - 1; i2 > 0; --i2) {
            dArray[i2] = dArray[i2 - 1];
        }
        dArray[0] = d2;
    }

    private int[] sortedIndices(double[] dArray) {
        Object[] objectArray = new CMAESOptimizer$DoubleIndex[dArray.length];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            objectArray[i2] = new CMAESOptimizer$DoubleIndex(dArray[i2], i2);
        }
        Arrays.sort(objectArray);
        int[] nArray = new int[dArray.length];
        for (int i3 = 0; i3 < dArray.length; ++i3) {
            nArray[i3] = CMAESOptimizer$DoubleIndex.access$300((CMAESOptimizer$DoubleIndex)objectArray[i3]);
        }
        return nArray;
    }

    private double valueRange(CMAESOptimizer$ValuePenaltyPair[] cMAESOptimizer$ValuePenaltyPairArray) {
        double d2 = Double.NEGATIVE_INFINITY;
        double d3 = Double.MAX_VALUE;
        for (CMAESOptimizer$ValuePenaltyPair cMAESOptimizer$ValuePenaltyPair : cMAESOptimizer$ValuePenaltyPairArray) {
            CMAESOptimizer$ValuePenaltyPair cMAESOptimizer$ValuePenaltyPair2;
            if (CMAESOptimizer$ValuePenaltyPair.access$000(cMAESOptimizer$ValuePenaltyPair2) > d2) {
                d2 = CMAESOptimizer$ValuePenaltyPair.access$000(cMAESOptimizer$ValuePenaltyPair);
            }
            if (!(CMAESOptimizer$ValuePenaltyPair.access$000(cMAESOptimizer$ValuePenaltyPair) < d3)) continue;
            d3 = CMAESOptimizer$ValuePenaltyPair.access$000(cMAESOptimizer$ValuePenaltyPair);
        }
        return d2 - d3;
    }

    private static RealMatrix log(RealMatrix realMatrix) {
        double[][] dArray = new double[realMatrix.getRowDimension()][realMatrix.getColumnDimension()];
        for (int i2 = 0; i2 < realMatrix.getRowDimension(); ++i2) {
            for (int i3 = 0; i3 < realMatrix.getColumnDimension(); ++i3) {
                dArray[i2][i3] = FastMath.log(realMatrix.getEntry(i2, i3));
            }
        }
        return new Array2DRowRealMatrix(dArray, false);
    }

    private static RealMatrix sqrt(RealMatrix realMatrix) {
        double[][] dArray = new double[realMatrix.getRowDimension()][realMatrix.getColumnDimension()];
        for (int i2 = 0; i2 < realMatrix.getRowDimension(); ++i2) {
            for (int i3 = 0; i3 < realMatrix.getColumnDimension(); ++i3) {
                dArray[i2][i3] = FastMath.sqrt(realMatrix.getEntry(i2, i3));
            }
        }
        return new Array2DRowRealMatrix(dArray, false);
    }

    private static RealMatrix square(RealMatrix realMatrix) {
        double[][] dArray = new double[realMatrix.getRowDimension()][realMatrix.getColumnDimension()];
        for (int i2 = 0; i2 < realMatrix.getRowDimension(); ++i2) {
            for (int i3 = 0; i3 < realMatrix.getColumnDimension(); ++i3) {
                double d2;
                double d3 = d2 = realMatrix.getEntry(i2, i3);
                dArray[i2][i3] = d3 * d3;
            }
        }
        return new Array2DRowRealMatrix(dArray, false);
    }

    private static RealMatrix times(RealMatrix realMatrix, RealMatrix realMatrix2) {
        double[][] dArray = new double[realMatrix.getRowDimension()][realMatrix.getColumnDimension()];
        for (int i2 = 0; i2 < realMatrix.getRowDimension(); ++i2) {
            for (int i3 = 0; i3 < realMatrix.getColumnDimension(); ++i3) {
                dArray[i2][i3] = realMatrix.getEntry(i2, i3) * realMatrix2.getEntry(i2, i3);
            }
        }
        return new Array2DRowRealMatrix(dArray, false);
    }

    private static RealMatrix divide(RealMatrix realMatrix, RealMatrix realMatrix2) {
        double[][] dArray = new double[realMatrix.getRowDimension()][realMatrix.getColumnDimension()];
        for (int i2 = 0; i2 < realMatrix.getRowDimension(); ++i2) {
            for (int i3 = 0; i3 < realMatrix.getColumnDimension(); ++i3) {
                dArray[i2][i3] = realMatrix.getEntry(i2, i3) / realMatrix2.getEntry(i2, i3);
            }
        }
        return new Array2DRowRealMatrix(dArray, false);
    }

    private static RealMatrix selectColumns(RealMatrix realMatrix, int[] nArray) {
        double[][] dArray = new double[realMatrix.getRowDimension()][nArray.length];
        for (int i2 = 0; i2 < realMatrix.getRowDimension(); ++i2) {
            for (int i3 = 0; i3 < nArray.length; ++i3) {
                dArray[i2][i3] = realMatrix.getEntry(i2, nArray[i3]);
            }
        }
        return new Array2DRowRealMatrix(dArray, false);
    }

    private static RealMatrix triu(RealMatrix realMatrix, int n) {
        double[][] dArray = new double[realMatrix.getRowDimension()][realMatrix.getColumnDimension()];
        for (int i2 = 0; i2 < realMatrix.getRowDimension(); ++i2) {
            for (int i3 = 0; i3 < realMatrix.getColumnDimension(); ++i3) {
                dArray[i2][i3] = i2 <= i3 - n ? realMatrix.getEntry(i2, i3) : 0.0;
            }
        }
        return new Array2DRowRealMatrix(dArray, false);
    }

    private static RealMatrix sumRows(RealMatrix realMatrix) {
        double[][] dArray = new double[1][realMatrix.getColumnDimension()];
        for (int i2 = 0; i2 < realMatrix.getColumnDimension(); ++i2) {
            double d2 = 0.0;
            for (int i3 = 0; i3 < realMatrix.getRowDimension(); ++i3) {
                d2 += realMatrix.getEntry(i3, i2);
            }
            dArray[0][i2] = d2;
        }
        return new Array2DRowRealMatrix(dArray, false);
    }

    private static RealMatrix diag(RealMatrix realMatrix) {
        if (realMatrix.getColumnDimension() == 1) {
            double[][] dArray = new double[realMatrix.getRowDimension()][realMatrix.getRowDimension()];
            for (int i2 = 0; i2 < realMatrix.getRowDimension(); ++i2) {
                dArray[i2][i2] = realMatrix.getEntry(i2, 0);
            }
            return new Array2DRowRealMatrix(dArray, false);
        }
        double[][] dArray = new double[realMatrix.getRowDimension()][1];
        for (int i3 = 0; i3 < realMatrix.getColumnDimension(); ++i3) {
            int n = i3;
            dArray[i3][0] = realMatrix.getEntry(n, n);
        }
        return new Array2DRowRealMatrix(dArray, false);
    }

    private static void copyColumn(RealMatrix realMatrix, int n, RealMatrix realMatrix2, int n2) {
        for (int i2 = 0; i2 < realMatrix.getRowDimension(); ++i2) {
            realMatrix2.setEntry(i2, n2, realMatrix.getEntry(i2, n));
        }
    }

    private static RealMatrix ones(int n, int n2) {
        double[][] dArray = new double[n][n2];
        for (int i2 = 0; i2 < n; ++i2) {
            Arrays.fill(dArray[i2], 1.0);
        }
        return new Array2DRowRealMatrix(dArray, false);
    }

    private static RealMatrix eye(int n, int n2) {
        double[][] dArray = new double[n][n2];
        for (int i2 = 0; i2 < n; ++i2) {
            if (i2 >= n2) continue;
            dArray[i2][i2] = 1.0;
        }
        return new Array2DRowRealMatrix(dArray, false);
    }

    private static RealMatrix zeros(int n, int n2) {
        return new Array2DRowRealMatrix(n, n2);
    }

    private static RealMatrix repmat(RealMatrix realMatrix, int n, int n2) {
        int n3 = realMatrix.getRowDimension();
        int n4 = realMatrix.getColumnDimension();
        double[][] dArray = new double[n * n3][n2 * n4];
        for (int i2 = 0; i2 < n * n3; ++i2) {
            for (int i3 = 0; i3 < n2 * n4; ++i3) {
                dArray[i2][i3] = realMatrix.getEntry(i2 % n3, i3 % n4);
            }
        }
        return new Array2DRowRealMatrix(dArray, false);
    }

    private static RealMatrix sequence(double d2, double d3, double d4) {
        int n = (int)((d3 - d2) / d4 + 1.0);
        double[][] dArray = new double[n][1];
        double d5 = d2;
        for (int i2 = 0; i2 < n; ++i2) {
            dArray[i2][0] = d5;
            d5 += d4;
        }
        return new Array2DRowRealMatrix(dArray, false);
    }

    private static double max(RealMatrix realMatrix) {
        double d2 = -1.7976931348623157E308;
        for (int i2 = 0; i2 < realMatrix.getRowDimension(); ++i2) {
            for (int i3 = 0; i3 < realMatrix.getColumnDimension(); ++i3) {
                double d3 = realMatrix.getEntry(i2, i3);
                if (!(d2 < d3)) continue;
                d2 = d3;
            }
        }
        return d2;
    }

    private static double min(RealMatrix realMatrix) {
        double d2 = Double.MAX_VALUE;
        for (int i2 = 0; i2 < realMatrix.getRowDimension(); ++i2) {
            for (int i3 = 0; i3 < realMatrix.getColumnDimension(); ++i3) {
                double d3 = realMatrix.getEntry(i2, i3);
                if (!(d2 > d3)) continue;
                d2 = d3;
            }
        }
        return d2;
    }

    private static double max(double[] dArray) {
        double d2 = -1.7976931348623157E308;
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            if (!(d2 < dArray[i2])) continue;
            d2 = dArray[i2];
        }
        return d2;
    }

    private static double min(double[] dArray) {
        double d2 = Double.MAX_VALUE;
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            if (!(d2 > dArray[i2])) continue;
            d2 = dArray[i2];
        }
        return d2;
    }

    private static int[] inverse(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray2[nArray[i2]] = i2;
        }
        return nArray2;
    }

    private static int[] reverse(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray2[i2] = nArray[nArray.length - i2 - 1];
        }
        return nArray2;
    }

    private double[] randn(int n) {
        double[] dArray = new double[n];
        for (int i2 = 0; i2 < n; ++i2) {
            dArray[i2] = this.random.nextGaussian();
        }
        return dArray;
    }

    private RealMatrix randn1(int n, int n2) {
        double[][] dArray = new double[n][n2];
        for (int i2 = 0; i2 < n; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                dArray[i2][i3] = this.random.nextGaussian();
            }
        }
        return new Array2DRowRealMatrix(dArray, false);
    }

    static /* synthetic */ boolean access$400(CMAESOptimizer cMAESOptimizer) {
        return cMAESOptimizer.isMinimize;
    }
}

