/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.nonlinear.scalar.noderiv;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.MultivariateFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathIllegalArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotStrictlyPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NullArgumentException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.OutOfRangeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.ZeroException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.OptimizationData;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.PointValuePair;
import java.util.Arrays;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSimplex
implements OptimizationData {
    private PointValuePair[] simplex;
    private double[][] startConfiguration;
    private final int dimension;

    protected AbstractSimplex(int n) {
        this(n, 1.0);
    }

    protected AbstractSimplex(int n, double d2) {
        this(AbstractSimplex.createHypercubeSteps(n, d2));
    }

    protected AbstractSimplex(double[] dArray) {
        if (dArray == null) {
            throw new NullArgumentException();
        }
        if (dArray.length == 0) {
            throw new ZeroException();
        }
        this.dimension = dArray.length;
        this.startConfiguration = new double[this.dimension][this.dimension];
        for (int i2 = 0; i2 < this.dimension; ++i2) {
            double[] dArray2 = this.startConfiguration[i2];
            for (int i3 = 0; i3 < i2 + 1; ++i3) {
                if (dArray[i3] == 0.0) {
                    throw new ZeroException((Localizable)LocalizedFormats.EQUAL_VERTICES_IN_SIMPLEX, new Object[0]);
                }
                System.arraycopy(dArray, 0, dArray2, 0, i3 + 1);
            }
        }
    }

    protected AbstractSimplex(double[][] dArray) {
        if (dArray.length <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.SIMPLEX_NEED_ONE_POINT, dArray.length);
        }
        this.dimension = dArray.length - 1;
        this.startConfiguration = new double[this.dimension][this.dimension];
        double[] dArray2 = dArray[0];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            double[] dArray3 = dArray[i2];
            if (dArray3.length != this.dimension) {
                throw new DimensionMismatchException(dArray3.length, this.dimension);
            }
            for (int i3 = 0; i3 < i2; ++i3) {
                double[] dArray4 = dArray[i3];
                boolean bl = true;
                for (int i4 = 0; i4 < this.dimension; ++i4) {
                    if (dArray3[i4] == dArray4[i4]) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                throw new MathIllegalArgumentException(LocalizedFormats.EQUAL_VERTICES_IN_SIMPLEX, i2, i3);
            }
            if (i2 <= 0) continue;
            double[] dArray5 = this.startConfiguration[i2 - 1];
            for (int i5 = 0; i5 < this.dimension; ++i5) {
                dArray5[i5] = dArray3[i5] - dArray2[i5];
            }
        }
    }

    public int getDimension() {
        return this.dimension;
    }

    public int getSize() {
        return this.simplex.length;
    }

    public abstract void iterate(MultivariateFunction var1, Comparator<PointValuePair> var2);

    public void build(double[] dArray) {
        if (this.dimension != dArray.length) {
            throw new DimensionMismatchException(this.dimension, dArray.length);
        }
        this.simplex = new PointValuePair[this.dimension + 1];
        this.simplex[0] = new PointValuePair(dArray, Double.NaN);
        for (int i2 = 0; i2 < this.dimension; ++i2) {
            double[] dArray2 = this.startConfiguration[i2];
            double[] dArray3 = new double[this.dimension];
            for (int i3 = 0; i3 < this.dimension; ++i3) {
                dArray3[i3] = dArray[i3] + dArray2[i3];
            }
            this.simplex[i2 + 1] = new PointValuePair(dArray3, Double.NaN);
        }
    }

    public void evaluate(MultivariateFunction multivariateFunction, Comparator<PointValuePair> comparator) {
        for (int i2 = 0; i2 < this.simplex.length; ++i2) {
            PointValuePair pointValuePair = this.simplex[i2];
            double[] dArray = pointValuePair.getPointRef();
            if (!Double.isNaN((Double)pointValuePair.getValue())) continue;
            this.simplex[i2] = new PointValuePair(dArray, multivariateFunction.value(dArray), false);
        }
        Arrays.sort(this.simplex, comparator);
    }

    protected void replaceWorstPoint(PointValuePair pointValuePair, Comparator<PointValuePair> comparator) {
        for (int i2 = 0; i2 < this.dimension; ++i2) {
            if (comparator.compare(this.simplex[i2], pointValuePair) <= 0) continue;
            PointValuePair pointValuePair2 = this.simplex[i2];
            this.simplex[i2] = pointValuePair;
            pointValuePair = pointValuePair2;
        }
        this.simplex[this.dimension] = pointValuePair;
    }

    public PointValuePair[] getPoints() {
        PointValuePair[] pointValuePairArray = new PointValuePair[this.simplex.length];
        System.arraycopy(this.simplex, 0, pointValuePairArray, 0, this.simplex.length);
        return pointValuePairArray;
    }

    public PointValuePair getPoint(int n) {
        if (n < 0 || n >= this.simplex.length) {
            throw new OutOfRangeException(n, (Number)0, this.simplex.length - 1);
        }
        return this.simplex[n];
    }

    protected void setPoint(int n, PointValuePair pointValuePair) {
        if (n < 0 || n >= this.simplex.length) {
            throw new OutOfRangeException(n, (Number)0, this.simplex.length - 1);
        }
        this.simplex[n] = pointValuePair;
    }

    protected void setPoints(PointValuePair[] pointValuePairArray) {
        if (pointValuePairArray.length != this.simplex.length) {
            throw new DimensionMismatchException(pointValuePairArray.length, this.simplex.length);
        }
        this.simplex = pointValuePairArray;
    }

    private static double[] createHypercubeSteps(int n, double d2) {
        double[] dArray = new double[n];
        for (int i2 = 0; i2 < n; ++i2) {
            dArray[i2] = d2;
        }
        return dArray;
    }
}

