/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.nonlinear.scalar.gradient;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.solvers.UnivariateSolver;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathInternalError;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathUnsupportedOperationException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.ConvergenceChecker;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.OptimizationData;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.PointValuePair;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.nonlinear.scalar.GoalType;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.nonlinear.scalar.GradientMultivariateOptimizer;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.nonlinear.scalar.LineSearch;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.nonlinear.scalar.gradient.NonLinearConjugateGradientOptimizer$1;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.nonlinear.scalar.gradient.NonLinearConjugateGradientOptimizer$Formula;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.nonlinear.scalar.gradient.NonLinearConjugateGradientOptimizer$IdentityPreconditioner;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.nonlinear.scalar.gradient.Preconditioner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonLinearConjugateGradientOptimizer
extends GradientMultivariateOptimizer {
    private final NonLinearConjugateGradientOptimizer$Formula updateFormula;
    private final Preconditioner preconditioner;
    private final LineSearch line;

    public NonLinearConjugateGradientOptimizer(NonLinearConjugateGradientOptimizer$Formula nonLinearConjugateGradientOptimizer$Formula, ConvergenceChecker<PointValuePair> convergenceChecker) {
        this(nonLinearConjugateGradientOptimizer$Formula, convergenceChecker, 1.0E-8, 1.0E-8, 1.0E-8, new NonLinearConjugateGradientOptimizer$IdentityPreconditioner());
    }

    @Deprecated
    public NonLinearConjugateGradientOptimizer(NonLinearConjugateGradientOptimizer$Formula nonLinearConjugateGradientOptimizer$Formula, ConvergenceChecker<PointValuePair> convergenceChecker, UnivariateSolver univariateSolver) {
        this(nonLinearConjugateGradientOptimizer$Formula, convergenceChecker, univariateSolver, new NonLinearConjugateGradientOptimizer$IdentityPreconditioner());
    }

    public NonLinearConjugateGradientOptimizer(NonLinearConjugateGradientOptimizer$Formula nonLinearConjugateGradientOptimizer$Formula, ConvergenceChecker<PointValuePair> convergenceChecker, double d2, double d3, double d4) {
        this(nonLinearConjugateGradientOptimizer$Formula, convergenceChecker, d2, d3, d4, new NonLinearConjugateGradientOptimizer$IdentityPreconditioner());
    }

    @Deprecated
    public NonLinearConjugateGradientOptimizer(NonLinearConjugateGradientOptimizer$Formula nonLinearConjugateGradientOptimizer$Formula, ConvergenceChecker<PointValuePair> convergenceChecker, UnivariateSolver univariateSolver, Preconditioner preconditioner) {
        this(nonLinearConjugateGradientOptimizer$Formula, convergenceChecker, univariateSolver.getRelativeAccuracy(), univariateSolver.getAbsoluteAccuracy(), univariateSolver.getAbsoluteAccuracy(), preconditioner);
    }

    public NonLinearConjugateGradientOptimizer(NonLinearConjugateGradientOptimizer$Formula nonLinearConjugateGradientOptimizer$Formula, ConvergenceChecker<PointValuePair> convergenceChecker, double d2, double d3, double d4, Preconditioner preconditioner) {
        super(convergenceChecker);
        this.updateFormula = nonLinearConjugateGradientOptimizer$Formula;
        this.preconditioner = preconditioner;
        this.line = new LineSearch(this, d2, d3, d4);
    }

    @Override
    public PointValuePair optimize(OptimizationData ... optimizationDataArray) {
        return super.optimize(optimizationDataArray);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected PointValuePair doOptimize() {
        var1_1 = this.getConvergenceChecker();
        var2_2 = this.getStartPoint();
        var3_3 = this.getGoalType();
        var4_4 = var2_2.length;
        var5_5 = this.computeObjectiveGradient(var2_2);
        if (var3_3 == GoalType.MINIMIZE) {
            for (var6_6 = 0; var6_6 < var4_4; ++var6_6) {
                var5_5[var6_6] = -var5_5[var6_6];
            }
        }
        var6_7 = this.preconditioner.precondition(var2_2, var5_5);
        var7_8 = (double[])var6_7.clone();
        var8_9 = 0.0;
        for (var10_10 = 0; var10_10 < var4_4; ++var10_10) {
            var8_9 += var5_5[var10_10] * var7_8[var10_10];
        }
        var10_11 = null;
        block6: while (true) {
            this.incrementIterationCount();
            var11_13 = this.computeObjectiveValue(var2_2);
            var5_5 = var10_11;
            var10_11 = new PointValuePair(var2_2, var11_13);
            if (var5_5 != null && var1_1.converged(this.getIterations(), (PointValuePair)var5_5, var10_11)) {
                return var10_11;
            }
            var14_15 = this.line.search(var2_2, var7_8).getPoint();
            for (var16_17 = 0; var16_17 < var2_2.length; ++var16_17) {
                v0 = var16_17;
                var2_2[v0] = var2_2[v0] + var14_15 * var7_8[var16_17];
            }
            var5_5 = this.computeObjectiveGradient(var2_2);
            if (var3_3 == GoalType.MINIMIZE) {
                for (var16_17 = 0; var16_17 < var4_4; ++var16_17) {
                    var5_5[var16_17] = -var5_5[var16_17];
                }
            }
            var16_16 = var8_9;
            var11_12 = this.preconditioner.precondition(var2_2, var5_5);
            var8_9 = 0.0;
            for (var19_19 = 0; var19_19 < var4_4; ++var19_19) {
                var8_9 += var5_5[var19_19] * var11_12[var19_19];
            }
            switch (NonLinearConjugateGradientOptimizer$1.$SwitchMap$org$apache$commons$math3$optim$nonlinear$scalar$gradient$NonLinearConjugateGradientOptimizer$Formula[this.updateFormula.ordinal()]) {
                case 1: {
                    var19_18 = var8_9 / var16_16;
                    break;
                }
                case 2: {
                    var21_20 = 0.0;
                    for (var12_14 = 0; var12_14 < var5_5.length; ++var12_14) {
                        var21_20 += var5_5[var12_14] * var6_7[var12_14];
                    }
                    var19_18 = (var8_9 - var21_20) / var16_16;
                    break;
                }
                default: {
                    throw new MathInternalError();
                }
            }
            var6_7 = var11_12;
            if (this.getIterations() % var4_4 == 0 || var19_18 < 0.0) {
                var7_8 = (double[])var6_7.clone();
                continue;
            }
            var21_21 = 0;
            while (true) {
                if (var21_21 < var4_4) ** break;
                continue block6;
                var7_8[var21_21] = var6_7[var21_21] + var19_18 * var7_8[var21_21];
                ++var21_21;
            }
            break;
        }
    }

    @Override
    protected void parseOptimizationData(OptimizationData ... optimizationDataArray) {
        super.parseOptimizationData(optimizationDataArray);
        this.checkParameters();
    }

    private void checkParameters() {
        if (this.getLowerBound() != null || this.getUpperBound() != null) {
            throw new MathUnsupportedOperationException(LocalizedFormats.CONSTRAINT, new Object[0]);
        }
    }
}

