/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.nonlinear.scalar;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.MultivariateFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooSmallException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;

public class MultivariateFunctionPenaltyAdapter
implements MultivariateFunction {
    private final MultivariateFunction bounded;
    private final double[] lower;
    private final double[] upper;
    private final double offset;
    private final double[] scale;

    public MultivariateFunctionPenaltyAdapter(MultivariateFunction multivariateFunction, double[] dArray, double[] dArray2, double d2, double[] dArray3) {
        MathUtils.checkNotNull(dArray);
        MathUtils.checkNotNull(dArray2);
        MathUtils.checkNotNull(dArray3);
        if (dArray.length != dArray2.length) {
            throw new DimensionMismatchException(dArray.length, dArray2.length);
        }
        if (dArray.length != dArray3.length) {
            throw new DimensionMismatchException(dArray.length, dArray3.length);
        }
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            if (dArray2[i2] >= dArray[i2]) continue;
            throw new NumberIsTooSmallException(dArray2[i2], (Number)dArray[i2], true);
        }
        this.bounded = multivariateFunction;
        this.lower = (double[])dArray.clone();
        this.upper = (double[])dArray2.clone();
        this.offset = d2;
        this.scale = (double[])dArray3.clone();
    }

    public double value(double[] dArray) {
        for (int i2 = 0; i2 < this.scale.length; ++i2) {
            if (!(dArray[i2] < this.lower[i2]) && !(dArray[i2] > this.upper[i2])) continue;
            double d2 = 0.0;
            while (i2 < this.scale.length) {
                double d3 = dArray[i2] < this.lower[i2] ? this.scale[i2] * (this.lower[i2] - dArray[i2]) : (dArray[i2] > this.upper[i2] ? this.scale[i2] * (dArray[i2] - this.upper[i2]) : 0.0);
                d2 += FastMath.sqrt(d3);
                ++i2;
            }
            return this.offset + d2;
        }
        return this.bounded.value(dArray);
    }
}

