/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.nonlinear.scalar;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.MultivariateFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooSmallException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.nonlinear.scalar.MultivariateFunctionMappingAdapter$LowerBoundMapper;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.nonlinear.scalar.MultivariateFunctionMappingAdapter$LowerUpperBoundMapper;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.nonlinear.scalar.MultivariateFunctionMappingAdapter$Mapper;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.nonlinear.scalar.MultivariateFunctionMappingAdapter$NoBoundsMapper;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.nonlinear.scalar.MultivariateFunctionMappingAdapter$UpperBoundMapper;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathUtils;

public class MultivariateFunctionMappingAdapter
implements MultivariateFunction {
    private final MultivariateFunction bounded;
    private final MultivariateFunctionMappingAdapter$Mapper[] mappers;

    public MultivariateFunctionMappingAdapter(MultivariateFunction multivariateFunction, double[] dArray, double[] dArray2) {
        int n;
        MathUtils.checkNotNull(dArray);
        MathUtils.checkNotNull(dArray2);
        if (dArray.length != dArray2.length) {
            throw new DimensionMismatchException(dArray.length, dArray2.length);
        }
        for (n = 0; n < dArray.length; ++n) {
            if (dArray2[n] >= dArray[n]) continue;
            throw new NumberIsTooSmallException(dArray2[n], (Number)dArray[n], true);
        }
        this.bounded = multivariateFunction;
        this.mappers = new MultivariateFunctionMappingAdapter$Mapper[dArray.length];
        for (n = 0; n < this.mappers.length; ++n) {
            if (Double.isInfinite(dArray[n])) {
                if (Double.isInfinite(dArray2[n])) {
                    this.mappers[n] = new MultivariateFunctionMappingAdapter$NoBoundsMapper(null);
                    continue;
                }
                this.mappers[n] = new MultivariateFunctionMappingAdapter$UpperBoundMapper(dArray2[n]);
                continue;
            }
            this.mappers[n] = Double.isInfinite(dArray2[n]) ? new MultivariateFunctionMappingAdapter$LowerBoundMapper(dArray[n]) : new MultivariateFunctionMappingAdapter$LowerUpperBoundMapper(dArray[n], dArray2[n]);
        }
    }

    public double[] unboundedToBounded(double[] dArray) {
        double[] dArray2 = new double[this.mappers.length];
        for (int i2 = 0; i2 < this.mappers.length; ++i2) {
            dArray2[i2] = this.mappers[i2].unboundedToBounded(dArray[i2]);
        }
        return dArray2;
    }

    public double[] boundedToUnbounded(double[] dArray) {
        double[] dArray2 = new double[this.mappers.length];
        for (int i2 = 0; i2 < this.mappers.length; ++i2) {
            dArray2[i2] = this.mappers[i2].boundedToUnbounded(dArray[i2]);
        }
        return dArray2;
    }

    public double value(double[] dArray) {
        return this.bounded.value(this.unboundedToBounded(dArray));
    }
}

