/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.optim.nonlinear.scalar;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.MultivariateFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.MultivariateVectorFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.linear.RealMatrix;

public class LeastSquaresConverter
implements MultivariateFunction {
    private final MultivariateVectorFunction function;
    private final double[] observations;
    private final double[] weights;
    private final RealMatrix scale;

    public LeastSquaresConverter(MultivariateVectorFunction multivariateVectorFunction, double[] dArray) {
        this.function = multivariateVectorFunction;
        this.observations = (double[])dArray.clone();
        this.weights = null;
        this.scale = null;
    }

    public LeastSquaresConverter(MultivariateVectorFunction multivariateVectorFunction, double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new DimensionMismatchException(dArray.length, dArray2.length);
        }
        this.function = multivariateVectorFunction;
        this.observations = (double[])dArray.clone();
        this.weights = (double[])dArray2.clone();
        this.scale = null;
    }

    public LeastSquaresConverter(MultivariateVectorFunction multivariateVectorFunction, double[] dArray, RealMatrix realMatrix) {
        if (dArray.length != realMatrix.getColumnDimension()) {
            throw new DimensionMismatchException(dArray.length, realMatrix.getColumnDimension());
        }
        this.function = multivariateVectorFunction;
        this.observations = (double[])dArray.clone();
        this.weights = null;
        this.scale = realMatrix.copy();
    }

    public double value(double[] dArray) {
        if ((dArray = this.function.value(dArray)).length != this.observations.length) {
            throw new DimensionMismatchException(dArray.length, this.observations.length);
        }
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            int n = i2;
            dArray[n] = dArray[n] - this.observations[i2];
        }
        double d2 = 0.0;
        if (this.weights != null) {
            for (int i3 = 0; i3 < dArray.length; ++i3) {
                double d3 = dArray[i3];
                d2 += this.weights[i3] * d3 * d3;
            }
        } else if (this.scale != null) {
            double[] dArray2 = this.scale.operate(dArray);
            int n = dArray2.length;
            for (int i4 = 0; i4 < n; ++i4) {
                double d4;
                double d5 = d4 = dArray2[i4];
                d2 += d5 * d5;
            }
        } else {
            double[] dArray3 = dArray;
            int n = dArray.length;
            for (int i5 = 0; i5 < n; ++i5) {
                double d6;
                double d7 = d6 = dArray3[i5];
                d2 += d7 * d7;
            }
        }
        return d2;
    }
}

